/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.wiki.util;

import com.aimluck.eip.cayenne.om.portlet.EipTWiki;
import com.aimluck.eip.cayenne.om.portlet.EipTWikiFile;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.io.IOUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WikiFileUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WikiFileUtils.class.getName());
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    private static final String FOLDER_FILEDIR_WIKI = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    private static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.wiki.categorykey", (String)"");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FileuploadLiteBean> getFileuploadList(RunData rundata) {
        int fileid;
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadLiteBean> fileNameList = new ArrayList<FileuploadLiteBean>();
        FileuploadLiteBean filebean = null;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName");
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            for (String newfileid : newfileids) {
                if ("".equals(newfileid)) continue;
                fileid = 0;
                try {
                    fileid = Integer.parseInt(newfileid);
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName(ALLocalizationUtils.getl10n((String)"WIKI_PREVIOUS_PICTURE_FILE"));
                    fileNameList.add(filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(ALStorageService.getFile((String)FileuploadUtils.FOLDER_TMP_FOR_ATTACHMENT_FILES, (String)(ALEipUtils.getUserId((RunData)rundata) + ALStorageService.separator() + folderName), (String)(fileid + ".txt")), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) {
                        IOUtils.closeQuietly((Reader)reader);
                        continue;
                    }
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName(newfileid);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add(filebean);
                    IOUtils.closeQuietly((Reader)reader);
                }
                catch (Exception e) {
                    logger.error((Object)"getFileuploadList", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(reader);
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (String hadfileid : hadfileids) {
                fileid = 0;
                try {
                    fileid = Integer.parseInt(hadfileid);
                    hadfileidsValue.add(fileid);
                }
                catch (Exception e) {}
            }
            try {
                SelectQuery reqquery = Database.query(EipTWikiFile.class);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = reqquery.fetchList();
                for (EipTWikiFile file : requests) {
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getFileName());
                    filebean.setFlagNewFile(false);
                    fileNameList.add(filebean);
                }
            }
            catch (Exception e) {
                logger.error((Object)"WikiUtils.getFileuploadList", (Throwable)e);
            }
        }
        return fileNameList;
    }

    public static boolean insertFileDataDelegate(RunData rundata, Context context, EipTWiki wiki, List<FileuploadLiteBean> fileuploadList, String folderName, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            fileuploadList = new ArrayList<FileuploadLiteBean>();
        }
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String orgId = Database.getDomainName();
        ArrayList<Integer> hadfileids = new ArrayList<Integer>();
        for (FileuploadLiteBean file : fileuploadList) {
            if (file.isNewFile()) continue;
            hadfileids.add(file.getFileId());
        }
        SelectQuery dbquery = Database.query(EipTWikiFile.class);
        dbquery.andQualifier(ExpressionFactory.matchExp((String)"wikiId", (Object)wiki.getWikiId()));
        List existsFiles = dbquery.fetchList();
        ArrayList<EipTWikiFile> delFiles = new ArrayList<EipTWikiFile>();
        for (EipTWikiFile file : existsFiles) {
            if (hadfileids.contains(file.getFileId())) continue;
            delFiles.add(file);
        }
        if (delFiles.size() > 0) {
            int delsize = delFiles.size();
            for (int i = 0; i < delsize; ++i) {
                ALStorageService.deleteFile((String)(WikiFileUtils.getSaveDirPath(orgId, uid) + ((EipTWikiFile)delFiles.get(i)).getFilePath()));
            }
            Database.deleteAll(delFiles);
        }
        try {
            for (FileuploadLiteBean filebean : fileuploadList) {
                if (!filebean.isNewFile()) continue;
                String[] acceptExts = ImageIO.getWriterFormatNames();
                FileuploadUtils.ShrinkImageSet shrinkImageSet = FileuploadUtils.getBytesShrinkFilebean((String)orgId, (String)folderName, (int)uid, (FileuploadLiteBean)filebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)true);
                String filename = "0_" + String.valueOf(System.nanoTime());
                EipTWikiFile file = (EipTWikiFile)Database.create(EipTWikiFile.class);
                file.setOwnerId(Integer.valueOf(uid));
                file.setEipTWiki(wiki);
                file.setFileName(filebean.getFileName());
                file.setFilePath(WikiFileUtils.getRelativePath(filename));
                if (shrinkImageSet != null && shrinkImageSet.getShrinkImage() != null) {
                    file.setFileThumbnail(shrinkImageSet.getShrinkImage());
                }
                file.setCreateDate(Calendar.getInstance().getTime());
                file.setUpdateDate(Calendar.getInstance().getTime());
                if (shrinkImageSet != null && shrinkImageSet.getFixImage() != null) {
                    ALStorageService.createNewFile((InputStream)new ByteArrayInputStream(shrinkImageSet.getFixImage()), (String)(FOLDER_FILEDIR_WIKI + ALStorageService.separator() + Database.getDomainName() + ALStorageService.separator() + CATEGORY_KEY + ALStorageService.separator() + uid + ALStorageService.separator() + filename));
                    continue;
                }
                ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(filebean.getFileId()), (String)FOLDER_FILEDIR_WIKI, (String)(CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
            }
            ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"WikiFileUtils.insertFileDataDelegate", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_WIKI, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static List<FileuploadBean> getAttachmentFiles(Integer wikiId) {
        SelectQuery query = Database.query(EipTWikiFile.class);
        query.where(Operations.eq((String)"wikiId", (Object)wikiId));
        query.orderAscending("updateDate");
        query.orderAscending("filePath");
        List result = query.fetchList();
        ArrayList<FileuploadBean> beanlist = new ArrayList<FileuploadBean>();
        for (EipTWikiFile file : result) {
            FileuploadBean bean = new FileuploadBean();
            bean.initField();
            bean.setFileId(file.getFileId().intValue());
            bean.setFileName(file.getFileName());
            bean.setFlagNewFile(false);
            DataHandler hData = new DataHandler((DataSource)new FileDataSource(file.getFileName()));
            if (hData != null) {
                bean.setContentType(hData.getContentType());
            }
            bean.setIsImage(FileuploadUtils.isImage((String)file.getFileName()));
            beanlist.add(bean);
        }
        return beanlist;
    }

    public static EipTWikiFile getEipTWikiFile(RunData rundata) {
        int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
        if (attachmentIndex < 0) {
            return null;
        }
        SelectQuery query = Database.query(EipTWikiFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
        query.andQualifier(exp);
        return (EipTWikiFile)query.fetchSingle();
    }

    public static void deleteFiles(Integer wikiId) throws ALFileNotRemovedException {
        if (null == wikiId) {
            return;
        }
        String orgId = Database.getDomainName();
        SelectQuery query = Database.query(EipTWikiFile.class);
        query.setQualifier(ExpressionFactory.matchExp((String)"wikiId", (Object)wikiId));
        List fileList = query.fetchList();
        try {
            for (EipTWikiFile file : fileList) {
                ALStorageService.deleteFile((String)(WikiFileUtils.getSaveDirPath(orgId, file.getOwnerId()) + file.getFilePath()));
            }
        }
        catch (Exception e) {
            throw new ALFileNotRemovedException((Throwable)e);
        }
    }
}

