/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.wiki.util;

import com.aimluck.eip.cayenne.om.portlet.EipTWiki;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.wiki.WikiResultData;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WikiUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WikiUtils.class.getName());
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String TARGET_USER_ID = "target_user_id";
    public static final String TARGET_KEYWORD = "keyword";
    private static final String RESET_KEYWORD_FLAG = "reset_keyword_params";
    private static final String RESET_TARGET_FLAG = "reset_target_params";
    private static final String RESET_FLAG = "reset_params";
    public static final int LIMIT_STATE_BEFORE = -1;
    public static final int LIMIT_STATE_TODAY = 0;
    public static final int LIMIT_STATE_AFTER = 1;
    public static final String WIKI_PORTLET_NAME = "Wiki";
    public static final int PARENT_WIKI = 0;

    public static EipTWiki getEipTWikiCategory(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (categoryid == null || Integer.valueOf(categoryid) == null) {
            logger.debug((Object)"[Wiki] Empty ID...");
            throw new ALPageNotFoundException();
        }
        EipTWiki category = WikiUtils.getEipTWikiCategory(Integer.parseInt(categoryid));
        if (null == category) {
            throw new ALPageNotFoundException();
        }
        return category;
    }

    public static EipTWiki getEipTWikiCategory(Integer integer) {
        try {
            SelectQuery query = Database.query(EipTWiki.class);
            return (EipTWiki)query.setQualifier(ExpressionFactory.matchExp((String)"parentId", (Object)integer)).fetchSingle();
        }
        catch (Exception ex) {
            logger.error((Object)"wiki", (Throwable)ex);
            return null;
        }
    }

    public static List<WikiResultData> loadTopWikiList(RunData rundata) {
        ArrayList<WikiResultData> categoryList = new ArrayList<WikiResultData>();
        try {
            SelectQuery query = Database.query(EipTWiki.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"parentId", (Object)0));
            List aList = query.orderAscending("wikiName").fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTWiki record = (EipTWiki)aList.get(i);
                WikiResultData rd = new WikiResultData();
                rd.initField();
                rd.setId(record.getWikiId().longValue());
                rd.setName(record.getWikiName());
                rd.setUpdateUser(ALEipUtils.getALEipUser((int)record.getUpdateUserId()).getAliasName().getValue());
                rd.setCreateDate(record.getCreateDate());
                rd.setUpdateDate(record.getUpdateDate());
                categoryList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"wiki", (Throwable)ex);
            return null;
        }
        return categoryList;
    }

    public static String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = rundata.getParameters().getString(TARGET_GROUP_NAME);
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    public static String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = rundata.getParameters().getString(TARGET_USER_ID);
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID);
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)"all");
            target_user_id = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)idParam);
            target_user_id = idParam;
        }
        return target_user_id;
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static boolean hasResetKeywordFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_KEYWORD_FLAG);
        return resetflag != null;
    }

    public static void resetKeyword(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
    }

    public static boolean hasResetTargetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_TARGET_FLAG);
        return resetflag != null;
    }

    public static void resetTarget(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)"all");
    }

    public static boolean hasResetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_FLAG);
        return resetflag != null;
    }

    public static void resetFilter(RunData rundata, Context context, String className) {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)new StringBuffer().append(className).append("filter").toString());
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)new StringBuffer().append(className).append("filtertype").toString());
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
    }

    public static EipTWiki getEipTWiki(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (StringUtils.isEmpty((String)id)) {
                return null;
            }
            return (EipTWiki)Database.get(EipTWiki.class, (Object)Integer.valueOf(id));
        }
        catch (Exception e) {
            logger.error((Object)"[WikiUtils]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    public static EipTWiki getEipTWiki(Integer pk) {
        return (EipTWiki)Database.get(EipTWiki.class, (Object)pk);
    }

    public static int getEipTWikiCategoryWikiCount(EipTWiki category) {
        SelectQuery query = Database.query(EipTWiki.class);
        query.setQualifier(ExpressionFactory.matchDbExp((String)"parentId", (Object)category.getWikiId()));
        return query.getCount();
    }

    public static boolean isTitleDuplicate(String title, Integer parentId) {
        return WikiUtils.isTitleDuplicate(title, parentId, null);
    }

    public static boolean isTitleDuplicate(String title, Integer parentId, Integer pk) {
        int result;
        SelectQuery query = Database.query(EipTWiki.class);
        Expression titleExp = ExpressionFactory.likeIgnoreCaseExp((String)"wikiName", (Object)title);
        Expression parentExp = ExpressionFactory.matchExp((String)"parentId", (Object)parentId);
        query.andQualifier(titleExp).andQualifier(parentExp);
        if (pk != null) {
            Expression pkExp = ExpressionFactory.noMatchDbExp((String)"WIKI_ID", (Object)pk);
            query.andQualifier(pkExp);
        }
        return (result = query.getCount()) != 0;
    }

    public static EipTWiki getEipTWiki(String name, String parentId) {
        SelectQuery query = Database.query(EipTWiki.class);
        Expression nameExp = ExpressionFactory.likeIgnoreCaseExp((String)"wikiName", (Object)name);
        Expression parentExp = ExpressionFactory.matchExp((String)"parentId", (Object)parentId);
        query.setQualifier(nameExp.andExp(parentExp));
        query.orderAscending("wikiName");
        return (EipTWiki)query.fetchSingle();
    }

    public static EipTWiki getEipTWikiOne() {
        SelectQuery query = Database.query(EipTWiki.class);
        Expression parentExp = ExpressionFactory.matchExp((String)"parentId", (Object)0);
        query.setQualifier(parentExp);
        query.orderAscending("wikiName");
        return (EipTWiki)query.fetchSingle();
    }

    public static int getChildCount(Integer parentId) {
        SelectQuery query = Database.query(EipTWiki.class);
        Expression exp = ExpressionFactory.matchExp((String)"parentId", (Object)parentId);
        return query.andQualifier(exp).getCount();
    }

    public static String getWikiIdFromSession(String filter, String filterType) {
        String sesFilterType;
        String sesFilter = filter == null ? "" : filter;
        String string = sesFilterType = filterType == null ? "" : filterType;
        if ("category".equals(sesFilterType)) {
            if (StringUtils.isNotEmpty((String)sesFilter) && StringUtils.isNumeric((String)sesFilter)) {
                return sesFilter;
            }
        } else if ("post,category".equals(sesFilterType)) {
            String[] splited = filter.split(",");
            if (splited.length < 2) {
                return "";
            }
            String id = filter.split(",")[1];
            if (StringUtils.isNotEmpty((String)id) && StringUtils.isNumeric((String)id)) {
                return id;
            }
        }
        return "";
    }

    public static boolean existWiki(String wikiId, List<WikiResultData> topWikiList) {
        for (WikiResultData data : topWikiList) {
            if (!data.getId().toString().equals(wikiId)) continue;
            return true;
        }
        return false;
    }
}

