/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTask;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.project.ProjectTaskResultData;
import com.aimluck.eip.project.util.ProjectUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ProjectTaskChangeTurnFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectTaskChangeTurnFormData.class.getName());
    private ALStringField positions;
    private String[] taskIds = null;
    private List<ProjectTaskResultData> taskList = null;
    private List<EipTProjectTask> rawProjectTaskList = null;
    private String projectId = null;
    private String parentTaskId = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.taskList = new ArrayList<ProjectTaskResultData>();
        this.rawProjectTaskList = new ArrayList<EipTProjectTask>();
        this.projectId = rundata.getParameters().getString("projectid");
        this.parentTaskId = rundata.getParameters().getString("parent_task_id");
    }

    public void initField() {
        this.positions = new ALStringField();
        this.positions.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_TASK_LIST"));
        this.positions.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = true;
        try {
            res = super.setFormData(rundata, context, msgList);
            if (res) {
                if (this.positions.getValue() == null || this.positions.getValue().equals("")) {
                    SelectQuery query = Database.query(EipTProjectTask.class);
                    query.andQualifier(ExpressionFactory.matchExp((String)"parentTaskId", (Object)this.parentTaskId));
                    query.andQualifier(ExpressionFactory.matchExp((String)"projectId", (Object)this.projectId));
                    query.orderAscending("orderNo");
                    this.taskList = ProjectUtils.getProjectTaskResultList(query.fetchList());
                } else {
                    StringTokenizer st = new StringTokenizer(this.positions.getValue(), ",");
                    this.taskIds = new String[st.countTokens()];
                    int count = 0;
                    while (st.hasMoreTokens()) {
                        this.taskIds[count] = st.nextToken();
                        ++count;
                    }
                    SelectQuery query = Database.query(EipTProjectTask.class);
                    List list = query.fetchList();
                    for (int i = 0; i < this.taskIds.length; ++i) {
                        EipTProjectTask task = this.getEipTProjectTaskFromTaskId(list, this.taskIds[i]);
                        this.taskList.add(ProjectUtils.getProjectTaskResultData(task));
                        this.rawProjectTaskList.add(task);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        try {
            int newPosition = 1;
            for (EipTProjectTask task : this.rawProjectTaskList) {
                task.setOrderNo(Integer.valueOf(newPosition));
                ++newPosition;
            }
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    private EipTProjectTask getEipTProjectTaskFromTaskId(List<EipTProjectTask> taskList, String taskId) {
        for (int i = 0; i < taskList.size(); ++i) {
            EipTProjectTask task = taskList.get(i);
            if (!task.getTaskId().toString().equals(taskId)) continue;
            return task;
        }
        return null;
    }

    public List<ProjectTaskResultData> getProjectTaskList() {
        return this.taskList;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }
}

