/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.eip.cayenne.om.portlet.EipTProjectTask;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.project.util.ProjectFormUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ProjectTaskProgressFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectTaskProgressFormData.class.getName());
    private String name = null;
    private String taskId = null;
    private String value = null;
    private Integer loginUserId = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.name = rundata.getParameters().getString("name", "");
        this.taskId = rundata.getParameters().getString("taskId", "");
        this.value = rundata.getParameters().getString("value", "");
        this.loginUserId = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return true;
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        if ("progress_rate".equals(this.name)) {
            if (StringUtils.isEmpty((String)this.taskId) || StringUtils.isEmpty((String)this.value) || !StringUtils.isNumeric((String)this.taskId) || !StringUtils.isNumeric((String)this.value)) {
                msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_UPDATE_ERROR"));
            }
            if (!ProjectFormUtils.isEditable(this.taskId, this.loginUserId)) {
                msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_TASK_NOT_UPDATE"));
            }
        }
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        try {
            if ("progress_rate".equals(this.name)) {
                EipTProjectTask task = (EipTProjectTask)Database.get(EipTProjectTask.class, (Object)Integer.valueOf(this.taskId));
                if (null == task) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_UPDATE_ERROR"));
                    return false;
                }
                if ("100".equals(this.value)) {
                    task.setStatus("4");
                } else if (task.getProgressRate() == 100 && !"100".equals(this.value)) {
                    task.setStatus("2");
                }
                task.setProgressRate(Integer.valueOf(this.value));
                task.setUpdateDate(new Date());
                Database.commit();
                ProjectFormUtils.updateProject(task.getProjectId(), ALEipUtils.getUserId((RunData)rundata));
            }
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }
}

