/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.project.ProjectTaskCommentResultData;
import com.aimluck.eip.project.ProjectTaskMemberResultData;
import com.aimluck.eip.project.util.ProjectUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ProjectTaskResultData
implements ALData {
    protected ALNumberField task_id;
    protected ALNumberField parent_task_id;
    protected ALStringField parent_task_name;
    protected ALNumberField project_id;
    protected ALStringField tracker;
    protected ALStringField task_name;
    protected ALStringField explanation;
    protected ALStringField status;
    protected ALStringField priority;
    protected ALDateTimeField start_plan_date;
    protected ALDateTimeField end_plan_date;
    protected ALNumberField plan_term;
    protected ALDateTimeField start_date;
    protected ALDateTimeField end_date;
    protected BigDecimal plan_workload;
    protected BigDecimal workload;
    protected BigDecimal forecast_workload;
    protected ALNumberField plan_progress_rate;
    protected ALNumberField progress_rate;
    private List<ProjectTaskMemberResultData> memberList = null;
    private ALNumberField login_user_id;
    protected ALDateTimeField create_date;
    protected ALDateTimeField update_date;
    private List<FileuploadBean> attachmentFileList = null;
    private List<ProjectTaskCommentResultData> commentList = null;
    private boolean resultDisplayFlg;
    private boolean hasChildren;
    private boolean hasChildrenForForm;
    private boolean indentFlg;
    private ALNumberField indent;
    private ALStringField topicPath;
    private final DecimalFormat df = new DecimalFormat("#.0##");
    private boolean editable;

    public void initField() {
        this.task_id = new ALNumberField();
        this.parent_task_id = new ALNumberField();
        this.parent_task_name = new ALStringField();
        this.project_id = new ALNumberField();
        this.tracker = new ALStringField();
        this.task_name = new ALStringField();
        this.explanation = new ALStringField();
        this.status = new ALStringField();
        this.priority = new ALStringField();
        this.start_plan_date = new ALDateTimeField();
        this.end_plan_date = new ALDateTimeField();
        this.plan_term = new ALNumberField();
        this.start_date = new ALDateTimeField();
        this.end_date = new ALDateTimeField();
        this.plan_workload = new BigDecimal(0);
        this.workload = new BigDecimal(0);
        this.forecast_workload = new BigDecimal(0);
        this.plan_progress_rate = new ALNumberField();
        this.progress_rate = new ALNumberField();
        this.memberList = new ArrayList<ProjectTaskMemberResultData>();
        this.login_user_id = new ALNumberField();
        this.create_date = new ALDateTimeField();
        this.update_date = new ALDateTimeField();
        this.attachmentFileList = new ArrayList<FileuploadBean>();
        this.commentList = new ArrayList<ProjectTaskCommentResultData>();
        this.indent = new ALNumberField();
        this.topicPath = new ALStringField();
        this.resultDisplayFlg = true;
        this.hasChildren = false;
        this.indentFlg = false;
        this.hasChildrenForForm = false;
        this.editable = false;
    }

    public ALNumberField getTaskId() {
        return this.task_id;
    }

    public void setTaskId(long i) {
        this.task_id.setValue(i);
    }

    public ALNumberField getParentTaskId() {
        return this.parent_task_id;
    }

    public void setParentTaskId(long i) {
        this.parent_task_id.setValue(i);
    }

    public String getParentTaskName() {
        return ALCommonUtils.replaceToAutoCR((String)this.parent_task_name.toString());
    }

    public void setParentTaskName(String string) {
        this.parent_task_name.setValue(string);
    }

    public ALNumberField getProjectId() {
        return this.project_id;
    }

    public void setProjectId(long i) {
        this.project_id.setValue(i);
    }

    public String getTracker() {
        return ALCommonUtils.replaceToAutoCR((String)this.tracker.toString());
    }

    public void setTracker(String string) {
        this.tracker.setValue(string);
    }

    public ALStringField getTaskName() {
        return this.task_name;
    }

    public String getTaskNameHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.task_name.toString());
    }

    public void setTaskName(String string) {
        this.task_name.setValue(string);
    }

    public String getExplanation() {
        return ALEipUtils.getMessageList((String)this.explanation.getValue());
    }

    public void setExplanation(String string) {
        this.explanation.setValue(string);
    }

    public String getStatus() {
        return ALCommonUtils.replaceToAutoCR((String)this.status.toString());
    }

    public void setStatus(String string) {
        this.status.setValue(string);
    }

    public String getPriority() {
        return ALCommonUtils.replaceToAutoCR((String)this.priority.toString());
    }

    public void setPriority(String string) {
        this.priority.setValue(string);
    }

    public ALDateTimeField getStartPlanDate() {
        return this.start_plan_date;
    }

    public void setStartPlanDate(Date dt) {
        this.start_plan_date.setValue(dt);
    }

    public ALDateTimeField getEndPlanDate() {
        return this.end_plan_date;
    }

    public String getEndPlanDateWithFormat(String format) {
        return this.end_plan_date.toString(format);
    }

    public void setEndPlanDate(Date dt) {
        this.end_plan_date.setValue(dt);
    }

    public ALNumberField getPlanTerm() {
        return this.plan_term;
    }

    public void setPlanTerm(long i) {
        this.plan_term.setValue(i);
    }

    public ALDateTimeField getStartDate() {
        return this.start_date;
    }

    public void setStartDate(Date dt) {
        this.start_date.setValue(dt);
    }

    public ALDateTimeField getEndDate() {
        return this.end_date;
    }

    public void setEndDate(Date dt) {
        this.end_date.setValue(dt);
    }

    public BigDecimal getPlanWorkload() {
        return this.plan_workload;
    }

    public void setPlanWorkload(BigDecimal i) {
        this.plan_workload = i;
    }

    public String getPlanWorkloadFormat() {
        return this.df.format(this.plan_workload);
    }

    public BigDecimal getWorkload() {
        return this.workload;
    }

    public void setWorkload(BigDecimal i) {
        this.workload = i;
    }

    public String getWorkloadFormat() {
        return this.df.format(this.workload);
    }

    public BigDecimal getForecastWorkload() {
        return this.forecast_workload;
    }

    public void setForecastWorkload(BigDecimal i) {
        this.forecast_workload = i;
    }

    public String getForecastWorkloadFormat() {
        return this.df.format(this.forecast_workload);
    }

    public ALNumberField getPlanProgressRate() {
        return this.plan_progress_rate;
    }

    public void setPlanProgressRate(long i) {
        this.plan_progress_rate.setValue(i);
    }

    public ALNumberField getProgressRate() {
        return this.progress_rate;
    }

    public void setProgressRate(long i) {
        this.progress_rate.setValue(i);
    }

    public ALDateTimeField getCreateDate() {
        return this.create_date;
    }

    public void setCreateDate(Date dt) {
        this.create_date.setValue(dt);
    }

    public ALDateTimeField getUpdateDate() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.update_date);
    }

    public void setUpdateDate(Date dt) {
        this.update_date.setValue(dt);
    }

    public List<ProjectTaskMemberResultData> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<ProjectTaskMemberResultData> memberList) {
        this.memberList = memberList;
    }

    public String getMemberListString() {
        if (this.memberList == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.memberList.size(); ++i) {
            ProjectTaskMemberResultData member = this.memberList.get(i);
            if (member == null) continue;
            if (i > 0) {
                sb.append("\u3001");
            }
            sb.append(member.getUserName());
        }
        return String.valueOf(sb);
    }

    public ALNumberField getLoginUserId() {
        return this.login_user_id;
    }

    public void setLoginUserId(long i) {
        this.login_user_id.setValue(i);
    }

    public BigDecimal getWorkloadTotal() {
        BigDecimal w = BigDecimal.valueOf(0L);
        if (this.memberList == null) {
            return w;
        }
        for (int i = 0; i < this.memberList.size(); ++i) {
            ProjectTaskMemberResultData member = this.memberList.get(i);
            if (member == null) continue;
            w = w.add(member.getWorkload());
        }
        return w;
    }

    public List<FileuploadBean> getAttachmentFileList() {
        return this.attachmentFileList;
    }

    public void setAttachmentFiles(List<FileuploadBean> list) {
        this.attachmentFileList = list;
    }

    public List<ProjectTaskCommentResultData> getCommentList() {
        return this.commentList;
    }

    public void setCommentList(List<ProjectTaskCommentResultData> list) {
        this.commentList = list;
    }

    public boolean getResultDisplayFlg() {
        return this.resultDisplayFlg;
    }

    public void setResultDisplayFlg(boolean b) {
        this.resultDisplayFlg = b;
    }

    public boolean getHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean b) {
        this.hasChildren = b;
    }

    public boolean getConditionFlg() {
        return this.indentFlg;
    }

    public void setIndentFlg(boolean b) {
        this.indentFlg = b;
    }

    public ALNumberField getIndent() {
        return this.indent;
    }

    public void setIndent(long i) {
        this.indent.setValue(i);
    }

    public String getIndentString() {
        if (!this.indentFlg) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((long)i < this.indent.getValue()) {
            sb.append("&nbsp;&nbsp;");
            ++i;
        }
        if (sb.length() > 0) {
            sb.append("\u2514&nbsp;");
        }
        return String.valueOf(sb);
    }

    public boolean isDelay() {
        if ("".equals(this.getPlanProgressRate().toString()) || "".equals(this.getProgressRate().toString())) {
            return false;
        }
        return this.getPlanProgressRate().getValue() > this.getProgressRate().getValue();
    }

    public boolean isWorkloadOver() {
        if ("".equals(this.getStartPlanDate().toString()) || "".equals(this.getEndPlanDate().toString())) {
            return false;
        }
        return this.getPlanWorkload().compareTo(this.getForecastWorkload()) < 0;
    }

    public void setTopicPath(String i) {
        this.topicPath.setValue(i);
    }

    public ALStringField getTopicPath() {
        return this.topicPath;
    }

    public boolean isNoStart() {
        Calendar today = Calendar.getInstance();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.start_plan_date.getValue());
        return today.get(1) < cal.get(1) || today.get(1) == cal.get(1) && today.get(2) < cal.get(2) || today.get(1) == cal.get(1) && today.get(2) == cal.get(2) && today.get(5) < cal.get(5);
    }

    public boolean isPastFinish() {
        Calendar today = Calendar.getInstance();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.end_plan_date.getValue());
        return today.get(1) > cal.get(1) || today.get(1) == cal.get(1) && today.get(2) > cal.get(2) || today.get(1) == cal.get(1) && today.get(2) == cal.get(2) && today.get(5) > cal.get(5);
    }

    public boolean isFinishStatus() {
        for (String _status : ProjectUtils.completeStatus) {
            if (!this.status.getValue().equals(_status)) continue;
            return true;
        }
        return false;
    }

    public String getTrackerString() {
        return ProjectUtils.getKubunValueString("tracker", this.tracker.getValue());
    }

    public String getStatusString() {
        return ProjectUtils.getKubunValueString("status", this.status.getValue());
    }

    public String getPriorityString() {
        return ProjectUtils.getKubunValueString("priority", this.priority.getValue());
    }

    public boolean isHasChildrenForForm() {
        return this.hasChildrenForForm;
    }

    public void setHasChildrenForForm(boolean hasChildrenForForm) {
        this.hasChildrenForForm = hasChildrenForForm;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

