/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project.util;

import com.aimluck.eip.cayenne.om.portlet.EipTProject;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTask;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskMember;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.project.util.ProjectUtils;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ProjectFormUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectFormUtils.class.getName());

    public static void updateProject(Integer projectId, Integer loginUserId) {
        EipTProject project = ProjectUtils.getEipTProject(projectId);
        if (project == null) {
            return;
        }
        if ("f".equals(project.getProgressFlg())) {
            return;
        }
        project.setProgressRate(Integer.valueOf(ProjectUtils.getProjectProgressRate(projectId)));
        project.setUpdateUserId(loginUserId);
        project.setUpdateDate(Calendar.getInstance().getTime());
        Database.commit();
    }

    public static boolean isEditable(Integer taskId, Integer userId) {
        EipTProjectTask task = (EipTProjectTask)Database.get(EipTProjectTask.class, (Object)taskId);
        EipTProject project = (EipTProject)Database.get(EipTProject.class, (Object)task.getProjectId());
        if (null == project) {
            return false;
        }
        if (project.getAdminUserId().equals(userId)) {
            return true;
        }
        List list = Database.query(EipTProjectTaskMember.class).where(Operations.eq((String)"taskId", (Object)taskId)).fetchList();
        for (EipTProjectTaskMember member : list) {
            if (!member.getUserId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEditable(String taskId, Integer userId) {
        if (StringUtils.isEmpty((String)taskId) || !StringUtils.isNumeric((String)taskId) || null == userId) {
            return false;
        }
        return ProjectFormUtils.isEditable(Integer.valueOf(taskId), userId);
    }
}

