/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.eventlog.action;

import com.aimluck.eip.cayenne.om.portlet.EipTEventlog;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.eventlog.action.ALActionEventlogConstants;
import com.aimluck.eip.eventlog.util.ALEventlogUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.eventlog.ALEventlogHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;

public class ALActionEventlogHandler
extends ALEventlogHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALActionEventlogHandler.class.getName());

    public static ALEventlogHandler getInstance() {
        return new ALActionEventlogHandler();
    }

    public void log(int entity_id, int portlet_type, String note) {
        this.logActionEvent(entity_id, portlet_type, note);
    }

    public void log(int entity_id, int portlet_type, String note, String mode) {
        this.logActionEvent(entity_id, portlet_type, note, mode);
    }

    private void logActionEvent(int entity_id, int portlet_type, String note) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        String mode = rundata.getParameters().getString("mode");
        if (mode == null || "".equals(mode)) {
            String action = rundata.getAction();
            if (action == null || "".equals(action)) {
                return;
            }
        } else {
            this.logActionEvent(entity_id, portlet_type, note, mode);
        }
    }

    private void logActionEvent(int entity_id, int portlet_type, String note, String mode) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        int event_type = ALEventlogUtils.getEventTypeValue(mode);
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String ip_addr = rundata.getRemoteAddr();
        this.saveEvent(event_type, uid, portlet_type, entity_id, ip_addr, note);
    }

    public void logLogin(int userid) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        int event_type = ALEventlogUtils.getEventTypeValue("Login");
        int p_type = 1;
        String ip_addr = rundata.getRemoteAddr();
        this.saveEvent(event_type, userid, p_type, 0, ip_addr, null);
    }

    public void logLogout(int userid) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        int event_type = ALEventlogUtils.getEventTypeValue("Logout");
        int p_type = 2;
        String ip_addr = rundata.getRemoteAddr();
        this.saveEvent(event_type, userid, p_type, 0, ip_addr, null);
    }

    public void logXlsScreen(int userid, String Note, int _p_type) {
        JetspeedRunData rundata = ALEventlogFactoryService.getInstance().getRunData();
        int event_type = ALEventlogUtils.getEventTypeValue("xls_screen");
        String ip_addr = rundata.getRemoteAddr();
        this.saveEvent(event_type, userid, _p_type, 0, ip_addr, null);
    }

    protected boolean saveEvent(int event_type, int uid, int p_type, int entity_id, String ip_addr, String note) {
        try {
            EipTEventlog log = (EipTEventlog)Database.create(EipTEventlog.class);
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)uid);
            log.setTurbineUser(tuser);
            log.setEventDate(Calendar.getInstance().getTime());
            log.setEventType(Integer.valueOf(event_type));
            log.setPortletType(Integer.valueOf(p_type));
            log.setEntityId(Integer.valueOf(entity_id));
            log.setIpAddr(ip_addr);
            log.setCreateDate(Calendar.getInstance().getTime());
            log.setUpdateDate(Calendar.getInstance().getTime());
            log.setNote(note);
            Database.commit();
            return true;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"ALActionEventlogHandler.saveEvent", (Throwable)ex);
            return false;
        }
    }

    public int getEventTypeValue(String mode) {
        if ("detail".equals(mode)) {
            return 9;
        }
        if ("insert".equals(mode)) {
            return 4;
        }
        if ("list".equals(mode)) {
            return 8;
        }
        if ("form".equals(mode)) {
            return 5;
        }
        if ("new_form".equals(mode)) {
            return 6;
        }
        if ("edit_form".equals(mode)) {
            return 7;
        }
        if ("update".equals(mode)) {
            return 1;
        }
        if ("multi_delete".equals(mode)) {
            return 3;
        }
        if ("delete".equals(mode) || "delete_reply".equals(mode)) {
            return 2;
        }
        if ("Login".equals(mode)) {
            return 10;
        }
        if ("Logout".equals(mode)) {
            return 11;
        }
        if ("accept".equals(mode)) {
            return 12;
        }
        if ("denial".equals(mode)) {
            return 13;
        }
        if ("punchin".equals(mode)) {
            return 14;
        }
        if ("punchout".equals(mode)) {
            return 15;
        }
        if ("xls_screen".equals(mode)) {
            return 17;
        }
        if ("update_passwd".equals(mode)) {
            return 18;
        }
        if ("download".equals(mode)) {
            return 19;
        }
        if ("startguide".equals(mode)) {
            return 20;
        }
        if ("comment".equals(mode)) {
            return 21;
        }
        return 0;
    }

    public String getEventAliasName(int eventType) {
        int type = 0;
        if (eventType > 0 && eventType < ALActionEventlogConstants.EVENT_ALIAS_NAME.length) {
            type = eventType;
        }
        return ALActionEventlogConstants.EVENT_ALIAS_NAME[type];
    }

    public String getPortletAliasName(int portletType) {
        if (portletType == 0) {
            return "\u305d\u306e\u4ed6\u306e\u6a5f\u80fd";
        }
        if (portletType == 1) {
            return "\u30ed\u30b0\u30a4\u30f3";
        }
        if (portletType == 2) {
            return "\u30ed\u30b0\u30a2\u30a6\u30c8";
        }
        if (portletType == 3) {
            return "\u30a2\u30ab\u30a6\u30f3\u30c8";
        }
        if (portletType == 4) {
            return "\u30b7\u30b9\u30c6\u30e0";
        }
        if (portletType == 100) {
            return "\u30ab\u30ec\u30f3\u30c0\u30fc";
        }
        if (portletType == 110) {
            return "\u30d6\u30ed\u30b0\u30a8\u30f3\u30c8\u30ea";
        }
        if (portletType == 111) {
            return "\u30d6\u30ed\u30b0\u30c6\u30fc\u30de";
        }
        if (portletType == 120) {
            return "\u30ef\u30fc\u30af\u30d5\u30ed\u30fc";
        }
        if (portletType == 121) {
            return "\u30ef\u30fc\u30af\u30d5\u30ed\u30fc\u5206\u985e";
        }
        if (portletType == 122) {
            return "\u30ef\u30fc\u30af\u30d5\u30ed\u30fc\u7533\u8acb\u7d4c\u8def";
        }
        if (portletType == 130) {
            return "ToDo";
        }
        if (portletType == 131) {
            return "ToDo\u30ab\u30c6\u30b4\u30ea";
        }
        if (portletType == 140) {
            return "\u4f1d\u8a00\u30e1\u30e2";
        }
        if (portletType == 150) {
            return "\u65e7\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9";
        }
        if (portletType == 151) {
            return "\u65e7\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9\u51fa\u529b";
        }
        if (portletType == 160) {
            return "\u30a2\u30c9\u30ec\u30b9\u5e33(\u30a2\u30c9\u30ec\u30b9)";
        }
        if (portletType == 161) {
            return "\u30a2\u30c9\u30ec\u30b9\u5e33(\u4f1a\u793e\u60c5\u5831)";
        }
        if (portletType == 162) {
            return "\u30a2\u30c9\u30ec\u30b9\u5e33(\u793e\u5916\u30b0\u30eb\u30fc\u30d7)";
        }
        if (portletType == 170) {
            return "\u30e1\u30e2\u5e33";
        }
        if (portletType == 180) {
            return "\u63b2\u793a\u677f";
        }
        if (portletType == 181) {
            return "\u63b2\u793a\u677f\u30ab\u30c6\u30b4\u30ea";
        }
        if (portletType == 190) {
            return "\u691c\u7d22\u7a93";
        }
        if (portletType == 200) {
            return "My\u30ea\u30f3\u30af";
        }
        if (portletType == 210) {
            return "\u65b0\u7740\u60c5\u5831";
        }
        if (portletType == 220) {
            return "\u30d5\u30a9\u30eb\u30c0";
        }
        if (portletType == 221) {
            return "\u30d5\u30a9\u30eb\u30c0";
        }
        if (portletType == 230 || portletType == 231) {
            return "Web\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8";
        }
        if (portletType == 232) {
            return "Web\u30e1\u30fc\u30eb\u30d5\u30a9\u30eb\u30c0";
        }
        if (portletType == 233) {
            return "Web\u30e1\u30fc\u30eb\u30d5\u30a3\u30eb\u30bf";
        }
        if (portletType == 240) {
            return "\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u7ba1\u7406";
        }
        if (portletType == 250) {
            return "\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u7ba1\u7406";
        }
        if (portletType == 260) {
            return "\u30e6\u30fc\u30b6\u30fc\u7de8\u96c6";
        }
        if (portletType == 270) {
            return "\u30de\u30a4\u30b0\u30eb\u30fc\u30d7";
        }
        if (portletType == 280) {
            return "\u30da\u30fc\u30b8\u8a2d\u5b9a";
        }
        if (portletType == 290) {
            return "\u643a\u5e2f\u96fb\u8a71\u8a2d\u5b9a";
        }
        if (portletType == 300) {
            return "\u5171\u6709\u30ab\u30c6\u30b4\u30ea";
        }
        if (portletType == 310) {
            return "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9";
        }
        if (portletType == 311) {
            return "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9\u7ba1\u7406";
        }
        if (portletType == 320) {
            return "\u5831\u544a\u66f8";
        }
        if (portletType == 320) {
            return "\u5831\u544a\u66f8";
        }
        if (portletType == 330) {
            return "\u30bf\u30a4\u30e0\u30e9\u30a4\u30f3";
        }
        if (portletType == 340) {
            return "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9";
        }
        if (portletType == 350) {
            return "\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u7ba1\u7406";
        }
        if (portletType == 5) {
            return "\u8a2d\u5099\u7ba1\u7406";
        }
        if (portletType == 6) {
            return "\u30a2\u30d7\u30ea\u7ba1\u7406";
        }
        if (portletType == 360) {
            return "Wiki";
        }
        if (portletType == 370) {
            return "\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u7ba1\u7406";
        }
        return "\u305d\u306e\u4ed6\u306e\u6a5f\u80fd";
    }
}

