/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroupMap;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.orm.query.Where;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilityFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilityFormData.class.getName());
    private ALStringField facility_name;
    private ALStringField note;
    private String facilityid;
    private int userId;
    private List<EipMFacilityGroup> facility_group_list;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        this.facility_group_list = new ArrayList<EipMFacilityGroup>();
    }

    public void initField() {
        this.facility_name = new ALStringField();
        this.facility_name.setFieldName(ALLocalizationUtils.getl10n((String)"FACILITIES_FACILITY_NAME"));
        this.facility_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"FACILITIES_MEMO"));
        this.note.setTrim(false);
    }

    protected void setValidator() {
        this.facility_name.setNotNull(true);
        this.facility_name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if (res) {
                Object[] groupIds;
                if ("update".equals(this.getMode())) {
                    this.facilityid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
                }
                if ((groupIds = rundata.getParameters().getStrings("group_to")) != null && groupIds.length > 0) {
                    SelectQuery fquery = Database.query(EipMFacilityGroup.class);
                    Expression fexp = ExpressionFactory.inDbExp((String)"GROUP_ID", (Object[])groupIds);
                    fquery.setQualifier(fexp);
                    this.facility_group_list = fquery.fetchList();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipMFacility.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"facilityName", (Object)this.facility_name.getValue());
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"facilityName", (Object)this.facility_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"FACILITY_ID", (Object)Integer.valueOf(this.facilityid));
                query.andQualifier(exp2);
            }
            if (query.fetchList().size() != 0) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"FACILITIES_FACILITY_IS_ALREADY_ADDED", (Object[])new Object[]{this.facility_name.toString()}));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        this.facility_name.validate(msgList);
        this.note.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMFacility facility = FacilitiesUtils.getEipMFacility(rundata, context);
            if (facility == null) {
                return false;
            }
            this.facility_name.setValue(facility.getFacilityName());
            this.note.setValue(facility.getNote());
            SelectQuery query = Database.query(EipMFacilityGroupMap.class);
            query.where(Operations.eq((String)"FacilityId", (Object)facility.getFacilityId()));
            List maps = query.fetchList();
            ArrayList<Integer> faclityGroupIdList = new ArrayList<Integer>();
            for (EipMFacilityGroupMap map : maps) {
                faclityGroupIdList.add(map.getGroupId());
            }
            if (faclityGroupIdList.isEmpty()) {
                this.facility_group_list = new ArrayList<EipMFacilityGroup>(0);
            } else {
                SelectQuery fquery = Database.query(EipMFacilityGroup.class);
                Expression exp = ExpressionFactory.inDbExp((String)"GROUP_ID", faclityGroupIdList);
                fquery.setQualifier(exp);
                this.facility_group_list = fquery.fetchList();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMFacility facility = FacilitiesUtils.getEipMFacility(rundata, context);
            if (facility == null) {
                return false;
            }
            SelectQuery query1 = Database.query(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)facility.getFacilityId());
            Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"F");
            query1.setQualifier(exp1.andExp(exp2));
            List slist = query1.fetchList();
            if (slist != null && slist.size() > 0) {
                Database.deleteAll((List)slist);
            }
            SelectQuery fmaps = Database.query(EipMFacilityGroupMap.class);
            Expression fexp = ExpressionFactory.matchExp((String)"FacilityId", (Object)facility.getFacilityId());
            fmaps.setQualifier(fexp);
            fmaps.deleteAll();
            Database.delete((Persistent)facility);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(facility.getFacilityId().intValue(), 5, ALLocalizationUtils.getl10nFormat((String)"FACILITIES_DELETED_FACILITY_WITH_NAME", (Object[])new Object[]{facility.getFacilityName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            Integer maxnum2;
            int lastnum = 0;
            StringBuffer statement = new StringBuffer();
            statement.append("SELECT MAX(sort) as max_sort FROM eip_m_facility");
            String querydata = statement.toString();
            List maxnum = Database.sql(EipMFacility.class, (String)querydata).fetchListAsDataRow();
            if (maxnum != null && maxnum.size() > 0 && (maxnum2 = (Integer)((DataRow)maxnum.get(0)).get((Object)"max_sort")) != null) {
                lastnum = maxnum2;
            }
            Expression exp2 = ExpressionFactory.matchExp((String)"sort", null);
            SelectQuery querynotsort = Database.query(EipMFacility.class);
            querynotsort.orderAscending("updateDate");
            querynotsort.setQualifier(exp2);
            List facility_notsort_list = querynotsort.fetchList();
            for (EipMFacility facilitydata2 : facility_notsort_list) {
                facilitydata2.setSort(Integer.valueOf(++lastnum));
            }
            EipMFacility facility = (EipMFacility)Database.create(EipMFacility.class);
            facility.setUserId(Integer.valueOf(this.userId));
            facility.setSort(Integer.valueOf(++lastnum));
            facility.setFacilityName(this.facility_name.getValue());
            facility.setNote(this.note.getValue());
            facility.setCreateDate(Calendar.getInstance().getTime());
            facility.setUpdateDate(Calendar.getInstance().getTime());
            Group facility_group = JetspeedSecurity.getGroup((String)"Facility");
            EipFacilityGroup fg = (EipFacilityGroup)Database.create(EipFacilityGroup.class);
            fg.setEipMFacility(facility);
            fg.setTurbineGroup((TurbineGroup)facility_group);
            for (EipMFacilityGroup group : this.facility_group_list) {
                EipMFacilityGroupMap map = (EipMFacilityGroupMap)Database.create(EipMFacilityGroupMap.class);
                map.setEipMFacilityFacilityId(facility);
                map.setEipMFacilityGroupId(group);
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(facility.getFacilityId().intValue(), 5, ALLocalizationUtils.getl10nFormat((String)"FACILITIES_ADDED_FACILITY_WITH_NAME", (Object[])new Object[]{facility.getFacilityName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMFacility facility = FacilitiesUtils.getEipMFacility(rundata, context);
            if (facility == null) {
                return false;
            }
            facility.setFacilityName(this.facility_name.getValue());
            facility.setNote(this.note.getValue());
            facility.setUpdateDate(Calendar.getInstance().getTime());
            SelectQuery fmaps = Database.query(EipMFacilityGroupMap.class);
            Expression fexp = ExpressionFactory.matchExp((String)"FacilityId", (Object)facility.getFacilityId());
            fmaps.setQualifier(fexp);
            List oldMapList = fmaps.fetchList();
            ArrayList<EipMFacilityGroupMap> newMapList = new ArrayList<EipMFacilityGroupMap>();
            if (this.facility_group_list != null) {
                for (EipMFacilityGroup group : this.facility_group_list) {
                    EipMFacilityGroupMap map = new EipMFacilityGroupMap();
                    map.setFacilityId(facility.getFacilityId());
                    map.setGroupId(group.getGroupId());
                    newMapList.add(map);
                }
            }
            ArrayList<Integer> oldMapIdList = new ArrayList<Integer>();
            if (oldMapList.size() > 0) {
                for (EipMFacilityGroupMap map : oldMapList) {
                    oldMapIdList.add(map.getId());
                }
                SelectQuery remove = Database.query(EipMFacilityGroupMap.class);
                remove.where(Operations.and((Where[])new Where[]{Operations.eq((String)"FacilityId", (Object)facility.getFacilityId()), Operations.in((String)"GroupId", oldMapIdList)}));
                remove.deleteAll();
            }
            for (EipMFacilityGroupMap map : newMapList) {
                EipMFacilityGroupMap insert = (EipMFacilityGroupMap)Database.create(EipMFacilityGroupMap.class);
                insert.setFacilityId(map.getFacilityId());
                insert.setGroupId(map.getGroupId());
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(facility.getFacilityId().intValue(), 5, ALLocalizationUtils.getl10nFormat((String)"FACILITIES_UPDATED_FACILITY_WITH_NAME", (Object[])new Object[]{facility.getFacilityName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getFacilityName() {
        return this.facility_name;
    }

    public List<EipMFacilityGroup> getFacilityGroupList() {
        return this.facility_group_list;
    }
}

