/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security;

import java.sql.Connection;
import java.util.Iterator;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.SecurityObject;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.TurbineSecurityException;

public class TurbineRole
extends SecurityObject
implements Role {
    private PermissionSet permissionSet = null;

    public TurbineRole() {
    }

    public TurbineRole(String name) {
        super(name);
    }

    public PermissionSet getPermissions() throws Exception {
        return this.permissionSet;
    }

    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet;
    }

    public Role create(String name) throws TurbineSecurityException {
        TurbineRole role = new TurbineRole(name);
        TurbineSecurity.addRole(role);
        return role;
    }

    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveRole(this);
    }

    public void save(Connection conn) throws Exception {
        throw new Exception("not implemented");
    }

    public void save(String dbname) throws Exception {
        throw new Exception("not implemented");
    }

    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeRole(this);
    }

    public void rename(String name) throws TurbineSecurityException {
        TurbineSecurity.renameRole(this, name);
    }

    public void grant(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.grant(this, permission);
    }

    public void grant(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.elements();
        while (permissions.hasNext()) {
            TurbineSecurity.grant(this, (Permission)permissions.next());
        }
    }

    public void revoke(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.revoke(this, permission);
    }

    public void revoke(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.elements();
        while (permissions.hasNext()) {
            TurbineSecurity.revoke(this, (Permission)permissions.next());
        }
    }
}

