/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.logging.Logger;
import org.apache.turbine.services.logging.LoggingService;

public class LogWriter
extends PrintWriter {
    private LoggingService logger = (LoggingService)TurbineServices.getInstance().getService("LoggingService");

    public LogWriter() {
        super(new StringWriter());
    }

    private void log(String message) {
        this.logger.info(message);
    }

    public void flush() {
    }

    public void close() {
        this.logger.shutdown();
    }

    public boolean checkError() {
        return false;
    }

    public void write(int c) {
        this.log(String.valueOf(c));
    }

    public void write(char[] buf, int off, int len) {
        this.log(String.valueOf(buf, off, len));
    }

    public void write(char[] buf) {
        this.log(String.valueOf(buf));
    }

    public void write(String s, int off, int len) {
        this.log(s.substring(off, off + len));
    }

    public void write(String s) {
        this.log(s);
    }

    public void print(boolean b) {
        this.log(String.valueOf(b));
    }

    public void print(char c) {
        this.log(String.valueOf(c));
    }

    public void print(int i) {
        this.log(String.valueOf(i));
    }

    public void print(long l) {
        this.log(String.valueOf(l));
    }

    public void print(float f) {
        this.log(String.valueOf(f));
    }

    public void print(double d) {
        this.log(String.valueOf(d));
    }

    public void print(char[] s) {
        this.log(String.valueOf(s));
    }

    public void print(String s) {
        this.log(s);
    }

    public void print(Object obj) {
        this.log(String.valueOf(obj));
    }

    public void println() {
    }

    public void println(boolean x) {
        this.log(String.valueOf(x));
    }

    public void println(char x) {
        this.log(String.valueOf(x));
    }

    public void println(int x) {
        this.log(String.valueOf(x));
    }

    public void println(long x) {
        this.log(String.valueOf(x));
    }

    public void println(float x) {
        this.log(String.valueOf(x));
    }

    public void println(double x) {
        this.log(String.valueOf(x));
    }

    public void println(char[] x) {
        this.log(String.valueOf(x));
    }

    public void println(String x) {
        this.log(x);
    }

    public void println(Object x) {
        this.log(String.valueOf(x));
    }

    public Logger getLogger() {
        return this.logger.getLogger();
    }

    public Logger getLogger(String logName) {
        return this.logger.getLogger(logName);
    }

    public void setLogLevel(int level) {
        this.logger.setLogLevel(level);
    }

    public void setLogLevel(String logName, int level) {
        this.logger.setLogLevel(logName, level);
    }

    public void setFormat(String format) {
        this.logger.setFormat(format);
    }

    public void setFormat(String logName, String format) {
        this.logger.setFormat(logName, format);
    }
}

