/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.Turbine;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.pool.PoolService;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.pull.PullService;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class TurbinePullService
extends TurbineBaseService
implements PullService {
    private Context globalContext;
    private List globalTools;
    private List requestTools;
    private List sessionTools;
    private List persistentTools;
    private static final String GLOBAL_TOOL = "tool.global";
    private static final String REQUEST_TOOL = "tool.request";
    private static final String SESSION_TOOL = "tool.session";
    private static final String PERSISTENT_TOOL = "tool.persistent";
    private static String resourcesDirectory;
    private static String absolutePathToResourcesDirectory;
    private static final String TOOL_RESOURCES_DIR = "tools.resources.dir";
    private static final String TOOL_RESOURCES_DIR_DEFAULT = "/resources";
    private static final String TOOLS_PER_REQUEST_REFRESH = "tools.per.request.refresh";
    private static boolean refreshToolsPerRequest;

    public void init() throws InitializationException {
        try {
            this.initPull();
        }
        catch (Exception e) {
            throw new InitializationException("TurbinePullService failed to initialize", e);
        }
    }

    private void initPull() throws Exception {
        Configuration conf = this.getConfiguration();
        resourcesDirectory = TurbineResources.getString(TOOL_RESOURCES_DIR, TOOL_RESOURCES_DIR_DEFAULT);
        absolutePathToResourcesDirectory = Turbine.getRealPath(resourcesDirectory);
        refreshToolsPerRequest = conf.getBoolean(TOOLS_PER_REQUEST_REFRESH);
        if (refreshToolsPerRequest) {
            Log.info("Pull Model tools will be refreshed on a per request basis.");
        }
        this.setInit(true);
        this.globalTools = this.getTools(GLOBAL_TOOL);
        this.requestTools = this.getTools(REQUEST_TOOL);
        this.sessionTools = this.getTools(SESSION_TOOL);
        this.persistentTools = this.getTools(PERSISTENT_TOOL);
        this.globalContext = new VelocityContext();
        this.populateWithGlobalTools(this.globalContext);
    }

    private List getTools(String keyPrefix) {
        ArrayList<ToolData> classes = new ArrayList<ToolData>();
        ResourceService toolResources = TurbineResources.getResources(keyPrefix);
        if (toolResources == null) {
            return classes;
        }
        Iterator it = toolResources.getKeys();
        while (it.hasNext()) {
            String toolName = (String)it.next();
            String toolClassName = toolResources.getString(toolName);
            try {
                Class<?> toolClass = Class.forName(toolClassName);
                classes.add(new ToolData(toolName, toolClassName, toolClass));
                Log.info("Instantiated tool class " + toolClassName + " to add to the context as '$" + toolName + "'");
            }
            catch (Exception e) {
                Log.error("Cannot find tool class " + toolClassName + ", please check the name of the class.", e);
            }
        }
        return classes;
    }

    public Context getGlobalContext() {
        return this.globalContext;
    }

    public void populateContext(Context context, RunData data) {
        this.populateWithRequestTools(context, data);
        User user = data.getUser();
        if (user != null) {
            this.populateWithSessionTools(this.sessionTools, context, user, false);
            if (user.hasLoggedIn()) {
                this.populateWithSessionTools(this.persistentTools, context, user, true);
            }
        }
    }

    private void populateWithGlobalTools(Context context) {
        Iterator it = this.globalTools.iterator();
        while (it.hasNext()) {
            ToolData toolData = (ToolData)it.next();
            try {
                Object tool = toolData.toolClass.newInstance();
                if (tool instanceof ApplicationTool) {
                    ((ApplicationTool)tool).init(null);
                }
                context.put(toolData.toolName, tool);
            }
            catch (Exception e) {
                Log.error("Could not instantiate tool " + toolData.toolClassName + " to add to the context", e);
            }
        }
    }

    private void populateWithRequestTools(Context context, RunData data) {
        PoolService pool = (PoolService)TurbineServices.getInstance().getService("PoolService");
        Iterator it = this.requestTools.iterator();
        while (it.hasNext()) {
            ToolData toolData = (ToolData)it.next();
            try {
                Object tool = pool.getInstance(toolData.toolClass);
                if (tool instanceof ApplicationTool) {
                    ((ApplicationTool)tool).init(data);
                }
                context.put(toolData.toolName, tool);
            }
            catch (Exception e) {
                Log.error("Could not instantiate tool " + toolData.toolClassName + " to add to the context", e);
            }
        }
    }

    private void populateWithSessionTools(List tools, Context context, User user, boolean usePerm) {
        PoolService pool = (PoolService)TurbineServices.getInstance().getService("PoolService");
        Iterator it = tools.iterator();
        while (it.hasNext()) {
            ToolData toolData = (ToolData)it.next();
            try {
                User user2 = user;
                synchronized (user2) {
                    Object tool;
                    Object object = tool = usePerm ? user.getPerm(toolData.toolClassName) : user.getTemp(toolData.toolClassName);
                    if (tool == null) {
                        tool = pool.getInstance(toolData.toolClass);
                        if (tool instanceof ApplicationTool) {
                            ((ApplicationTool)tool).init(user);
                        }
                        if (usePerm) {
                            user.setPerm(toolData.toolClassName, tool);
                        } else {
                            user.setTemp(toolData.toolClassName, tool);
                        }
                    } else if (refreshToolsPerRequest && tool instanceof ApplicationTool) {
                        ((ApplicationTool)tool).refresh();
                    }
                    context.put(toolData.toolName, tool);
                }
            }
            catch (Exception e) {
                Log.error("Could not instantiate tool " + toolData.toolClassName + " to add to the context", e);
            }
        }
    }

    public String getAbsolutePathToResourcesDirectory() {
        return absolutePathToResourcesDirectory;
    }

    public String getResourcesDirectory() {
        return resourcesDirectory;
    }

    public void refreshGlobalTools() {
        Iterator i = this.globalTools.iterator();
        while (i.hasNext()) {
            ToolData toolData = (ToolData)i.next();
            Object tool = this.globalContext.get(toolData.toolName);
            if (!(tool instanceof ApplicationTool)) continue;
            ((ApplicationTool)tool).refresh();
        }
    }

    public boolean refreshToolsPerRequest() {
        return refreshToolsPerRequest;
    }

    public void releaseTools(Context context) {
        PoolService pool = (PoolService)TurbineServices.getInstance().getService("PoolService");
        this.releaseTools(context, pool, this.requestTools);
    }

    private void releaseTools(Context context, PoolService pool, List tools) {
        Iterator it = tools.iterator();
        while (it.hasNext()) {
            ToolData toolData = (ToolData)it.next();
            Object tool = context.remove((Object)toolData.toolName);
            if (tool == null) continue;
            pool.putInstance(tool);
        }
    }

    private static class ToolData {
        String toolName;
        String toolClassName;
        Class toolClass;

        public ToolData(String toolName, String toolClassName, Class toolClass) {
            this.toolName = toolName;
            this.toolClassName = toolClassName;
            this.toolClass = toolClass;
        }
    }
}

