/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.parser;

import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.services.upload.TurbineUpload;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.parser.BaseValueParser;
import org.apache.turbine.util.pool.Recyclable;
import org.apache.turbine.util.upload.FileItem;

public class DefaultParameterParser
extends BaseValueParser
implements ParameterParser,
Recyclable {
    private HttpServletRequest request = null;
    private byte[] uploadData = null;

    public DefaultParameterParser() {
    }

    public DefaultParameterParser(String characterEncoding) {
        super(characterEncoding);
    }

    public void dispose() {
        this.request = null;
        this.uploadData = null;
        super.dispose();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest req) {
        Enumeration names;
        this.clear();
        this.uploadData = null;
        String enc = req.getCharacterEncoding();
        this.setCharacterEncoding(enc != null ? enc : "US-ASCII");
        String tmp = null;
        tmp = req.getHeader("Content-type");
        if (TurbineUpload.getAutomatic() && tmp != null && tmp.startsWith("multipart/form-data")) {
            try {
                TurbineUpload.parseRequest(req, this);
            }
            catch (TurbineException e) {
                Log.error(new TurbineException("File upload failed", e));
            }
        }
        if ((names = req.getParameterNames()) != null) {
            while (names.hasMoreElements()) {
                tmp = (String)names.nextElement();
                this.parameters.put(this.convert(tmp), req.getParameterValues(tmp));
            }
        }
        try {
            StringTokenizer st = new StringTokenizer(req.getPathInfo(), "/");
            boolean name = true;
            String pathPart = null;
            while (st.hasMoreTokens()) {
                if (name) {
                    tmp = URLDecoder.decode(st.nextToken());
                    name = false;
                    continue;
                }
                pathPart = URLDecoder.decode(st.nextToken());
                if (tmp.length() != 0) {
                    this.add(this.convert(tmp), pathPart);
                }
                name = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.request = req;
    }

    public void setUploadData(byte[] uploadData) {
        this.uploadData = uploadData;
    }

    public byte[] getUploadData() {
        return this.uploadData;
    }

    public void append(String name, FileItem value) {
        FileItem[] items = this.getFileItems(name);
        if (items == null) {
            items = new FileItem[]{value};
            this.parameters.put(this.convert(name), items);
        } else {
            FileItem[] newItems = new FileItem[items.length + 1];
            System.arraycopy(items, 0, newItems, 0, items.length);
            newItems[items.length] = value;
            this.parameters.put(this.convert(name), newItems);
        }
    }

    public FileItem getFileItem(String name) {
        try {
            FileItem value = null;
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = ((FileItem[])object)[0];
            }
            return value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public FileItem[] getFileItems(String name) {
        try {
            return (FileItem[])this.parameters.get(this.convert(name));
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

