/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecard;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystem;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystemMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.exttimecard.ExtTimecardListResultData;
import com.aimluck.eip.exttimecard.ExtTimecardResultData;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ExtTimecardSelectData
extends ALAbstractSelectData<EipTExtTimecard, EipTExtTimecard>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardSelectData.class.getName());
    private String target_group_name;
    private String target_user_id;
    private List<ALEipGroup> myGroupList = null;
    private List<ALEipUser> userList = null;
    private String userid;
    private String nowtime;
    private Map<String, ExtTimecardListResultData> datemap;
    private EipTExtTimecardSystem timecard_system;
    private String aclPortletFeature = null;
    private boolean hasAclSummaryOther;
    private boolean hasAclUpdate;
    private boolean hasAclInsert;
    private boolean hasAclXlsExport;
    private ALDateTimeField viewMonth;
    private ALDateTimeField tmpViewMonth;
    private ALDateTimeField prevMonth;
    private ALDateTimeField nextMonth;
    private ALDateTimeField currentMonth;
    private ALDateTimeField today;
    private ALDateTimeField viewStart;
    private ALDateTimeField viewEnd;
    private ALDateTimeField viewEndCrt;
    protected int viewTodo;
    private final String MODE = "list";
    private int startDay;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        Calendar cal;
        this.tmpViewMonth = new ALDateTimeField("yyyy-MM");
        this.tmpViewMonth.setNotNull(true);
        this.viewMonth = new ALDateTimeField("yyyy-MM");
        this.viewMonth.setNotNull(true);
        this.prevMonth = new ALDateTimeField("yyyy-MM");
        this.nextMonth = new ALDateTimeField("yyyy-MM");
        this.currentMonth = new ALDateTimeField("yyyy-MM");
        this.viewStart = new ALDateTimeField("yyyy-MM-dd");
        this.viewEnd = new ALDateTimeField("yyyy-MM-dd");
        this.viewEndCrt = new ALDateTimeField("yyyy-MM-dd");
        this.today = new ALDateTimeField("yyyy-MM-dd");
        this.startDay = 1;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_month")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_month", (String)rundata.getParameters().getString("view_month"));
        }
        this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList<ALEipGroup>();
        int length = myGroups.size();
        for (int i = 0; i < length; ++i) {
            this.myGroupList.add((ALEipGroup)myGroups.get(i));
        }
        this.setupLists(rundata, context);
        this.aclPortletFeature = this.target_user_id == null || "".equals(this.target_user_id) || this.userid.equals(this.target_user_id) ? "timecard_timecard_self" : "timecard_timecard_other";
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclSummaryOther = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 1);
        if (!this.hasAclSummaryOther) {
            this.target_user_id = this.userid;
            this.aclPortletFeature = "timecard_timecard_self";
        }
        this.hasAclUpdate = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), this.aclPortletFeature, 8);
        this.hasAclInsert = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), this.aclPortletFeature, 4);
        this.hasAclXlsExport = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), this.aclPortletFeature, 32);
        this.datemap = new LinkedHashMap<String, ExtTimecardListResultData>();
        this.timecard_system = this.target_user_id == null || "".equals(this.target_user_id) ? ExtTimecardUtils.getEipTExtTimecardSystemCurrentUserId(rundata, context) : ExtTimecardUtils.getEipTExtTimecardSystemByUserId(Integer.valueOf(this.target_user_id));
        if (this.target_user_id != null && !this.target_user_id.isEmpty()) {
            SelectQuery default_query = Database.query(EipTExtTimecardSystemMap.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)this.target_user_id);
            default_query.setQualifier(exp);
            ResultList map_list = default_query.getResultList();
            if (!map_list.isEmpty()) {
                this.startDay = ((EipTExtTimecardSystemMap)map_list.get(0)).getEipTExtTimecardSystem().getStartDay();
            } else {
                EipTExtTimecardSystem system = (EipTExtTimecardSystem)Database.get(EipTExtTimecardSystem.class, (Object)1);
                if (system != null) {
                    try {
                        Date now = new Date();
                        EipTExtTimecardSystemMap rd = new EipTExtTimecardSystemMap();
                        rd.setEipTExtTimecardSystem(system);
                        int userid = Integer.parseInt(this.target_user_id);
                        rd.setUserId(Integer.valueOf(userid));
                        rd.setCreateDate(now);
                        rd.setUpdateDate(now);
                        Database.commit();
                        this.startDay = system.getStartDay();
                    }
                    catch (Exception ex) {
                        Database.rollback();
                        logger.error((Object)"exttimecard", (Throwable)ex);
                    }
                }
            }
        }
        Calendar to = Calendar.getInstance();
        to.set(11, 0);
        to.set(12, 0);
        this.today.setValue(to.getTime());
        boolean isBeforeThanStartDay = Integer.parseInt(this.today.getDay().toString()) < this.startDay;
        String tmpViewMonth = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_month");
        if (tmpViewMonth == null || tmpViewMonth.equals("")) {
            cal = Calendar.getInstance();
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            if (isBeforeThanStartDay) {
                cal.add(2, -1);
            }
            this.viewMonth.setValue(cal.getTime());
        } else {
            this.viewMonth.setValue(tmpViewMonth);
            if (!this.viewMonth.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_month");
                throw new ALPageNotFoundException();
            }
        }
        if (!isBeforeThanStartDay && Integer.parseInt(this.today.getMonth()) == Integer.parseInt(this.viewMonth.getMonth().toString())) {
            this.currentMonth.setValue(to.getTime());
        } else {
            Calendar tmp_cal = Calendar.getInstance();
            tmp_cal.set(5, 1);
            tmp_cal.set(11, 0);
            tmp_cal.set(12, 0);
            if (isBeforeThanStartDay) {
                tmp_cal.add(2, -1);
            }
            this.currentMonth.setValue(tmp_cal.getTime());
        }
        cal = Calendar.getInstance();
        cal.set(2, Integer.parseInt(this.viewMonth.getMonth()) - 1);
        cal.set(5, this.startDay);
        Date startDate = cal.getTime();
        this.viewStart.setValue(startDate);
        cal.add(2, 1);
        cal.add(5, -1);
        Date endDate = cal.getTime();
        this.viewEnd.setValue(endDate);
        this.viewEndCrt.setValue(endDate);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(this.viewMonth.getValue());
        cal2.add(2, 1);
        this.nextMonth.setValue(cal2.getTime());
        cal2.add(2, -2);
        this.prevMonth.setValue(cal2.getTime());
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.viewStart.toString() + "-00-00"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.viewStart.toString() + "-00-00"));
        super.init(action, rundata, context);
    }

    private SelectQuery<EipTExtTimecard> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTExtTimecard.class);
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(this.viewMonth.getValue());
        cal1.set(5, this.startDay);
        cal1.set(11, 0);
        cal1.set(12, 0);
        ALDateTimeField viewMonth_month = new ALDateTimeField("yyyy-MM-dd");
        viewMonth_month.setValue(cal1.getTime());
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(this.target_user_id));
        query.setQualifier(exp1);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"punchDate", (Object)viewMonth_month.getValue());
        cal1.add(2, 1);
        cal1.add(14, -1);
        ALDateTimeField viewMonth_add_month = new ALDateTimeField("yyyy-MM-dd");
        viewMonth_add_month.setValue(cal1.getTime());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"punchDate", (Object)viewMonth_add_month.getValue());
        query.andQualifier(exp11.andExp(exp12));
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public ResultList<EipTExtTimecard> selectList(RunData rundata, Context context) {
        try {
            if (!"".equals(this.target_user_id)) {
                SelectQuery<EipTExtTimecard> query = this.getSelectQuery(rundata, context);
                this.buildSelectQueryForListView(query);
                query.orderAscending("punchDate");
                return query.getResultList();
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultData(EipTExtTimecard record) {
        try {
            Date date = record.getPunchDate();
            String checkdate = ALDateUtil.format((Date)date, (String)"yyyyMMdd");
            ExtTimecardListResultData value = this.datemap.get(checkdate);
            if (value == null) {
                ExtTimecardListResultData listrd = new ExtTimecardListResultData();
                listrd.initField();
                listrd.setDate(date);
                listrd.setTimecardSystem(this.timecard_system);
                listrd.setBeforeAfter();
                ExtTimecardResultData rd = new ExtTimecardResultData();
                rd.initField();
                rd.setPunchDate(record.getPunchDate());
                rd.setRefixFlag(record.getCreateDate(), record.getUpdateDate());
                rd.setTimecardId(record.getExtTimecardId().longValue());
                rd.setReason(record.getReason());
                rd.setRemarks(record.getRemarks());
                String reason = record.getReason();
                String remarks = record.getRemarks();
                if (reason == null || "".equals(reason)) {
                    rd.setReasonFlg(false);
                } else {
                    rd.setReasonFlg(true);
                }
                if (remarks == null || "".equals(remarks)) {
                    rd.setRemarksFlg(false);
                } else {
                    rd.setRemarksFlg(true);
                }
                rd.setClockInTime(record.getClockInTime());
                rd.setClockOutTime(record.getClockOutTime());
                String type = record.getType();
                rd.setType(type);
                if ("P".equals(type)) {
                    rd.setIsTypeP(true);
                } else if ("A".equals(type)) {
                    rd.setIsTypeA(true);
                } else if ("H".equals(type)) {
                    rd.setIsTypeH(true);
                } else if ("C".equals(type)) {
                    rd.setIsTypeC(true);
                } else if ("E".equals(type)) {
                    rd.setIsTypeE(true);
                }
                for (int i = 1; i <= 5; ++i) {
                    rd.setOutgoingTime(record.getOutgoingTime(i), i);
                    rd.setComebackTime(record.getComebackTime(i), i);
                }
                listrd.setRd(rd);
                this.datemap.put(checkdate, listrd);
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    private boolean sameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        return date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }

    private SelectQuery<EipTExtTimecard> getSelectQueryDetail(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTExtTimecard.class);
        Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        Calendar calendar_now = Calendar.getInstance();
        Calendar from_calendar = Calendar.getInstance();
        int hour = this.timecard_system.getChangeHour();
        from_calendar.set(11, hour);
        from_calendar.set(12, 0);
        from_calendar.set(13, 0);
        if (calendar_now.before(from_calendar)) {
            from_calendar.add(5, -1);
        }
        from_calendar.set(11, 0);
        Expression exp2 = ExpressionFactory.matchExp((String)"punchDate", (Object)from_calendar.getTime());
        query.setQualifier(exp.andExp(exp2));
        return query;
    }

    public EipTExtTimecard selectDetail(RunData rundata, Context context) {
        try {
            Calendar cal = Calendar.getInstance();
            this.nowtime = cal.get(11) + "\u6642" + cal.get(12) + "\u5206";
            SelectQuery<EipTExtTimecard> query = this.getSelectQueryDetail(rundata, context);
            query.orderDesending("punchDate");
            List list = query.fetchList();
            if (list != null && list.size() > 0) {
                return (EipTExtTimecard)list.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTExtTimecard record) {
        try {
            ExtTimecardResultData rd = new ExtTimecardResultData();
            rd.initField();
            rd.setClockInTime(record.getClockInTime());
            rd.setClockOutTime(record.getClockOutTime());
            rd.setTimecardSystem(this.timecard_system);
            rd.setPunchDate(record.getPunchDate());
            String type = record.getType();
            rd.setType(type);
            if ("P".equals(type)) {
                rd.setIsTypeP(true);
            } else if ("A".equals(type)) {
                rd.setIsTypeA(true);
            } else if ("H".equals(type)) {
                rd.setIsTypeH(true);
            } else if ("C".equals(type)) {
                rd.setIsTypeC(true);
            } else if ("E".equals(type)) {
                rd.setIsTypeE(true);
            }
            for (int i = 1; i <= 5; ++i) {
                rd.setOutgoingTime(record.getOutgoingTime(i), i);
                rd.setComebackTime(record.getComebackTime(i), i);
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    private void setupLists(RunData rundata, Context context) {
        this.target_group_name = this.getTargetGroupName(rundata, context);
        if (this.target_group_name.equals("only")) {
            this.target_group_name = "all";
        }
        this.userList = this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all") ? ALEipUtils.getUsers((String)this.target_group_name) : ALEipUtils.getUsers((String)"LoginUser");
        this.target_user_id = this.getTargetUserId(rundata, context);
    }

    private String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString("target_group_name");
        }
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_group_name");
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    private String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString("target_user_id");
        }
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_user_id");
        if (this.userList.size() == 0) {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
            return "";
        }
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
            target_user_id = this.userid;
        } else if (idParam != null) {
            if (idParam.equals("none")) {
                ALEipUser eipUser = null;
                boolean found = false;
                int length = this.userList.size();
                for (int i = 0; i < length; ++i) {
                    eipUser = this.userList.get(i);
                    String eipUserId = eipUser.getUserId().getValueAsString();
                    if (!this.userid.equals(eipUserId)) continue;
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
                    target_user_id = this.userid;
                    found = true;
                    break;
                }
                if (!found) {
                    eipUser = this.userList.get(0);
                    String userId = eipUser.getUserId().getValueAsString();
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userId);
                    target_user_id = userId;
                }
            } else {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)idParam);
                target_user_id = idParam;
            }
        }
        return target_user_id;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public List<ALEipUser> getUsers() {
        if (this.hasAclSummaryOther) {
            return this.userList;
        }
        try {
            ArrayList<ALEipUser> users = new ArrayList<ALEipUser>();
            users.add(ALEipUtils.getALEipUser((int)Integer.parseInt(this.userid)));
            return users;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<Integer, ALEipPost> getPostMap() {
        if (this.hasAclSummaryOther) {
            return ALEipManager.getInstance().getPostMap();
        }
        return null;
    }

    public List<ALEipGroup> getMyGroupList() {
        if (this.hasAclSummaryOther) {
            return this.myGroupList;
        }
        return new ArrayList<ALEipGroup>(0);
    }

    public String getUserId() {
        return this.userid;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public ALDateTimeField getViewDate() {
        return this.viewMonth;
    }

    public String getNowTime() {
        return this.nowtime;
    }

    public List<ExtTimecardListResultData> getDateListKeys() {
        try {
            ArrayList<ExtTimecardListResultData> list = new ArrayList<ExtTimecardListResultData>();
            Calendar cal = Calendar.getInstance();
            cal.set(2, Integer.parseInt(this.viewMonth.getMonth()) - 1);
            cal.set(5, this.startDay);
            cal.set(11, 0);
            cal.set(12, 0);
            Calendar tmp_cal = Calendar.getInstance();
            tmp_cal.set(1, Integer.parseInt(this.viewMonth.getYear()));
            tmp_cal.set(2, Integer.parseInt(this.viewMonth.getMonth()) - 1);
            tmp_cal.set(5, this.startDay);
            tmp_cal.set(11, 0);
            tmp_cal.set(12, 0);
            for (int i = 0; i < cal.getActualMaximum(5); ++i) {
                Date date = tmp_cal.getTime();
                String datestring = ALDateUtil.format((Date)date, (String)"yyyyMMdd");
                if (this.datemap.containsKey(datestring)) {
                    list.add(this.datemap.get(datestring));
                } else {
                    ExtTimecardListResultData rd = new ExtTimecardListResultData();
                    rd.initField();
                    rd.setDate(date);
                    rd.setTimecardSystem(this.timecard_system);
                    rd.setBeforeAfter();
                    list.add(rd);
                }
                tmp_cal.add(5, 1);
            }
            return list;
        }
        catch (Exception e) {
            logger.error((Object)"[ExtTimecardSelectData]", (Throwable)e);
            return null;
        }
    }

    public ExtTimecardListResultData getDateListValue(String date_str) {
        return this.datemap.get(date_str);
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public boolean hasAclUpdate() {
        return this.hasAclUpdate;
    }

    public boolean hasAclInsert() {
        return this.hasAclInsert;
    }

    public boolean hasAclXlsExport() {
        return this.hasAclXlsExport;
    }

    public ALDateTimeField getViewStart() {
        return this.viewStart;
    }

    public ALDateTimeField getViewEnd() {
        return this.viewEnd;
    }

    public ALDateTimeField getViewEndCrt() {
        return this.viewEndCrt;
    }

    public ALDateTimeField getPrevMonth() {
        return this.prevMonth;
    }

    public ALDateTimeField getNextMonth() {
        return this.nextMonth;
    }

    public ALDateTimeField getCurrentMonth() {
        return this.currentMonth;
    }

    public ALDateTimeField getViewMonth() {
        return this.viewMonth;
    }

    public String getViewMonthYearMonthText() {
        return ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_YEAR_MONTH_FORMAT", (Object[])new Object[]{this.viewMonth.getYear().toString(), this.viewMonth.getMonth().toString()});
    }

    public ALDateTimeField getToday() {
        return this.today;
    }

    public EipTExtTimecardSystem getTimecardSystem() {
        return this.timecard_system;
    }

    public String getMode() {
        return "list";
    }

    public void setTmpViewMonth(ALDateTimeField tmpViewMonth) {
        this.tmpViewMonth = tmpViewMonth;
    }

    public ALDateTimeField getTmpViewMonth() {
        return this.tmpViewMonth;
    }

    public String getScreenName() {
        return "ExtTimecardSelectData";
    }
}

