/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecardSettings;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.exttimecard.ExtTimecardResultData;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ExtTimecardSummaryResultData
implements ALData {
    private ALDateField date = null;
    private List<ExtTimecardResultData> list = null;
    private ALNumberField owner_id;
    private ALNumberField work_day = null;
    private ALNumberField work_hour = null;
    private ALNumberField overtime_day = null;
    private ALNumberField overtime_hour = null;
    private ALNumberField off_day = null;
    private ALNumberField off_hour = null;
    private ALNumberField late_coming_day = null;
    private ALNumberField early_leaving_day = null;
    private ALNumberField absent_day = null;
    private ALNumberField paid_holiday = null;
    private ALNumberField compensatory_holiday = null;
    private ALNumberField other_day = null;
    private ALNumberField no_input = null;
    private String user_name = null;
    private String systemName = null;

    public void initField() {
        this.work_day = new ALNumberField(0L);
        this.work_hour = new ALNumberField(0L);
        this.overtime_day = new ALNumberField(0L);
        this.overtime_hour = new ALNumberField(0L);
        this.off_day = new ALNumberField(0L);
        this.off_hour = new ALNumberField(0L);
        this.late_coming_day = new ALNumberField(0L);
        this.early_leaving_day = new ALNumberField(0L);
        this.absent_day = new ALNumberField(0L);
        this.paid_holiday = new ALNumberField(0L);
        this.compensatory_holiday = new ALNumberField(0L);
        this.other_day = new ALNumberField(0L);
        this.no_input = new ALNumberField(0L);
        this.date = new ALDateField();
        this.date.setValue(new Date());
        this.list = new ArrayList<ExtTimecardResultData>();
        this.owner_id = new ALNumberField();
    }

    public void setWorkDayHour(int days, float hour) {
        this.work_day.setValue((long)days);
        this.work_hour.setValue(String.valueOf(hour));
    }

    public void setOvertimeDayHour(int days, float hour) {
        this.overtime_day.setValue((long)days);
        this.overtime_hour.setValue(String.valueOf(hour));
    }

    public void setOffDayHour(int days, float hour) {
        this.off_day.setValue((long)days);
        this.off_hour.setValue(String.valueOf(hour));
    }

    public void setLateComingDay(int days) {
        this.late_coming_day.setValue((long)days);
    }

    public void setEarlyLeavingDay(int days) {
        this.early_leaving_day.setValue((long)days);
    }

    public void setAbsentDay(int days) {
        this.absent_day.setValue((long)days);
    }

    public void setPaidHoliday(int days) {
        this.paid_holiday.setValue((long)days);
    }

    public void setCompensatoryHoliday(int days) {
        this.compensatory_holiday.setValue((long)days);
    }

    public void setOtherDay(int days) {
        this.other_day.setValue((long)days);
    }

    public void setNoInput(int days) {
        this.no_input.setValue((long)days);
    }

    public ALNumberField getWorkDay() {
        return this.work_day;
    }

    public ALNumberField getWorkHour() {
        return this.work_hour;
    }

    public ALNumberField getOvertimeDay() {
        return this.overtime_day;
    }

    public ALNumberField getOvertimeHour() {
        return this.overtime_hour;
    }

    public ALNumberField getOffDay() {
        return this.off_day;
    }

    public ALNumberField getOffHour() {
        return this.off_hour;
    }

    public ALNumberField getLateComingDay() {
        return this.late_coming_day;
    }

    public ALNumberField getEarlyLeavingDay() {
        return this.early_leaving_day;
    }

    public ALNumberField getAbsentDay() {
        return this.absent_day;
    }

    public ALNumberField getPaidHoliday() {
        return this.paid_holiday;
    }

    public ALNumberField getCompensatoryHoliday() {
        return this.compensatory_holiday;
    }

    public ALNumberField getOtherDay() {
        return this.other_day;
    }

    public ALNumberField getNoInput() {
        return this.no_input;
    }

    public void setDate(Date date) {
        this.date.setValue(date);
    }

    public ALDateField getDate() {
        return this.date;
    }

    private String minuteToHour(long minute) {
        BigDecimal decimal = new BigDecimal((double)minute / 60.0);
        DecimalFormat dformat = new DecimalFormat("##.#");
        String str = dformat.format(decimal.setScale(1, 3).doubleValue());
        return str;
    }

    public String getDateStr() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5(EE)");
            return sdf.format(this.date.getValue().getDate());
        }
        catch (Exception e) {
            return "";
        }
    }

    public List<ExtTimecardResultData> getList() {
        return this.list;
    }

    public void setUserName(String user_name) {
        this.user_name = user_name;
    }

    public String getUserName() {
        return this.user_name;
    }

    public String getUserNameHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.user_name);
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemNameHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.systemName);
    }

    public List<ExtTimecardResultData> getViewList() {
        ArrayList<ExtTimecardResultData> viewlist = new ArrayList<ExtTimecardResultData>();
        ExtTimecardResultData rd = null;
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            rd = this.list.get(i);
            if ("-1".equals(rd.getWorkFlag().getValue())) continue;
            viewlist.add(rd);
        }
        return viewlist;
    }

    public void addExtTimecardResultData(ExtTimecardResultData rd) {
        this.list.add(rd);
    }

    public void setOwnerId(long i) {
        this.owner_id.setValue(i);
    }

    public ALNumberField getOwnerId() {
        return this.owner_id;
    }

    private ExtTimecardResultData createExtTimecardResultData(Date date, String workflag) {
        ExtTimecardResultData rd = new ExtTimecardResultData();
        rd.initField();
        rd.setWorkDate(date);
        rd.setWorkFlag(workflag);
        return rd;
    }

    private EipTTimecardSettings loadEipTTimecardSettings() {
        SelectQuery query = Database.query(EipTTimecardSettings.class);
        List aList = query.fetchList();
        if (aList != null && aList.size() > 0) {
            EipTTimecardSettings record = (EipTTimecardSettings)aList.get(0);
            return record;
        }
        return null;
    }
}

