/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard.util;

import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecard;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystem;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystemMap;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ExtTimecardUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardUtils.class.getName());
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String TARGET_USER_ID = "target_user_id";
    public static final String WORK_FLG_ON = "1";
    public static final String WORK_FLG_OFF = "0";
    public static final String WORK_FLG_DUMMY = "-1";
    public static final String FOLDER_TMP_FOR_TIMECARD_FILES = JetspeedResources.getString((String)"aipo.tmp.timecard.directory", (String)"");
    public static final String EXTTIMECARD_PORTLET_NAME = "ExtTimecard";
    public static final String EXTTIMECARD_SYSTEM_PORTLET_NAME = "ExtTimecardSystem";

    public static EipTExtTimecard getEipTExtTimecard(RunData rundata, Context context) {
        String timecardid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        try {
            List timecards;
            if (timecardid == null || Integer.valueOf(timecardid) == null) {
                logger.debug((Object)"[ExtTimecardUtils.getEipTExtTimecard] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTExtTimecard.class);
            Expression exp11 = ExpressionFactory.matchDbExp((String)"TIMECARD_ID", (Object)timecardid);
            query.setQualifier(exp11);
            if (!aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 8)) {
                Expression exp21 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp21);
            }
            if ((timecards = query.fetchList()) == null || timecards.size() == 0) {
                logger.debug((Object)"[Timecard] Not found ID...");
                return null;
            }
            return (EipTExtTimecard)timecards.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    public static EipTExtTimecardSystem getEipTExtTimecardSystemCurrentUserId(RunData rundata, Context context) {
        int user_id = ALEipUtils.getUserId((RunData)rundata);
        return ExtTimecardUtils.getEipTExtTimecardSystemByUserId(user_id);
    }

    public static EipTExtTimecardSystem getEipTExtTimecardSystemByUserId(int user_id) {
        try {
            SelectQuery query = Database.query(EipTExtTimecardSystemMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)user_id);
            query.setQualifier(exp1);
            List slist = query.fetchList();
            if (slist == null || slist.size() == 0) {
                return ExtTimecardUtils.getEipTExtTimecardSystemById(1);
            }
            return ((EipTExtTimecardSystemMap)slist.get(0)).getEipTExtTimecardSystem();
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    public static EipTExtTimecardSystem getEipTExtTimecardSystemById(int system_id) {
        try {
            SelectQuery query = Database.query(EipTExtTimecardSystem.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SYSTEM_ID", (Object)system_id);
            query.setQualifier(exp1);
            List slist = query.fetchList();
            if (slist == null || slist.size() == 0) {
                return null;
            }
            return (EipTExtTimecardSystem)slist.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTExtTimecardSystem> getAllEipTExtTimecardSystem() {
        try {
            SelectQuery query = Database.query(EipTExtTimecardSystem.class);
            List slist = query.fetchList();
            if (slist == null || slist.size() == 0) {
                logger.debug((Object)"[ExtTimecardUtils] Not found ID...");
                return null;
            }
            return slist;
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    public static EipTExtTimecardSystem getEipTExtTimecardSystem(RunData rundata, Context context) {
        String systemid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (systemid == null || Integer.valueOf(systemid) == null) {
                logger.debug((Object)"[ExtTimecardUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTExtTimecardSystem.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SYSTEM_ID", (Object)systemid);
            query.setQualifier(exp1);
            List slist = query.fetchList();
            if (slist == null || slist.size() == 0) {
                logger.debug((Object)"[ExtTimecardUtils] Not found ID...");
                return null;
            }
            return (EipTExtTimecardSystem)slist.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return null;
        }
    }

    public static boolean sameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        return date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }

    public static EipTExtTimecard getUpdateEipTExtTimecard(RunData rundata, Context context) {
        EipTExtTimecardSystem system = ExtTimecardUtils.getEipTExtTimecardSystemCurrentUserId(rundata, context);
        Calendar calendar_now = Calendar.getInstance();
        Calendar from_calendar = Calendar.getInstance();
        int hour = system.getChangeHour();
        from_calendar.set(11, hour);
        from_calendar.set(12, 0);
        from_calendar.set(13, 0);
        if (calendar_now.before(from_calendar)) {
            from_calendar.add(5, -1);
        }
        from_calendar.set(11, 0);
        SelectQuery query = Database.query(EipTExtTimecard.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        Expression exp2 = ExpressionFactory.matchExp((String)"punchDate", (Object)from_calendar.getTime());
        query.setQualifier(exp1.andExp(exp2));
        List slist = query.fetchList();
        if (slist == null || slist.size() == 0) {
            return null;
        }
        return (EipTExtTimecard)slist.get(0);
    }

    public static float roundHour(float time) {
        time *= 10.0f;
        time = Math.round(time);
        return time /= 10.0f;
    }

    public static JetspeedLogger getLogger() {
        return logger;
    }
}

