/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.exttimecard.ExtTimecardListResultData;
import com.aimluck.eip.exttimecard.ExtTimecardResultData;
import com.aimluck.eip.exttimecard.ExtTimecardSelectData;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.ALXlsScreen;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ExtTimecardXlsExportScreen
extends ALXlsScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardXlsExportScreen.class.getName());
    public static final String FILE_NAME = "timecard.xls";
    private String userid;
    private String aclPortletFeature = null;

    public void init(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String target_user_id = rundata.getParameters().getString("target_user_id");
        this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.aclPortletFeature = target_user_id == null || "".equals(target_user_id) || this.userid.equals(target_user_id) ? "timecard_timecard_self" : "timecard_timecard_other";
        super.init(rundata, context);
    }

    protected boolean createHSSFWorkbook(RunData rundata, Context context, HSSFWorkbook wb) {
        try {
            this.setupTimecardSheet(rundata, context, wb);
        }
        catch (Exception e) {
            logger.error((Object)"TimecardCsvExportScreen", (Throwable)e);
            return false;
        }
        return true;
    }

    private void setupTimecardSheet(RunData rundata, Context context, HSSFWorkbook wb) throws Exception {
        ExtTimecardSelectData listData = new ExtTimecardSelectData();
        listData.initField();
        listData.setRowsNum(1000);
        listData.doViewList((ALAction)this, rundata, context);
        String sheet_name = "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9";
        String[] headers = new String[]{"\u6c0f\u540d", "\u65e5\u4ed8", "\u66dc\u65e5", "\u52e4\u52d9\u5f62\u614b", "\u51fa\u52e4\u6642\u9593", "\u9000\u52e4\u6642\u9593", "\u51fa\u52e4\u65e5\u6570", "\u5c31\u696d\u6642\u9593", "\u6b8b\u696d\u65e5\u6570", "\u6b8b\u696d\u6642\u9593", "\u4f11\u51fa\u65e5\u6570", "\u4f11\u51fa\u6642\u9593", "\u9045\u523b\u65e5\u6570", "\u65e9\u9000\u65e5\u6570", "\u6b20\u52e4\u65e5\u6570", "\u6709\u4f11\u65e5\u6570", "\u4ee3\u4f11\u65e5\u6570", "\u305d\u306e\u4ed6\u65e5\u6570", "\u4fee\u6b63\u7406\u7531\u3001\u5099\u8003", "\u5916\u51fa\uff11", "\u5fa9\u5e30\uff11", "\u5916\u51fa\uff12", "\u5fa9\u5e30\uff12", "\u5916\u51fa\uff13", "\u5fa9\u5e30\uff13", "\u5916\u51fa\uff14", "\u5fa9\u5e30\uff14", "\u5916\u51fa\uff15", "\u5fa9\u5e30\uff15"};
        short[] cell_enc_types = new short[]{1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        HSSFSheet sheet = this.createHSSFSheet(wb, sheet_name, headers, cell_enc_types);
        int rowcount = 0;
        HSSFCellStyle style_col = wb.createCellStyle();
        style_col.setVerticalAlignment((short)1);
        style_col.setAlignment((short)5);
        String user_name = ALEipUtils.getUserFullName((int)Integer.parseInt(listData.getTargetUserId()));
        String system_name = ExtTimecardUtils.getEipTExtTimecardSystemByUserId(Integer.parseInt(listData.getTargetUserId())).getSystemName();
        ExtTimecardListResultData tclistrd = null;
        List<ExtTimecardListResultData> daykeys = listData.getDateListKeys();
        int daykeysize = daykeys.size();
        for (int i = 0; i < daykeysize; ++i) {
            tclistrd = daykeys.get(i);
            String date = "";
            String day = "";
            String service_form = system_name;
            String clock_in_time = "";
            String clock_out_time = "";
            String work_day = "0";
            String work_hour = "0";
            String overtime_day = "0";
            String overtime_hour = "0";
            String off_day = "0";
            String off_hour = "0";
            String late_coming_day = "0";
            String early_leaving_day = "0";
            String absent_day = "0";
            String paid_holiday = "0";
            String compensatory_holiday = "0";
            String other_day = "0";
            String remark = "";
            String[] out_going = new String[5];
            String[] come_back = new String[5];
            if (tclistrd.getRd() == null) {
                date = tclistrd.getDateStr("yyyy/MM/dd");
                day = tclistrd.getDateStr("EE");
            } else {
                ExtTimecardResultData rd = tclistrd.getRd();
                date = tclistrd.getDateStr("yyyy/MM/dd");
                day = tclistrd.getDateStr("EE");
                String type = rd.getType().toString();
                if (type.equals("P")) {
                    clock_in_time = rd.getClockInTime("HH:mm");
                    clock_out_time = rd.getClockOutTime("HH:mm");
                    if ((double)tclistrd.getInworkHour() > 0.0) {
                        work_day = "1";
                        work_hour = Float.toString(tclistrd.getWorkHourWithoutRestHour());
                    } else {
                        work_hour = "0";
                    }
                    if ((double)tclistrd.getOutworkHour() > 0.0) {
                        overtime_day = "1";
                        overtime_hour = Float.toString(tclistrd.getOvertimeHourWithoutRestHour());
                    } else {
                        overtime_hour = "0";
                    }
                    if ((double)tclistrd.getOffWorkHour() > 0.0) {
                        off_day = "1";
                        off_hour = Float.toString(tclistrd.getOffWorkHour());
                    } else {
                        off_hour = "0";
                    }
                }
                if (rd.getRefixFlag().getValue() == "1") {
                    remark = rd.getReason().getValue();
                    if (rd.getReasonFlg() && rd.getRemarksFlg()) {
                        remark = remark + "\u3001";
                    }
                }
                if (rd.getRemarksFlg()) {
                    remark = remark + rd.getRemarks().getValue();
                }
                late_coming_day = tclistrd.isLateComing() ? "1" : "0";
                early_leaving_day = tclistrd.isEarlyLeaving() ? "1" : "0";
                absent_day = type.equals("A") ? "1" : "0";
                paid_holiday = type.equals("H") ? "1" : "0";
                compensatory_holiday = type.equals("C") ? "1" : "0";
                other_day = type.equals("E") ? "1" : "0";
                List<Map<String, String>> list = tclistrd.getOutgoingComeback_xls();
                for (int j = 0; j < 5; ++j) {
                    Map<String, String> map = list.get(j);
                    out_going[j] = map.get("outgoing");
                    come_back[j] = map.get("comeback");
                }
            }
            String[] rows = new String[]{user_name, date, day, service_form, clock_in_time, clock_out_time, work_day, work_hour, overtime_day, overtime_hour, off_day, off_hour, late_coming_day, early_leaving_day, absent_day, paid_holiday, compensatory_holiday, other_day, remark, out_going[0], come_back[0], out_going[1], come_back[1], out_going[2], come_back[2], out_going[3], come_back[3], out_going[4], come_back[4]};
            this.addRow(sheet.createRow(++rowcount), cell_enc_types, rows);
        }
        int uid = ALEipUtils.getUserId((RunData)rundata);
        ALEventlogFactoryService.getInstance().getEventlogHandler().logXlsScreen(uid, "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9\u51fa\u529b", 310);
    }

    protected String getFileName() {
        return FILE_NAME;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

