/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.res;

import com.sk_jp.res.RES;
import com.sk_jp.res.SKProps;
import com.sk_jp.sound.NullClip;
import com.sk_jp.sound.SKAudioClip;
import com.sk_jp.sound.SKClip;
import com.sk_jp.sound.SKMidiClip;
import com.sk_jp.sound.SKSoundClip;
import com.sk_jp.sound.SKSourceSoundClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;

public class Resources
extends SKProps {
    private String name;
    public Resources parent;
    public ResourceBundle bundle;
    public String imagesRoot;
    public String soundsRoot;
    private Map cache = new WeakHashMap();

    public Resources(String string) {
        this(string, null, null, null);
    }

    public Resources(String string, String string2) {
        this(string, string2, null, null);
    }

    public Resources(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public Resources(String string, String string2, String string3, Resources resources) {
        this.name = string;
        this.parent = resources;
        this.bundle = ResourceBundle.getBundle(string);
        if (this.bundle == null) {
            throw new IllegalArgumentException(string);
        }
        this.imagesRoot = string2;
        this.soundsRoot = string3;
    }

    public String get(String string) {
        try {
            return this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (this.parent != null) {
                return this.parent.get(string);
            }
            throw missingResourceException;
        }
    }

    public void set(String string, Object object) {
        throw new UnsupportedOperationException();
    }

    public ImageIcon getIcon(String string) {
        return new ImageIcon(this.getImage(string, false));
    }

    public Image getImage(String string, boolean bl) {
        Object object;
        boolean bl2 = true;
        if (bl2 && (object = (Image)this.cache.get(string)) != null) {
            return object;
        }
        if (this.imagesRoot == null) {
            if (this.parent != null) {
                return this.parent.getImage(string, bl);
            }
            throw new RuntimeException(string + " not found.");
        }
        object = this.getClass().getResource(this.imagesRoot + string);
        if (object == null) {
            System.err.println(this.imagesRoot + string + " not found");
            object = this.getClass().getResource(string);
            if (object == null) {
                if (this.parent != null) {
                    return this.parent.getImage(string, bl);
                }
                throw new RuntimeException(string + " not found.");
            }
        }
        Image image = Toolkit.getDefaultToolkit().getImage((URL)object);
        if (bl) {
            RES.preload(image);
        }
        if (bl2) {
            this.cache.put(string, image);
        }
        return image;
    }

    public SKClip getSound(String string) {
        return this.getSound(string, 0);
    }

    public SKClip getSound(String string, int n) {
        if (this.soundsRoot == null) {
            if (this.parent != null) {
                return this.parent.getSound(string, n);
            }
            throw new RuntimeException("soundsRoot is null.");
        }
        try {
            SKClip sKClip = (SKClip)this.cache.get(string);
            if (sKClip != null) {
                return Resources.createSound(n, sKClip);
            }
            URL uRL = this.getClass().getResource(this.soundsRoot + string);
            if (uRL == null) {
                System.err.println(this.soundsRoot + string + " not found");
                uRL = this.getClass().getResource(string);
                if (uRL == null) {
                    if (this.parent != null) {
                        return this.parent.getSound(string, n);
                    }
                    throw new RuntimeException(string + " not found.");
                }
            }
            sKClip = Resources.createSound(n, uRL);
            this.cache.put(string, sKClip);
            return sKClip;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return NullClip.INSTANCE;
        }
    }

    private static SKClip createSound(int n, SKClip sKClip) {
        switch (n) {
            case 0: {
                return new SKSourceSoundClip(sKClip);
            }
            case 1: {
                return new SKSoundClip(sKClip);
            }
            case 2: {
                return new SKAudioClip(sKClip);
            }
        }
        throw new IllegalArgumentException("illegal type " + n);
    }

    private static SKClip createSound(int n, URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        if ((string.endsWith("mid") || string.endsWith("MID") || string.endsWith("smf")) && n != 2) {
            return new SKMidiClip(uRL);
        }
        switch (n) {
            case 0: {
                return new SKSourceSoundClip(uRL);
            }
            case 1: {
                return new SKSoundClip(uRL);
            }
            case 2: {
                return new SKAudioClip(uRL);
            }
        }
        throw new IllegalArgumentException("illegal type " + n);
    }

    public String toString() {
        return this.name + (this.parent != null ? "\n->" + this.parent.toString() : "");
    }
}

