/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.sound;

import com.sk_jp.sound.SKClip;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.SysexMessage;

public class SKMidiClip
implements SKClip {
    private String name;
    private Sequence seq;
    private Sequencer sequencer;

    public SKMidiClip(URL uRL) throws IOException {
        this(uRL.openStream(), uRL.toString());
    }

    public SKMidiClip(InputStream inputStream, String string) throws IOException {
        this.name = string;
        try {
            this.seq = MidiSystem.getSequence(inputStream);
            this.init();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            throw new IOException(invalidMidiDataException.toString());
        }
    }

    public SKMidiClip(SKClip sKClip) {
        this.name = sKClip.getName();
        this.seq = ((SKMidiClip)sKClip).getSequence();
        this.init();
    }

    Sequence getSequence() {
        return this.seq;
    }

    private void init() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.setSequence(this.seq);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
    }

    public void setMute(boolean bl) {
    }

    public void setPan(float f) {
    }

    public void setSampleRate(float f) {
    }

    public void setVolume(float f) {
        try {
            SysexMessage sysexMessage = new SysexMessage();
            sysexMessage.setMessage(new byte[]{-16, 127, 127, 4, 1, 0, (byte)(f % 256.0f), -9}, 8);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public void play(int n) {
        this.sequencer.start();
    }

    public void play() {
        this.play(0);
    }

    public void loop() {
        this.play(0);
    }

    public void stop() {
        this.sequencer.stop();
    }
}

