/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml.conf;

import com.sk_jp.xml.DOMUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Configuration {
    private Document document;
    private Element current;
    private File file;

    public Configuration(String string) throws IOException {
        this(string, null);
    }

    public Configuration(String string, String string2) throws IOException {
        this.file = new File(string);
        this.load();
    }

    private Configuration(Element element) {
        this.current = element;
    }

    public void load() throws IOException {
        if (this.file == null) {
            throw new RuntimeException("This configuration is not root.");
        }
        this.document = DOMUtility.parse(this.file);
        this.current = this.document.getDocumentElement();
    }

    public Configuration getChild(String string) {
        Element element = DOMUtility.getElement(this.current, string);
        if (element == null) {
            return null;
        }
        return new Configuration(element);
    }

    public Iterator getChilds(final String string) {
        return new Iterator(){
            private Element c;
            {
                this.c = DOMUtility.getElement(Configuration.this.current, string);
            }

            public boolean hasNext() {
                return this.c != null;
            }

            public Object next() {
                Element element = this.c;
                this.c = DOMUtility.getNextSibling(this.c);
                return new Configuration(element);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List getChildsList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getChilds(string);
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            String string3 = configuration.getAttribute(string2);
            if (string3 == null) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public String getName() {
        return this.current.getNodeName();
    }

    public String getAttribute(String string, String string2) {
        String string3 = this.getAttribute(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public String getAttribute(String string) {
        String string2 = this.current.getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public Element getDOMElement() {
        return this.current;
    }

    public void setAttribute(String string, String string2) {
        this.current.setAttribute(string, string2);
    }

    private Element createChildElement(String string) {
        Element element = this.document == null ? this.current.getOwnerDocument().createElement(string) : this.document.createElement(string);
        this.current.appendChild(element);
        return element;
    }

    public Configuration createChild(String string) {
        Element element = this.createChildElement(string);
        return new Configuration(element);
    }

    public Configuration createChild(String string, String string2, String string3) {
        Element element = this.createChildElement(string);
        element.setAttribute(string2, string3);
        return new Configuration(element);
    }

    public Configuration createChild(String string, Map map) {
        Element element = this.createChildElement(string);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (map.get(string2) == null) continue;
            element.setAttribute(string2, (String)map.get(string2));
        }
        return new Configuration(element);
    }

    public void removeChilds(String string) {
        Iterator iterator = this.getChilds(string);
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            Element element = configuration.getDOMElement();
            try {
                this.current.removeChild(element);
            }
            catch (DOMException dOMException) {}
        }
    }

    public void removeChilds(String string, String string2, String string3) {
        Iterator iterator = this.getChilds(string);
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            if (!string3.equals(configuration.getAttribute(string2))) continue;
            Element element = configuration.getDOMElement();
            try {
                this.current.removeChild(element);
            }
            catch (DOMException dOMException) {}
        }
    }

    public void save() throws IOException {
        if (this.file == null) {
            throw new RuntimeException("This configuration is not root.");
        }
        try {
            this.removeWhitespaces(this.current);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(this.current), new StreamResult(new FileOutputStream(this.file)));
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessage());
        }
    }

    private void removeWhitespaces(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 3) {
                node2.setNodeValue(node2.getNodeValue().trim());
            }
            if (!node2.hasChildNodes()) continue;
            this.removeWhitespaces(node2);
        }
    }
}

