/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.response;

import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.response.ServiceInfos;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceList
extends UDDIElement {
    public static final String UDDI_TAG = "serviceList";
    protected Element base = null;
    String operator = null;
    String truncated = null;
    ServiceInfos serviceInfos = null;

    public ServiceList() {
    }

    public ServiceList(String string, ServiceInfos serviceInfos) {
        this.operator = string;
        this.serviceInfos = serviceInfos;
    }

    public ServiceList(Element element) throws UDDIException {
        super(element);
        this.operator = element.getAttribute("operator");
        this.truncated = element.getAttribute("truncated");
        NodeList nodeList = null;
        nodeList = this.getChildElementsByTagName(element, "serviceInfos");
        if (nodeList.getLength() > 0) {
            this.serviceInfos = new ServiceInfos((Element)nodeList.item(0));
        }
    }

    public String getOperator() {
        return this.operator;
    }

    public ServiceInfos getServiceInfos() {
        return this.serviceInfos;
    }

    public String getTruncated() {
        return this.truncated;
    }

    public boolean getTruncatedBoolean() {
        return this.truncated.equals("true");
    }

    public void saveToXML(Element element) {
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        this.base.setAttribute("generic", UDDIElement.GENERIC);
        this.base.setAttribute("xmlns", UDDIElement.XMLNS);
        if (this.operator != null) {
            this.base.setAttribute("operator", this.operator);
        }
        if (this.truncated != null) {
            this.base.setAttribute("truncated", this.truncated);
        }
        if (this.serviceInfos != null) {
            this.serviceInfos.saveToXML(this.base);
        }
        element.appendChild(this.base);
    }

    public void setOperator(String string) {
        this.operator = string;
    }

    public void setServiceInfos(ServiceInfos serviceInfos) {
        this.serviceInfos = serviceInfos;
    }

    public void setTruncated(String string) {
        this.truncated = string;
    }

    public void setTruncated(boolean bl) {
        this.truncated = bl ? "true" : "false";
    }
}

