/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.page;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.page.util.PageUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Controller;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.psml.PsmlController;
import org.apache.jetspeed.om.profile.psml.PsmlLayout;
import org.apache.jetspeed.om.profile.psml.PsmlMetaInfo;
import org.apache.jetspeed.om.profile.psml.PsmlPortlets;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.idgenerator.JetspeedIdGenerator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class PageFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PageFormData.class.getName());
    private static final int MAX_PAGE_NUM = 7;
    private int currentPageNum = 1;
    private ALStringField page_id;
    private ALStringField page_title;
    private ALStringField page_description;
    private boolean enableAddPage = true;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        Portlets portlets;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"entityid")) {
            if (rundata.getParameters().getString("entityid").equals("new")) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
            } else {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)rundata.getParameters().getString("entityid"));
            }
        }
        if ((portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets()) != null) {
            Portlets[] portletList = portlets.getPortletsArray();
            this.currentPageNum = portletList.length;
        }
    }

    protected void setValidator() {
        this.page_title.setNotNull(true);
        this.page_title.limitMaxLength(10);
        this.page_description.setNotNull(false);
        this.page_description.limitMaxLength(20);
    }

    protected boolean validate(List<String> msgList) {
        if (this.currentPageNum > 7) {
            msgList.add("\u3053\u308c\u4ee5\u4e0a\u30da\u30fc\u30b8\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.page_title.getValue().equals("\u30de\u30a4\u30da\u30fc\u30b8")) {
            msgList.add("\u30da\u30fc\u30b8\u540d\u300c\u30de\u30a4\u30da\u30fc\u30b8\u300d\u306f\u3059\u3067\u306b\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            return false;
        }
        this.page_title.validate(msgList);
        this.page_description.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String pageId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (pageId == null || pageId.equals("")) {
                return false;
            }
            this.page_id.setValue(pageId);
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return false;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return false;
            }
            String pageidStr = this.page_id.getValue();
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                if (!portletList[i].getId().equals(pageidStr)) continue;
                MetaInfo info = portletList[i].getMetaInfo();
                if (info != null) {
                    this.page_title.setValue(info.getTitle());
                    this.page_description.setValue(info.getDescription());
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"page", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            String title = this.page_title.getValue();
            if (title == null || title.equals("")) {
                title = "\u30de\u30a4\u30da\u30fc\u30b8";
            }
            if (portlets != null) {
                Portlets[] childPortlets;
                List<Portlets> portletList = Arrays.asList(portlets.getPortletsArray());
                int length = portletList.size();
                if (length >= 7) {
                    this.enableAddPage = false;
                    msgList.add("\u3053\u308c\u4ee5\u4e0a\u30da\u30fc\u30b8\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                long move_pages = 1L;
                Collections.sort(portletList, new Comparator<Portlets>(){

                    @Override
                    public int compare(Portlets o1, Portlets o2) {
                        return (int)(o1.getLayout().getPosition() - o2.getLayout().getPosition());
                    }
                });
                if (ALEipUtils.isAdmin((RunData)rundata)) {
                    ++move_pages;
                }
                int portletSize = portletList.size();
                long position = Long.MAX_VALUE;
                while (move_pages > 0L) {
                    Layout layout = portletList.get((int)((long)portletSize - move_pages)).getLayout();
                    long newPosition = layout.getPosition() + 1L;
                    layout.setPosition(newPosition);
                    position = position > newPosition ? newPosition : position;
                    --move_pages;
                }
                PsmlLayout newLayout = new PsmlLayout();
                newLayout.setPosition(--position);
                newLayout.setSize(-1L);
                PsmlController controller = new PsmlController();
                controller.setName("TwoColumnsRight");
                PsmlPortlets p = new PsmlPortlets();
                p.setLayout((Layout)newLayout);
                p.setController((Controller)controller);
                p.setMetaInfo((MetaInfo)new PsmlMetaInfo());
                p.getMetaInfo().setTitle(title);
                p.getMetaInfo().setDescription(this.page_description.getValue());
                p.setId(JetspeedIdGenerator.getNextPeid());
                SecurityReference defaultRef = PortalToolkit.getDefaultSecurityRef((Profile)((JetspeedRunData)rundata).getProfile());
                if (defaultRef != null) {
                    p.setSecurityRef(defaultRef);
                }
                ArrayList<Portlets> olist = new ArrayList<Portlets>();
                ArrayList<Portlets> nolist = new ArrayList<Portlets>();
                for (Portlets _portlets : childPortlets = portlets.getPortletsArray()) {
                    if (_portlets.getSecurityRef().getParent().equals("owner-only")) {
                        olist.add(_portlets);
                        continue;
                    }
                    nolist.add(_portlets);
                }
                for (int pos = childPortlets.length; 0 < pos; --pos) {
                    portlets.removePortlets(pos - 1);
                }
                for (Portlets _p : olist) {
                    portlets.addPortlets(_p);
                }
                portlets.addPortlets((Portlets)p);
                for (Portlets _p : nolist) {
                    portlets.addPortlets(_p);
                }
                PageUtils.doSave(rundata, context);
                PageUtils.updateLayoutPositions(portlets);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"page", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String pageId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (pageId == null || pageId.equals("")) {
                return false;
            }
            this.page_id.setValue(pageId);
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return false;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return false;
            }
            String pageidStr = this.page_id.getValue();
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                if (!portletList[i].getId().equals(pageidStr)) continue;
                MetaInfo info = portletList[i].getMetaInfo();
                if (info == null) {
                    info = new PsmlMetaInfo();
                    portletList[i].setMetaInfo(info);
                }
                info.setTitle(this.page_title.getValue());
                info.setDescription(this.page_description.getValue());
                break;
            }
            PageUtils.doSave(rundata, context);
            PageUtils.updateLayoutPositions(portlets);
        }
        catch (Exception ex) {
            logger.error((Object)"page", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        boolean result = false;
        try {
            String portletId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (portletId == null || portletId.equals("")) {
                return false;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(portletId);
            result = PageUtils.deletePages(rundata, context, values, msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"page", (Throwable)ex);
            return false;
        }
        return result;
    }

    public void initField() {
        this.page_id = new ALStringField();
        this.page_id.setFieldName("\u30da\u30fc\u30b8 ID");
        this.page_id.setTrim(true);
        this.page_title = new ALStringField();
        this.page_title.setFieldName("\u30da\u30fc\u30b8\u540d");
        this.page_title.setTrim(true);
        this.page_description = new ALStringField();
        this.page_description.setFieldName("\u30da\u30fc\u30b8\u306e\u8aac\u660e");
        this.page_description.setTrim(true);
    }

    public ALStringField getPageId() {
        return this.page_id;
    }

    public ALStringField getPageDescription() {
        return this.page_description;
    }

    public ALStringField getPageTitle() {
        return this.page_title;
    }

    public boolean enableAddPage() {
        return this.enableAddPage;
    }
}

