/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.schedule.ScheduleListContainer;
import com.aimluck.eip.schedule.ScheduleMonthlySelectData;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleSearchResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleListSelectData
extends ScheduleMonthlySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleListSelectData.class.getName());
    private ALDateTimeField prevDate;
    private ALDateTimeField nextDate;
    private ALDateTimeField prevWeek;
    private ALDateTimeField nextWeek;
    private ALDateTimeField viewStart;
    private ALDateTimeField viewEnd;
    private boolean hasAclviewOther;
    protected String listViewtype;
    private ScheduleListContainer con;
    private int userid;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String tmpViewStart;
        super.init(action, rundata, context);
        this.listViewtype = "list";
        this.prevDate = new ALDateTimeField("yyyy-MM-dd");
        this.nextDate = new ALDateTimeField("yyyy-MM-dd");
        this.prevWeek = new ALDateTimeField("yyyy-MM-dd");
        this.nextWeek = new ALDateTimeField("yyyy-MM-dd");
        this.viewStart = new ALDateTimeField("yyyy-MM-dd");
        this.viewStart.setNotNull(true);
        this.viewEnd = new ALDateTimeField("yyyy-MM-dd");
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_start")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_start", (String)rundata.getParameters().getString("view_start"));
        }
        if ((tmpViewStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_start")) == null || tmpViewStart.equals("")) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            this.viewStart.setValue(cal.getTime());
        } else {
            this.viewStart.setValue(tmpViewStart);
            if (!this.viewStart.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_start");
                throw new ALPageNotFoundException();
            }
        }
        this.setMonthlyCalendarViewMonth(this.viewStart.getYear(), this.viewStart.getMonth());
        this.setMonthlyCalendar(rundata, context);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(this.viewStart.getValue());
        cal2.add(5, 1);
        this.nextDate.setValue(cal2.getTime());
        cal2.add(5, 6);
        this.nextWeek.setValue(cal2.getTime());
        cal2.add(5, -8);
        this.prevDate.setValue(cal2.getTime());
        cal2.add(5, -6);
        this.prevWeek.setValue(cal2.getTime());
        cal2.add(5, 7);
        cal2.add(5, -1);
        this.viewEnd.setValue(cal2.getTime());
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.viewStart.toString() + "-00-00"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.viewStart.toString() + "-00-00"));
        Calendar cal4 = Calendar.getInstance();
        cal4.setTime(this.viewStart.getValue());
        cal4.add(5, 7);
        this.viewEnd.setValue(cal4.getTime());
        this.userid = ALEipUtils.getUserId((RunData)rundata);
        this.con = new ScheduleListContainer();
        this.con.initField();
        Calendar cal5 = Calendar.getInstance();
        cal5.setTime(this.viewStart.getValue());
        this.con.setViewStartDate(cal5);
        int loginUserId = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclviewOther = aclhandler.hasAuthority(loginUserId, "schedule_other", 1);
    }

    @Override
    protected ResultList<VEipTScheduleList> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.setupLists(rundata, context);
            List<VEipTScheduleList> resultBaseList = this.getScheduleList(rundata, context);
            List<VEipTScheduleList> resultList = ScheduleUtils.sortByDummySchedule(resultBaseList);
            return new ResultList(resultList);
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleListSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    protected List<VEipTScheduleList> getScheduleList(RunData rundata, Context context) {
        Integer targetId = null;
        boolean isFacility = false;
        if (this.target_user_id != null && !this.target_user_id.equals("")) {
            if (!this.hasAclviewOther && !this.target_user_id.startsWith("f")) {
                targetId = this.userid;
            } else if (this.target_user_id.startsWith("f")) {
                String fid = this.target_user_id.substring("f".length(), this.target_user_id.length());
                targetId = Integer.valueOf(fid);
                isFacility = true;
            } else {
                targetId = Integer.valueOf(this.target_user_id);
            }
        } else {
            return new ArrayList<VEipTScheduleList>();
        }
        return ScheduleUtils.getScheduleList(this.userid, this.viewStart.getValue(), this.viewEnd.getValue(), isFacility ? null : Arrays.asList(targetId), isFacility ? Arrays.asList(targetId) : null);
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleSearchResultData rd = new ScheduleSearchResultData();
        rd.initField();
        try {
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            boolean is_member = record.isMember();
            if (!"D".equals(record.getStatus()) && "P".equals(record.getPublicFlag()) && this.userid != record.getUserId() && this.userid != record.getOwnerId() && !is_member) {
                return null;
            }
            if ("C".equals(record.getPublicFlag()) && this.userid != record.getUserId() && this.userid != record.getOwnerId() && !is_member) {
                rd.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
                rd.setTmpreserve(false);
            } else {
                rd.setName(record.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            if (!this.hasAclviewOther && !is_member) {
                return rd;
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId() == this.userid);
            rd.setOwner(record.getOwnerId() == this.userid);
            rd.setMember(is_member);
            rd.setPattern(record.getRepeatPattern());
            rd.setCreateUser(ALEipUtils.getALEipUser((int)record.getCreateUserId()));
            if (!rd.getPattern().equals("N")) {
                rd.setRepeat(true);
            }
            this.con.addResultData(rd);
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleListSelectData]", (Throwable)e);
            return null;
        }
        return rd;
    }

    @Override
    public ALDateTimeField getViewStart() {
        return this.viewStart;
    }

    @Override
    public ALDateTimeField getViewEnd() {
        return this.viewEnd;
    }

    @Override
    public String getViewtype() {
        return this.listViewtype;
    }

    public ALDateTimeField getPrevDate() {
        return this.prevDate;
    }

    public ALDateTimeField getPrevWeek() {
        return this.prevWeek;
    }

    public ALDateTimeField getNextDate() {
        return this.nextDate;
    }

    public ALDateTimeField getNextWeek() {
        return this.nextWeek;
    }

    public List<ScheduleResultData> getScheduleList() {
        return this.con.getScheduleList();
    }

    public String getViewStartFormat() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_DATE_FORMAT_NOSPACE", (Object[])new Object[]{this.getViewStart().getYear(), this.getViewStart().getMonth(), this.getViewStart().getDay()});
    }

    public String getViewEndFormat() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_DATE_FORMAT_NOSPACE", (Object[])new Object[]{this.getViewEnd().getYear(), this.getViewEnd().getMonth(), this.getViewEnd().getDay()});
    }

    public boolean isLoginUserID(Long id) {
        return id == (long)this.userid;
    }
}

