/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.AjaxScheduleMonthlySelectData;
import com.aimluck.eip.schedule.ScheduleMonthContainer;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleTermMonthContainer;
import com.aimluck.eip.schedule.ScheduleToDoMonthContainer;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.portal.ALPortalApplicationService;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleMonthlySelectData
extends AjaxScheduleMonthlySelectData {
    private final String TARGET_GROUP_NAME = "target_group_name";
    private final String TARGET_USER_ID = "target_user_id";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleMonthlySelectData.class.getName());
    private ALDateTimeField viewMonth;
    private ALDateTimeField prevMonth;
    private ALDateTimeField nextMonth;
    private ALDateTimeField prevYear;
    private ALDateTimeField nextYear;
    private ALDateTimeField currentMonth;
    private ALDateTimeField today;
    private ALDateTimeField viewStart;
    private ALDateTimeField viewEnd;
    private ALDateTimeField viewEndCrt;
    protected String viewtype;
    private ScheduleMonthContainer monthCon;
    private List<ALEipGroup> myGroupList = null;
    private List<ALEipGroup> facilitiyGroups;
    private List<ALEipUser> userList = null;
    private String userid;
    private ALEipUser user;
    private ScheduleTermMonthContainer termMonthCon;
    private ScheduleToDoMonthContainer monthTodoCon;
    private String portletId;
    private List<FacilityResultData> facilityList;
    private boolean hasAclviewOther;
    private boolean hasAuthoritySelfInsert = false;
    private boolean hasAuthorityFacilityInsert = false;
    private String target_user_name;
    protected int viewTodo;
    protected String target_group_name;
    protected String target_user_id;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        block20: {
            Calendar cal;
            String tmpViewMonth;
            this.viewtype = "monthly";
            this.viewMonth = new ALDateTimeField("yyyy-MM");
            this.viewMonth.setNotNull(true);
            this.prevMonth = new ALDateTimeField("yyyy-MM");
            this.nextMonth = new ALDateTimeField("yyyy-MM");
            this.prevYear = new ALDateTimeField("yyyy-MM");
            this.nextYear = new ALDateTimeField("yyyy-MM");
            this.currentMonth = new ALDateTimeField("yyyy-MM");
            this.viewStart = new ALDateTimeField("yyyy-MM-dd");
            this.viewEnd = new ALDateTimeField("yyyy-MM-dd");
            this.viewEndCrt = new ALDateTimeField("yyyy-MM-dd");
            this.today = new ALDateTimeField("yyyy-MM-dd");
            Calendar to = Calendar.getInstance();
            to.set(11, 0);
            to.set(12, 0);
            this.today.setValue(to.getTime());
            this.currentMonth.setValue(to.getTime());
            if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
                if (rundata.getParameters().containsKey((Object)"view_month")) {
                    tmpViewMonth = rundata.getParameters().getString("view_month");
                    if (!tmpViewMonth.equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_month"))) {
                        // empty if block
                    }
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_month", (String)tmpViewMonth);
                } else {
                    String tmpViewStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_start");
                    if (tmpViewStart != null && tmpViewStart.length() >= 7) {
                        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_month", (String)tmpViewStart.substring(0, 7));
                    }
                }
            }
            if ((tmpViewMonth = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_month")) == null || tmpViewMonth.equals("")) {
                cal = Calendar.getInstance();
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                this.viewMonth.setValue(cal.getTime());
            } else {
                this.viewMonth.setValue(tmpViewMonth);
                if (!this.viewMonth.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_month");
                    throw new ALPageNotFoundException();
                }
            }
            this.setMonthlyCalendarViewMonth(this.viewMonth.getYear(), this.viewMonth.getMonth());
            cal = Calendar.getInstance();
            Calendar tmpCal = Calendar.getInstance();
            cal.setTime(this.viewMonth.getValue());
            tmpCal.setTime(this.viewMonth.getValue());
            int dayofweek = cal.get(7);
            cal.add(5, -dayofweek + 1);
            this.viewStart.setValue(cal.getTime());
            Calendar cal4 = Calendar.getInstance();
            cal4.setTime(cal.getTime());
            Calendar tmpCal4 = Calendar.getInstance();
            tmpCal4.setTime(tmpCal.getTime());
            Calendar cal5 = Calendar.getInstance();
            cal5.setTime(cal.getTime());
            Calendar tmpCal5 = Calendar.getInstance();
            tmpCal5.setTime(tmpCal.getTime());
            try {
                this.termMonthCon = new ScheduleTermMonthContainer();
                this.termMonthCon.initField();
                this.termMonthCon.setViewMonth(cal4, tmpCal4);
                this.monthCon = new ScheduleMonthContainer();
                this.monthCon.initField();
                this.monthCon.setViewMonth(cal, tmpCal);
                this.monthTodoCon = new ScheduleToDoMonthContainer();
                this.monthTodoCon.initField();
                this.monthTodoCon.setViewMonth(cal5, tmpCal5);
            }
            catch (Exception e) {
                logger.error((Object)"schedule", (Throwable)e);
            }
            this.viewEndCrt.setValue(cal.getTime());
            cal.add(5, -1);
            this.viewEnd.setValue(cal.getTime());
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(this.viewMonth.getValue());
            cal2.add(2, 1);
            this.nextMonth.setValue(cal2.getTime());
            cal2.add(2, -2);
            this.prevMonth.setValue(cal2.getTime());
            cal2.add(2, 1);
            cal2.add(1, 1);
            this.nextYear.setValue(cal2.getTime());
            cal2.add(1, -2);
            this.prevYear.setValue(cal2.getTime());
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.viewStart.toString() + "-00-00"));
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.viewStart.toString() + "-00-00"));
            this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList<ALEipGroup>();
            this.facilitiyGroups = ALEipUtils.getALEipGroups();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add((ALEipGroup)myGroups.get(i));
            }
            try {
                VelocityPortlet portlet;
                String groupFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_group_name");
                if ((groupFilter == null || groupFilter.equals("")) && (groupFilter = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-group")) != null) {
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)groupFilter);
                }
                this.current_filter = groupFilter;
                String userFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_user_id");
                if (userFilter == null || userFilter.equals("")) {
                    VelocityPortlet portlet2 = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
                    userFilter = portlet2.getPortletConfig().getInitParameter("p3a-user");
                }
                if (userFilter == null || userFilter.equals("")) break block20;
                int paramId = -1;
                if ("all".equals(userFilter)) {
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userFilter);
                    break block20;
                }
                if (userFilter.startsWith("f")) {
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userFilter);
                    break block20;
                }
                try {
                    paramId = Integer.parseInt(userFilter);
                    if (paramId <= 3) break block20;
                    String query = "SELECT LOGIN_NAME FROM turbine_user WHERE USER_ID = '" + paramId + "' AND DISABLED = 'F'";
                    List list = Database.sql(TurbineUser.class, (String)query).fetchList();
                    if (list != null && list.size() != 0) {
                        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userFilter);
                        break block20;
                    }
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
                }
                catch (NumberFormatException e) {}
            }
            catch (Exception ex) {
                logger.error((Object)"schedule", (Throwable)ex);
            }
        }
        this.viewTodo = !ALPortalApplicationService.isActive((String)"ToDo") ? 0 : Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p5a-view"));
        int loginUserId = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclviewOther = aclhandler.hasAuthority(loginUserId, "schedule_other", 1);
        this.hasAuthoritySelfInsert = aclhandler.hasAuthority(loginUserId, "schedule_self", 4);
        this.hasAuthorityFacilityInsert = aclhandler.hasAuthority(loginUserId, "schedule_facility", 4);
        this.setUser(ALEipUtils.getALEipUser((int)loginUserId));
        super.init(action, rundata, context);
    }

    @Override
    protected ResultList<VEipTScheduleList> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.setupLists(rundata, context);
            List<VEipTScheduleList> list = this.getScheduleList(rundata, context);
            if (!this.target_user_id.startsWith("f") && this.viewTodo == 1) {
                this.loadTodo(rundata, context);
            }
            ScheduleUtils.sortByTime(list);
            return new ResultList(ScheduleUtils.sortByDummySchedule(list));
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleMonthlySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    private List<VEipTScheduleList> getScheduleList(RunData rundata, Context context) {
        Integer targetId = null;
        boolean isFacility = false;
        if (this.target_user_id != null && !this.target_user_id.equals("")) {
            if (this.target_user_id.startsWith("f")) {
                String fid = this.target_user_id.substring("f".length(), this.target_user_id.length());
                targetId = Integer.valueOf(fid);
                isFacility = true;
            } else {
                targetId = Integer.valueOf(this.target_user_id);
            }
        } else {
            return new ArrayList<VEipTScheduleList>();
        }
        return ScheduleUtils.getScheduleList(Integer.valueOf(this.userid), this.viewStart.getValue(), this.viewEndCrt.getValue(), isFacility ? null : Arrays.asList(targetId), isFacility ? Arrays.asList(targetId) : null);
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleResultData rd = new ScheduleResultData();
        rd.initField();
        try {
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            int userid_int = Integer.parseInt(this.userid);
            boolean is_member = record.isMember();
            if (!"D".equals(record.getStatus()) && "P".equals(record.getPublicFlag()) && userid_int != record.getUserId() && userid_int != record.getOwnerId() && !is_member) {
                return rd;
            }
            if (!this.hasAclviewOther && !is_member) {
                return rd;
            }
            if ("C".equals(record.getPublicFlag()) && userid_int != record.getUserId() && userid_int != record.getOwnerId() && !is_member) {
                rd.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
                rd.setTmpreserve(false);
            } else {
                rd.setName(record.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            rd.setPlace(record.getPlace());
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId() == userid_int);
            rd.setOwner(record.getOwnerId() == userid_int);
            rd.setMember(is_member);
            rd.setPattern(record.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                int stime = -((int)((this.viewStart.getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.viewStart.getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                int count = stime;
                int col = etime - stime + 1;
                int row = count / 7;
                count %= 7;
                while (count + col > 7) {
                    ScheduleResultData rd3 = (ScheduleResultData)rd.clone();
                    rd3.setRowspan(7 - count);
                    this.termMonthCon.addTermResultData(count, row, rd3);
                    count = 0;
                    col -= rd3.getRowspan();
                    ++row;
                }
                rd.setRowspan(col);
                if (col > 0) {
                    this.termMonthCon.addTermResultData(count, row, rd);
                }
                return rd;
            }
            this.monthCon.addResultData(rd);
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    @Override
    protected VEipTScheduleList selectDetail(RunData rundata, Context context) {
        return null;
    }

    @Override
    protected Object getResultDataDetail(VEipTScheduleList record) {
        return null;
    }

    @Override
    protected Attributes getColumnMap() {
        return null;
    }

    public void loadTodo(RunData rundata, Context context) {
        try {
            SelectQuery<EipTTodo> query = this.getSelectQueryForTodo(rundata, context);
            if (query != null) {
                List todos = query.fetchList();
                int todossize = todos.size();
                for (int i = 0; i < todossize; ++i) {
                    EipTTodo record = (EipTTodo)todos.get(i);
                    ScheduleToDoResultData rd = new ScheduleToDoResultData();
                    rd.initField();
                    String todo_url = "";
                    todo_url = this.userid.equals(this.target_user_id) ? ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId) : ScheduleUtils.getPortletURItoTodoPublicDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId);
                    rd.setTodoId(record.getTodoId().longValue());
                    rd.setTodoName(record.getTodoName());
                    rd.setUserId(record.getTurbineUser().getUpdatedUserId().intValue());
                    rd.setStartDate(record.getStartDate());
                    rd.setEndDate(record.getEndDate());
                    rd.setTodoUrl(todo_url);
                    rd.setPublicFlag("T".equals(record.getPublicFlag()));
                    int stime = ScheduleUtils.equalsToDate(ToDoUtils.getEmptyDate(), rd.getStartDate().getValue(), false) ? 0 : -((int)((this.viewStart.getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                    int etime = -((int)((this.viewStart.getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                    if (stime < 0) {
                        stime = 0;
                    }
                    int count = stime;
                    int col = etime - stime + 1;
                    int row = count / 7;
                    count %= 7;
                    while (count + col > 7) {
                        ScheduleToDoResultData rd3 = (ScheduleToDoResultData)rd.clone();
                        rd3.setRowspan(7 - count);
                        this.monthTodoCon.addToDoResultData(count, row, rd3);
                        count = 0;
                        col -= rd3.getRowspan();
                        ++row;
                    }
                    rd.setRowspan(col);
                    if (col <= 0) continue;
                    this.monthTodoCon.addToDoResultData(count, row, rd);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return;
        }
    }

    private SelectQuery<EipTTodo> getSelectQueryForTodo(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        if (this.target_user_id == null || this.target_user_id.equals("")) {
            return null;
        }
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(this.target_user_id));
        query.andQualifier(exp3);
        if (!this.userid.equals(this.target_user_id)) {
            Expression exp4 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            query.andQualifier(exp4);
        }
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewStart().getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewEnd().getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewEnd().getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewStart().getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        query.orderAscending("startDate");
        return query;
    }

    public String getViewtype() {
        return this.viewtype;
    }

    public ALDateTimeField getViewStart() {
        return this.viewStart;
    }

    public ALDateTimeField getViewEnd() {
        return this.viewEnd;
    }

    public ALDateTimeField getViewEndCrt() {
        return this.viewEndCrt;
    }

    public ALDateTimeField getPrevMonth() {
        return this.prevMonth;
    }

    public ALDateTimeField getNextMonth() {
        return this.nextMonth;
    }

    public ALDateTimeField getPrevYear() {
        return this.prevYear;
    }

    public ALDateTimeField getNextYear() {
        return this.nextYear;
    }

    public ALDateTimeField getViewMonth() {
        return this.viewMonth;
    }

    public String getViewMonthText() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_DATE_MONTH_FORMAT", (Object[])new Object[]{this.viewMonth.getYear(), this.viewMonth.getMonth()});
    }

    public ALDateTimeField getToday() {
        return this.today;
    }

    public ALDateTimeField getCurrentMonth() {
        return this.currentMonth;
    }

    public ScheduleMonthContainer getContainer() {
        return this.monthCon;
    }

    protected void setupLists(RunData rundata, Context context) {
        this.target_group_name = this.getTargetGroupName(rundata, context);
        boolean fgroup_flag = false;
        String target_group_id = "";
        this.current_filter = this.target_group_name;
        String[] target = this.target_group_name.split(";");
        String[] target2 = this.target_group_name.split("_");
        if ("f".equals(target[0])) {
            target_group_id = target[1];
        }
        if ("f".equals(target2[0])) {
            target_group_id = target2[1];
            fgroup_flag = true;
        }
        if (!this.target_group_name.equals("") && !this.target_group_name.equals("all") && this.target_group_name.equals("Facility")) {
            this.userList = ALEipUtils.getUsers((String)this.target_group_name);
            this.facilityList = FacilitiesUtils.getFacilityList((String)this.target_group_name);
        } else if (!this.target_group_name.equals("") && !this.target_group_name.equals("all")) {
            this.userList = ALEipUtils.getUsers((String)this.target_group_name);
            this.facilityList = fgroup_flag ? FacilitiesUtils.getFacilityGroupList((Integer)Integer.valueOf(target_group_id)) : FacilitiesUtils.getFacilityList((String)this.target_group_name);
        } else {
            this.userList = ALEipUtils.getUsers((String)"LoginUser");
            this.facilityList = FacilitiesUtils.getFacilityAllList();
        }
        if (!(this.userList != null && this.userList.size() != 0 || this.facilityList != null && this.facilityList.size() != 0)) {
            this.target_user_id = "";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
            return;
        }
        this.target_user_id = this.getTargetUserId(rundata, context);
        if (this.target_user_id == null) {
            this.target_user_id = "";
        }
        try {
            if ("".equals(this.target_user_id) || this.target_user_id.startsWith("f") || "all".equals(this.target_user_id)) {
                this.target_user_name = null;
            } else {
                ALEipUser tempuser = ALEipUtils.getALEipUser((int)Integer.parseInt(this.target_user_id));
                this.target_user_name = tempuser.getName().getValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleMonthlySelectData]", (Throwable)e);
            this.target_user_name = null;
        }
    }

    protected String getTargetGroupName(RunData rundata, Context context) {
        return this.getTargetGroupName(rundata, context, "target_group_name");
    }

    protected String getTargetGroupName(RunData rundata, Context context, String target_key) {
        String target_group_name = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString(target_key);
        }
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)target_key);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    protected String getTargetUserId(RunData rundata, Context context, String target_key) {
        String target_user_id = null;
        String idParam = null;
        String tmp_user_id = "";
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString(target_key);
        }
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)target_key);
        if ("Facility".equals(this.getTargetGroupName())) {
            if (this.facilityList != null && this.facilityList.size() > 0) {
                tmp_user_id = idParam == null && target_user_id == null ? "" : (idParam != null ? idParam : target_user_id);
                if ("all".equals(tmp_user_id) && !"monthly".equals(this.viewtype)) {
                    target_user_id = "all";
                } else if (this.containsFacilityId(this.facilityList, tmp_user_id)) {
                    target_user_id = tmp_user_id;
                } else {
                    FacilityResultData rd = this.facilityList.get(0);
                    target_user_id = "f" + rd.getFacilityId().getValue();
                }
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)target_user_id);
            }
        } else {
            tmp_user_id = idParam == null && target_user_id == null ? (target_key.matches("target_user_id") ? this.userid : "all") : (idParam != null ? idParam : target_user_id);
            if (tmp_user_id.startsWith("f")) {
                if (this.containsFacilityId(this.facilityList, tmp_user_id)) {
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)tmp_user_id);
                    target_user_id = tmp_user_id;
                } else if (this.facilityList != null && this.facilityList.size() > 0) {
                    FacilityResultData rd = this.facilityList.get(0);
                    target_user_id = "f" + rd.getFacilityId().getValue();
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)target_user_id);
                } else {
                    target_user_id = this.userid;
                }
            } else if (this.userList != null && this.userList.size() > 0) {
                if ("all".equals(tmp_user_id) && !"monthly".equals(this.viewtype)) {
                    target_user_id = "all";
                } else if (this.containsUserId(this.userList, tmp_user_id)) {
                    target_user_id = tmp_user_id;
                } else if (this.containsUserId(this.userList, this.userid)) {
                    target_user_id = this.userid;
                } else {
                    String userId;
                    ALEipUser eipUser = this.userList.get(0);
                    target_user_id = userId = eipUser.getUserId().getValueAsString();
                }
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)target_user_id);
            } else if (this.facilityList != null && this.facilityList.size() > 0) {
                FacilityResultData rd = this.facilityList.get(0);
                target_user_id = "f" + rd.getFacilityId().getValue();
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)target_user_id);
            }
        }
        return target_user_id;
    }

    protected String getTargetUserId(RunData rundata, Context context) {
        return this.getTargetUserId(rundata, context, "target_user_id");
    }

    private boolean containsUserId(List<ALEipUser> list, String userid) {
        if (list == null || list.size() <= 0) {
            return false;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ALEipUser eipUser = list.get(i);
            String eipUserId = eipUser.getUserId().getValueAsString();
            if (!userid.equals(eipUserId)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFacilityId(List<FacilityResultData> list, String facility_id) {
        if (list == null || list.size() <= 0) {
            return false;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            FacilityResultData facility = list.get(i);
            String fid = "f" + facility.getFacilityId().toString();
            if (!facility_id.equals(fid)) continue;
            return true;
        }
        return false;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public List<ALEipUser> getUsers() {
        if (this.hasAclviewOther || this.target_group_name.equals("Facility")) {
            return this.userList;
        }
        try {
            ArrayList<ALEipUser> users = new ArrayList<ALEipUser>();
            users.add(ALEipUtils.getALEipUser((int)Integer.parseInt(this.userid)));
            return users;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<Integer, ALEipPost> getPostMap() {
        if (this.hasAclviewOther) {
            return ALEipManager.getInstance().getPostMap();
        }
        return null;
    }

    public List<ALEipGroup> getMyGroupList() {
        if (this.hasAclviewOther) {
            return this.myGroupList;
        }
        return new ArrayList<ALEipGroup>(0);
    }

    public String getUserId() {
        return this.userid;
    }

    public ScheduleTermMonthContainer getTermContainer() {
        return this.termMonthCon;
    }

    public ScheduleToDoMonthContainer getToDoContainer() {
        return this.monthTodoCon;
    }

    public void setPortletId(String id) {
        this.portletId = id;
    }

    public List<FacilityResultData> getFacilityList() {
        return this.facilityList;
    }

    public String getAclPortletFeature() {
        return "schedule_self";
    }

    public boolean hasAuthoritySelfInsert() {
        return this.hasAuthoritySelfInsert;
    }

    public boolean hasAuthorityFacilityInsert() {
        return this.hasAuthorityFacilityInsert;
    }

    public List<ALEipGroup> getFacilitiyGroupList() {
        return this.facilitiyGroups;
    }

    public String getTargetName() {
        if (this.target_user_id.length() < 1) {
            return "";
        }
        try {
            if (this.target_user_id.substring(0, 1).equals("f")) {
                for (FacilityResultData record : this.facilityList) {
                    int id = Integer.valueOf(this.target_user_id.substring(this.target_user_id.lastIndexOf("f") + 1));
                    if (record.getFacilityId().getValue() != (long)id) continue;
                    return record.getFacilityName().toString();
                }
                return "";
            }
            return ALEipUtils.getALEipUser((int)Integer.parseInt(this.target_user_id)).getAliasName().toString();
        }
        catch (NumberFormatException e) {
            logger.error((Object)"[ScheduleMonthlySelectData]", (Throwable)e);
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"[ScheduleMonthlySelectData]", (Throwable)e);
        }
        return "";
    }

    public String getTargetUserName() {
        return this.target_user_name;
    }

    public ALEipUser getUser() {
        return this.user;
    }

    public void setUser(ALEipUser user) {
        this.user = user;
    }
}

