/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.AjaxScheduleMonthlySelectData;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.portal.ALPortalApplicationService;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleOnedaySelectData
extends AjaxScheduleMonthlySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleOnedaySelectData.class.getName());
    private ALDateTimeField viewDate;
    private ALDateTimeField prevDate;
    private ALDateTimeField nextDate;
    private ALDateTimeField prevWeek;
    private ALDateTimeField nextWeek;
    private ALDateTimeField prevMonth;
    private ALDateTimeField nextMonth;
    private ALDateTimeField today;
    private ScheduleResultData[] resultData;
    private ArrayList<ScheduleResultData> termList;
    protected int startHour;
    protected int endHour;
    private int count;
    protected String viewtype;
    protected boolean is_duplicate;
    private List<ScheduleResultData> dlist;
    int tmpIndex;
    protected String tmpViewDate2;
    private Map<Integer, Integer> rowspanMap;
    private int rowIndex;
    protected int viewToDo;
    private List<ScheduleToDoResultData> todoList;
    private String portletId;
    private boolean hasAuthoritySelfInsert = false;
    private boolean hasAuthorityNote = false;
    private String userName;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.userName = ALEipUtils.getALEipUser((RunData)rundata).getAliasName().toString();
        this.viewDate = new ALDateTimeField("yyyy-MM-dd");
        this.viewDate.setNotNull(true);
        this.nextDate = new ALDateTimeField("yyyy-MM-dd");
        this.prevDate = new ALDateTimeField("yyyy-MM-dd");
        this.nextWeek = new ALDateTimeField("yyyy-MM-dd");
        this.prevWeek = new ALDateTimeField("yyyy-MM-dd");
        this.nextMonth = new ALDateTimeField("yyyy-MM-dd");
        this.prevMonth = new ALDateTimeField("yyyy-MM-dd");
        this.today = new ALDateTimeField("yyyy-MM-dd");
        Calendar to = Calendar.getInstance();
        to.set(11, 0);
        to.set(12, 0);
        this.today.setValue(to.getTime());
        String startHourInit = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1a-rows") != null ? ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1a-rows").toString() : String.valueOf(0);
        this.startHour = Integer.parseInt(startHourInit);
        this.startHour = this.startHour > 24 ? 0 : this.startHour;
        String endHourInit = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1b-rows") != null ? ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1b-rows").toString() : String.valueOf(13);
        this.endHour = Integer.parseInt(endHourInit);
        int n = this.endHour = this.endHour > 24 ? 13 : this.endHour;
        if (this.startHour > this.endHour) {
            this.startHour = 0;
            this.endHour = 13;
        }
        String todoInit = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p5a-view");
        this.viewToDo = !ALPortalApplicationService.isActive((String)"ToDo") || todoInit == null ? 0 : Integer.parseInt(todoInit);
        this.tmpIndex = 0;
        this.count = 0;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_start")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_start", (String)rundata.getParameters().getString("view_start"));
        }
        String tmpViewDate = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_start");
        if (this.tmpViewDate2 != null) {
            tmpViewDate = this.tmpViewDate2;
        }
        if (tmpViewDate == null || tmpViewDate.equals("")) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            this.viewDate.setValue(cal.getTime());
        } else {
            this.viewDate.setValue(tmpViewDate);
            if (!this.viewDate.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_start");
                throw new ALPageNotFoundException();
            }
        }
        this.setMonthlyCalendarViewMonth(this.viewDate.getYear(), this.viewDate.getMonth());
        Calendar viewDateCal = Calendar.getInstance();
        viewDateCal.setTime(this.viewDate.getValue());
        viewDateCal.add(5, 7);
        this.nextWeek.setValue(viewDateCal.getTime());
        viewDateCal.setTime(this.viewDate.getValue());
        viewDateCal.add(5, -7);
        this.prevWeek.setValue(viewDateCal.getTime());
        viewDateCal.setTime(this.viewDate.getValue());
        viewDateCal.add(2, 1);
        this.nextMonth.setValue(viewDateCal.getTime());
        viewDateCal.setTime(this.viewDate.getValue());
        viewDateCal.add(2, -1);
        this.prevMonth.setValue(viewDateCal.getTime());
        this.resultData = new ScheduleResultData[(this.endHour - this.startHour) * 12 * 2];
        this.dlist = new ArrayList<ScheduleResultData>();
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(this.viewDate.getValue());
        cal2.add(5, 1);
        this.nextDate.setValue(cal2.getTime());
        cal2.add(5, -2);
        this.prevDate.setValue(cal2.getTime());
        this.rowspanMap = new HashMap<Integer, Integer>();
        for (int i = this.startHour; i <= this.endHour; ++i) {
            this.rowspanMap.put(i, 12);
        }
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.viewDate.toString() + "-00-00"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.viewDate.toString() + "-00-00"));
        this.termList = new ArrayList();
        super.init(action, rundata, context);
        this.viewtype = "oneday";
        int userId = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthoritySelfInsert = aclhandler.hasAuthority(userId, "schedule_self", 4);
        this.hasAuthorityNote = ALPortalApplicationService.isActive((String)"Note");
    }

    @Override
    protected ResultList<VEipTScheduleList> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            VEipTScheduleList record;
            int i;
            List resultBaseList = this.getSelectQuery(rundata, context).fetchList();
            List<VEipTScheduleList> resultList = ScheduleUtils.sortByDummySchedule(resultBaseList);
            ArrayList<VEipTScheduleList> list = new ArrayList<VEipTScheduleList>();
            ArrayList<VEipTScheduleList> delList = new ArrayList<VEipTScheduleList>();
            int delSize = 0;
            int resultSize = resultList.size();
            int size = 0;
            boolean canAdd = true;
            for (i = 0; i < resultSize; ++i) {
                record = resultList.get(i);
                delList.clear();
                canAdd = true;
                size = list.size();
                for (int j = 0; j < size; ++j) {
                    VEipTScheduleList record2 = (VEipTScheduleList)list.get(j);
                    if (!record.getRepeatPattern().equals("N") && "D".equals(record2.getStatus()) && record.getScheduleId().intValue() == record2.getParentId().intValue()) {
                        canAdd = false;
                        break;
                    }
                    if (record2.getRepeatPattern().equals("N") || !"D".equals(record.getStatus()) || record2.getScheduleId().intValue() != record.getParentId().intValue()) continue;
                    if (!delList.contains(record2)) {
                        delList.add(record2);
                    }
                    canAdd = true;
                }
                delSize = delList.size();
                for (int k = 0; k < delSize; ++k) {
                    list.remove(delList.get(k));
                }
                if (!canAdd) continue;
                list.add(record);
            }
            delList.clear();
            size = list.size();
            for (i = 0; i < size; ++i) {
                record = (VEipTScheduleList)list.get(i);
                if (!"D".equals(record.getStatus())) continue;
                delList.add(record);
            }
            delSize = delList.size();
            for (i = 0; i < delSize; ++i) {
                list.remove(delList.get(i));
            }
            Collections.sort(list, new Comparator<VEipTScheduleList>(){

                @Override
                public int compare(VEipTScheduleList a, VEipTScheduleList b) {
                    Calendar cal = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    cal.setTime(a.getStartDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(b.getStartDate());
                    cal2.set(0, 0, 0);
                    if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                        return cal.getTime().compareTo(cal2.getTime());
                    }
                    cal.setTime(a.getEndDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(b.getEndDate());
                    cal2.set(0, 0, 0);
                    return cal.getTime().compareTo(cal2.getTime());
                }
            });
            if (this.viewToDo == 1) {
                this.loadToDo(rundata, context);
            }
            return new ResultList(list);
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleOnedaySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    @Deprecated
    protected SelectQuery<VEipTScheduleList> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(VEipTScheduleList.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        query.andQualifier(exp2);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.viewDate.getValue());
        cal.add(5, 1);
        ALDateTimeField field = new ALDateTimeField();
        field.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessExp((String)"startDate", (Object)field.getValue());
        Expression exp13 = ExpressionFactory.noMatchExp((String)"repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.noMatchExp((String)"repeatPattern", (Object)"S");
        query.andQualifier(exp11.andExp(exp12).orExp(exp13.andExp(exp14)));
        ArrayList<Ordering> orders = new ArrayList<Ordering>();
        orders.add(new Ordering("startDate", true));
        orders.add(new Ordering("endDate", true));
        query.getQuery().addOrderings(orders);
        return query;
    }

    @Override
    protected VEipTScheduleList selectDetail(RunData rundata, Context context) {
        return null;
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleResultData rd = new ScheduleResultData();
        ScheduleResultData rd2 = new ScheduleResultData();
        rd.initField();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        try {
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            if (!ScheduleUtils.isView(this.viewDate, record.getRepeatPattern(), record.getStartDate(), record.getEndDate())) {
                return rd;
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setName(record.getName());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setPattern(record.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                this.termList.add(rd);
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.viewDate, rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
            boolean dup = false;
            int sta = this.startHour * 12;
            int eta = this.endHour * 12;
            int st = Integer.parseInt(rd.getStartDate().getHour()) * 12 + Integer.parseInt(rd.getStartDate().getMinute()) / 5;
            int ed = Integer.parseInt(rd.getEndDate().getHour()) * 12 + Integer.parseInt(rd.getEndDate().getMinute()) / 5;
            if (!rd.getStartDate().getDay().equals(rd.getEndDate().getDay()) && rd.getEndDate().getHour().equals("0")) {
                ed = 288;
            }
            if (ed - sta > 0 && eta - st > 0 || ed - sta == 0 && st == ed) {
                if (sta > st) {
                    st = sta;
                }
                if (eta < ed) {
                    ed = eta;
                }
                sta -= this.rowIndex;
                int tmpRowIndex = this.rowIndex;
                if (ed - st == 0) {
                    rd.setRowspan(1);
                    Integer rowspan = this.rowspanMap.get(Integer.valueOf(rd.getStartDate().getHour()));
                    if (rowspan > 12) {
                        this.resultData[this.tmpIndex].setDuplicate(true);
                        rd.setDuplicate(true);
                    }
                    this.rowspanMap.put(Integer.valueOf(rd.getStartDate().getHour()), rowspan + 1);
                    ++this.rowIndex;
                    ++ed;
                } else {
                    rd.setRowspan(ed - st);
                }
                if (st - sta - this.count > 0) {
                    rd2.setRowspan(st - sta - this.count);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.viewDate.getValue());
                    cal.add(10, this.startHour);
                    int hour = (this.count - tmpRowIndex) / 12;
                    int min = (this.count - tmpRowIndex) % 12 * 5;
                    cal.add(10, hour);
                    cal.add(12, min);
                    rd2.setStartDate(cal.getTime());
                    hour = (st - sta - this.count) / 12;
                    min = (st - sta - this.count) % 12 * 5;
                    cal.add(10, hour);
                    cal.add(12, min);
                    rd2.setEndDate(cal.getTime());
                    this.resultData[this.count] = rd2;
                } else if (st - sta - this.count != 0) {
                    this.dlist.add(rd);
                    rd.setDuplicate(true);
                    dup = true;
                    this.is_duplicate = true;
                    this.resultData[this.tmpIndex].setDuplicate(true);
                }
                if (!dup) {
                    this.resultData[st - sta] = rd;
                    this.tmpIndex = st - sta;
                    this.count = ed - sta;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    @Override
    protected Object getResultDataDetail(VEipTScheduleList record) {
        return null;
    }

    @Override
    protected Attributes getColumnMap() {
        return null;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doViewList(action, rundata, context);
        if (res) {
            this.postDoList();
        }
        return res;
    }

    public boolean doSelectList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doSelectList(action, rundata, context);
        if (res) {
            this.postDoList();
        }
        return res;
    }

    private void postDoList() {
        int index = (this.endHour - this.startHour) * 12 + this.rowIndex;
        if (index > this.count) {
            ScheduleResultData rd = new ScheduleResultData();
            rd.setFormat("yyyy-MM-dd-HH-mm");
            rd.initField();
            rd.setRowspan(index - this.count);
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.viewDate.getValue());
            cal.add(10, this.startHour);
            int hour = (this.count - this.rowIndex) / 12;
            int min = (this.count - this.rowIndex) % 12 * 5;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setStartDate(cal.getTime());
            hour = (index - this.count) / 12;
            min = (index - this.count) % 12 * 5;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setEndDate(cal.getTime());
            this.resultData[this.count] = rd;
        }
    }

    public void loadToDo(RunData rundata, Context context) {
        this.todoList = new ArrayList<ScheduleToDoResultData>();
        try {
            SelectQuery<EipTTodo> query = this.getSelectQueryForTodo(rundata, context);
            List todos = query.fetchList();
            int todosize = todos.size();
            for (int i = 0; i < todosize; ++i) {
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = this.getPortletURItoTodo(rundata, record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                this.todoList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return;
        }
    }

    protected String getPortletURItoTodo(RunData rundata, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", entityid, schedulePortletId);
    }

    private SelectQuery<EipTTodo> getSelectQueryForTodo(RunData rundata, Context context) {
        Integer uid = ALEipUtils.getUserId((RunData)rundata);
        SelectQuery query = Database.query(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)uid);
        query.andQualifier(exp3);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewDate.getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewDate.getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    @Override
    public ALDateTimeField getViewDate() {
        return this.viewDate;
    }

    public String getViewDateText() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_DATE_FORMAT", (Object[])new Object[]{this.viewDate.getYear(), this.viewDate.getMonth(), this.viewDate.getDay()});
    }

    public String getViewDateNospaceText() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_DATE_FORMAT_NOSPACE", (Object[])new Object[]{this.viewDate.getYear(), this.viewDate.getMonth(), this.viewDate.getDay()});
    }

    public ALDateTimeField getNextDate() {
        return this.nextDate;
    }

    public ALDateTimeField getPrevDate() {
        return this.prevDate;
    }

    public ALDateTimeField getPrevWeek() {
        return this.prevWeek;
    }

    public ALDateTimeField getNextWeek() {
        return this.nextWeek;
    }

    public ALDateTimeField getToday() {
        return this.today;
    }

    public ALDateTimeField getPrevMonth() {
        return this.prevMonth;
    }

    public ALDateTimeField getNextMonth() {
        return this.nextMonth;
    }

    public ScheduleResultData getResult(int index) {
        return this.resultData[index];
    }

    public int getStartHour() {
        return this.startHour;
    }

    public int getEndHour() {
        return this.endHour;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getViewtype() {
        return this.viewtype;
    }

    public boolean isDuplicate() {
        return this.is_duplicate;
    }

    public List<ScheduleResultData> getDuplicateScheduleList() {
        return this.dlist;
    }

    public void setTmpViewDate(String date) {
        this.tmpViewDate2 = date;
    }

    public int getRowspan(int hour) {
        return this.rowspanMap.get(hour);
    }

    public List<ScheduleResultData> getTermResultDataList() {
        return this.termList;
    }

    public List<ScheduleToDoResultData> getToDoResultDataList() {
        return this.todoList;
    }

    public void setPortletId(String id) {
        this.portletId = id;
    }

    public String getAclPortletFeature() {
        return "schedule_self";
    }

    public boolean hasAuthoritySelfInsert() {
        return this.hasAuthoritySelfInsert;
    }

    public boolean hasAuthorityNote() {
        return this.hasAuthorityNote;
    }
}

