/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.eip.common.ALData;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleTermDayContainer;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ScheduleTermWeekContainer
implements ALData {
    private List<ScheduleTermDayContainer> dayList;

    public void initField() {
        this.dayList = new ArrayList<ScheduleTermDayContainer>();
    }

    public void setViewStartDate(Calendar cal) {
        for (int i = 1; i <= 7; ++i) {
            ScheduleTermDayContainer con = new ScheduleTermDayContainer();
            con.initField();
            con.setDate(cal.getTime());
            this.dayList.add(con);
            cal.add(5, 1);
        }
    }

    public void addTermResultData(int index, ScheduleResultData rd) {
        int span = rd.getRowspan();
        ScheduleTermDayContainer con = this.dayList.get(index);
        con.setHasTerm(true);
        con.setTermResultData(rd);
        for (int i = 1; i < span; ++i) {
            con = this.dayList.get(index + i);
            con.setHasTerm(true);
        }
    }

    public boolean canAddTerm(ScheduleResultData rd) {
        boolean canAdd = true;
        Date startDate = rd.getStartDate().getValue();
        Date endDate = rd.getEndDate().getValue();
        int size = this.dayList.size();
        for (int i = 0; i < size; ++i) {
            ScheduleTermDayContainer con = this.dayList.get(i);
            Date conDate = con.getDate().getValue();
            if (!ScheduleUtils.equalsToDate(startDate, conDate, false) && !conDate.after(startDate) || !ScheduleUtils.equalsToDate(endDate, conDate, false) && !conDate.before(endDate) || !con.isHasTerm()) continue;
            canAdd = false;
        }
        return canAdd;
    }

    public List<ScheduleTermDayContainer> getDayList() {
        return this.dayList;
    }
}

