/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.accessctl;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.accessctl.bean.AccessControlFeatureBean;
import com.aimluck.eip.accessctl.util.AccessControlUtils;
import com.aimluck.eip.cayenne.om.account.EipTAclPortletFeature;
import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccessControlFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccessControlFormData.class.getName());
    private String acl_role_id;
    private ALStringField acl_role_name;
    private ALNumberField feature_id;
    private ALStringField note;
    private ALNumberField acllist;
    private ALNumberField acldetail;
    private ALNumberField aclinsert;
    private ALNumberField aclupdate;
    private ALNumberField acldelete;
    private ALNumberField aclexport;
    private List<ALEipUser> memberList;
    private int defineAclType;
    private List<AccessControlFeatureBean> portletFeatureList;

    public void loadPortletFeatureList(RunData rundata, Context context) {
        this.portletFeatureList = AccessControlUtils.getPortletFeatureList();
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.acl_role_name = new ALStringField();
        this.acl_role_name.setFieldName(ALLocalizationUtils.getl10n((String)"ACCESSCTL_ROLE_NAME"));
        this.acl_role_name.setTrim(true);
        this.feature_id = new ALNumberField();
        this.feature_id.setFieldName(ALLocalizationUtils.getl10n((String)"ACCESSCTL_ROLE_NAME"));
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"ACCESSCTL_MEMO"));
        this.note.setTrim(false);
        this.acllist = new ALNumberField();
        this.acldetail = new ALNumberField();
        this.aclinsert = new ALNumberField();
        this.aclupdate = new ALNumberField();
        this.acldelete = new ALNumberField();
        this.aclexport = new ALNumberField();
        this.memberList = new ArrayList<ALEipUser>();
    }

    protected void setValidator() {
        this.acl_role_name.setNotNull(true);
        this.acl_role_name.limitMaxLength(50);
        this.feature_id.setNotNull(true);
        this.note.limitMaxLength(1000);
        this.acllist.limitValue(0L, 1L);
        this.acldetail.limitValue(0L, 1L);
        this.aclinsert.limitValue(0L, 1L);
        this.aclupdate.limitValue(0L, 1L);
        this.acldelete.limitValue(0L, 1L);
        this.aclexport.limitValue(0L, 1L);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if (res) {
                Object[] str;
                if ("update".equals(this.getMode())) {
                    this.acl_role_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
                }
                if ((str = rundata.getParameters().getStrings("member_to")) != null && str.length > 0) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])str);
                    query.setQualifier(exp);
                    this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AccessControlFormData.setFormData", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        String tmp_acl_role_name = this.acl_role_name.getValue();
        if (tmp_acl_role_name != null && !"".equals(tmp_acl_role_name)) {
            try {
                SelectQuery query = Database.query(EipTAclRole.class);
                if ("insert".equals(this.getMode())) {
                    Expression exp = ExpressionFactory.matchExp((String)"roleName", (Object)tmp_acl_role_name);
                    query.setQualifier(exp);
                } else if ("update".equals(this.getMode())) {
                    Expression exp1 = ExpressionFactory.matchExp((String)"roleName", (Object)tmp_acl_role_name);
                    query.setQualifier(exp1);
                    Expression exp2 = ExpressionFactory.noMatchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(this.acl_role_id));
                    query.andQualifier(exp2);
                }
                if (query.fetchList().size() != 0) {
                    msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCESSCTL_ALERT_ALREADY_CREATED", (Object[])new Object[]{this.acl_role_name.toString()}));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"AccessControlFormData.validate", (Throwable)ex);
                return false;
            }
        }
        this.acl_role_name.validate(msgList);
        this.note.validate(msgList);
        this.acllist.validate(msgList);
        this.acldetail.validate(msgList);
        this.aclinsert.validate(msgList);
        this.aclupdate.validate(msgList);
        this.acldelete.validate(msgList);
        this.aclexport.validate(msgList);
        if (this.acllist.getValue() == 0L && this.acldetail.getValue() == 0L && this.aclinsert.getValue() == 0L && this.aclupdate.getValue() == 0L && this.acldelete.getValue() == 0L && this.aclexport.getValue() == 0L) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCESSCTL_ALERT_NO_FEATURE_SELECTED"));
        }
        if (this.memberList.size() == 0) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCESSCTL_ALERT_NO_MEMBER_SELECTED"));
        } else {
            try {
                List roleList;
                ArrayList<Integer> uids = new ArrayList<Integer>();
                int msize = this.memberList.size();
                for (int i = 0; i < msize; ++i) {
                    ALEipUser user = this.memberList.get(i);
                    uids.add((int)user.getUserId().getValue());
                }
                SelectQuery rolequery = Database.query(EipTAclRole.class);
                Expression exp11 = ExpressionFactory.matchDbExp((String)"eipTAclPortletFeature.FEATURE_ID", (Object)((int)this.feature_id.getValue()));
                Expression exp12 = ExpressionFactory.inDbExp((String)"eipTAclUserRoleMaps.turbineUser.USER_ID", uids);
                rolequery.setQualifier(exp11.andExp(exp12));
                if ("update".equals(this.getMode())) {
                    Expression exp13 = ExpressionFactory.noMatchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(this.acl_role_id));
                    rolequery.andQualifier(exp13);
                }
                if ((roleList = rolequery.fetchList()) != null && roleList.size() != 0) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"ACCESSCTL_ALERT_OTHER_ROLE"));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"AccessControlFormData.validate", (Throwable)ex);
                return false;
            }
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTAclRole aclrole = AccessControlUtils.getEipTAclRole(rundata, context);
            if (aclrole == null) {
                return false;
            }
            this.acl_role_name.setValue(aclrole.getRoleName());
            List<EipTAclUserRoleMap> aclUserRoleMaps = AccessControlUtils.getEipTAclUserRoleMaps(aclrole.getRoleId());
            if (aclUserRoleMaps != null && aclUserRoleMaps.size() > 0) {
                EipTAclUserRoleMap rolemap = null;
                TurbineUser tuser = null;
                int size = aclUserRoleMaps.size();
                for (int i = 0; i < size; ++i) {
                    rolemap = aclUserRoleMaps.get(i);
                    tuser = rolemap.getTurbineUser();
                    ALEipUser user = new ALEipUser();
                    user.initField();
                    user.setUserId(tuser.getUserId().intValue());
                    user.setName(tuser.getLoginName());
                    user.setAliasName(tuser.getFirstName(), tuser.getLastName());
                    if ("PENDING".equals(tuser.getConfirmValue())) continue;
                    this.memberList.add(user);
                }
            }
            EipTAclPortletFeature feature = aclrole.getEipTAclPortletFeature();
            this.feature_id.setValue((long)feature.getFeatureId().intValue());
            this.defineAclType = feature.getAclType();
            this.note.setValue(aclrole.getNote());
            int tmpAclType = aclrole.getAclType();
            AccessControlUtils.setupAcl(1, tmpAclType, this.acllist);
            AccessControlUtils.setupAcl(2, tmpAclType, this.acldetail);
            AccessControlUtils.setupAcl(4, tmpAclType, this.aclinsert);
            AccessControlUtils.setupAcl(8, tmpAclType, this.aclupdate);
            AccessControlUtils.setupAcl(16, tmpAclType, this.acldelete);
            AccessControlUtils.setupAcl(32, tmpAclType, this.aclexport);
        }
        catch (Exception ex) {
            logger.error((Object)"AccessControlFormData.loadFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String aclroleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (aclroleid == null || Integer.valueOf(aclroleid) == null) {
                logger.debug((Object)"[AccessControlUtils] Empty ID...");
                return false;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)aclroleid);
            SelectQuery query = Database.query(EipTAclRole.class, (Expression)exp);
            List aclroles = query.fetchList();
            if (aclroles == null || aclroles.size() == 0) {
                logger.debug((Object)"[AccessControlUtils] Not found ID...");
                return false;
            }
            SelectQuery EipTAclUserRoleMapSQL = Database.query(EipTAclUserRoleMap.class);
            EipTAclUserRoleMapSQL.andQualifier(ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)aclroleid));
            List userRoleMaps = EipTAclUserRoleMapSQL.fetchList();
            Database.deleteAll((List)userRoleMaps);
            Database.delete((Persistent)((Persistent)aclroles.get(0)));
            Database.commit();
            for (EipTAclRole role : aclroles) {
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(role.getRoleId().intValue(), 350, ALLocalizationUtils.getl10nFormat((String)"ACCESSCTL_EVENTLOG_DELETE", (Object[])new Object[]{role.getRoleName()}));
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccessControlFormData.deleteFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            Date now = Calendar.getInstance().getTime();
            EipTAclRole aclrole = (EipTAclRole)Database.create(EipTAclRole.class);
            aclrole.setRoleName(this.acl_role_name.getValue());
            aclrole.setNote(this.note.getValue());
            long aclType = this.getAclTypeValue();
            aclrole.setAclType(Integer.valueOf((int)aclType));
            EipTAclPortletFeature feature = (EipTAclPortletFeature)Database.get(EipTAclPortletFeature.class, (Object)((int)this.feature_id.getValue()));
            aclrole.setEipTAclPortletFeature(feature);
            aclrole.setCreateDate(now);
            aclrole.setUpdateDate(now);
            this.insertEipTAclUserRoleMap(aclrole, this.memberList.get(0));
            int size = this.memberList.size();
            for (int i = 1; i < size; ++i) {
                this.insertEipTAclUserRoleMap(aclrole, this.memberList.get(i));
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(aclrole.getRoleId().intValue(), 350, ALLocalizationUtils.getl10nFormat((String)"ACCESSCTL_EVENTLOG_ADD", (Object[])new Object[]{aclrole.getRoleName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccessControlFormData.insertFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTAclRole aclrole = AccessControlUtils.getEipTAclRole(rundata, context);
            if (aclrole == null) {
                return false;
            }
            aclrole.setRoleName(this.acl_role_name.getValue());
            aclrole.setNote(this.note.getValue());
            aclrole.setUpdateDate(Calendar.getInstance().getTime());
            long aclType = this.getAclTypeValue();
            aclrole.setAclType(Integer.valueOf((int)aclType));
            EipTAclPortletFeature feature = (EipTAclPortletFeature)Database.get(EipTAclPortletFeature.class, (Object)((int)this.feature_id.getValue()));
            aclrole.setEipTAclPortletFeature(feature);
            int size = this.memberList.size();
            for (int i = 0; i < size; ++i) {
                this.insertEipTAclUserRoleMap(aclrole, this.memberList.get(i));
            }
            this.deleteEipTAclUserRoleMap(rundata, context);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(aclrole.getRoleId().intValue(), 350, ALLocalizationUtils.getl10nFormat((String)"ACCESSCTL_EVENTLOG_UPDATE", (Object[])new Object[]{aclrole.getRoleName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccessControlFormData.updateFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void insertEipTAclUserRoleMap(EipTAclRole aclrole, ALEipUser user) {
        EipTAclUserRoleMap map = (EipTAclUserRoleMap)Database.create(EipTAclUserRoleMap.class);
        int userid = (int)user.getUserId().getValue();
        TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)userid);
        map.setEipTAclRole(aclrole);
        map.setTurbineUser(tuser);
    }

    private boolean deleteEipTAclUserRoleMap(RunData rundata, Context context) {
        String aclroleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (aclroleid == null || Integer.valueOf(aclroleid) == null) {
            logger.debug((Object)"[AccessControlFormData] Empty ID...");
            return false;
        }
        SelectQuery query = Database.query(EipTAclUserRoleMap.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"eipTAclRole.ROLE_ID", (Object)aclroleid);
        query.setQualifier(exp);
        List maps = query.fetchList();
        if (maps == null || maps.size() == 0) {
            return true;
        }
        Database.deleteAll((List)maps);
        return true;
    }

    private long getAclTypeValue() {
        long aclType = this.acllist.getValue() * 1L + this.acldetail.getValue() * 2L + this.aclinsert.getValue() * 4L + this.aclupdate.getValue() * 8L + this.acldelete.getValue() * 16L + this.aclexport.getValue() * 32L;
        return aclType;
    }

    private boolean hasAcl(int defineAclType, int aclType) {
        return (defineAclType & aclType) == aclType;
    }

    public ALStringField getAclRoleName() {
        return this.acl_role_name;
    }

    public ALNumberField getFeatureId() {
        return this.feature_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALNumberField getAclList() {
        return this.acllist;
    }

    public ALNumberField getAclDetail() {
        return this.acldetail;
    }

    public ALNumberField getAclInsert() {
        return this.aclinsert;
    }

    public ALNumberField getAclUpdate() {
        return this.aclupdate;
    }

    public ALNumberField getAclDelete() {
        return this.acldelete;
    }

    public ALNumberField getAclExport() {
        return this.aclexport;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public List<AccessControlFeatureBean> getPortletFeatureList() {
        return this.portletFeatureList;
    }

    public int getDefineAclType() {
        return this.defineAclType;
    }

    public boolean hasAclList() {
        return this.hasAcl(this.defineAclType, 1);
    }

    public boolean hasAclDetail() {
        return this.hasAcl(this.defineAclType, 2);
    }

    public boolean hasAclInsert() {
        return this.hasAcl(this.defineAclType, 4);
    }

    public boolean hasAclUpdate() {
        return this.hasAcl(this.defineAclType, 8);
    }

    public boolean hasAclDelete() {
        return this.hasAcl(this.defineAclType, 16);
    }

    public boolean hasAclExport() {
        return this.hasAcl(this.defineAclType, 32);
    }
}

