/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.userfacility.util;

import com.aimluck.eip.cayenne.om.account.VEipMUserGroupList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.userfacility.beans.UserAllLiteBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class UserAllUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)UserAllUtils.class.getName());

    public static List<UserAllLiteBean> getUserAllLiteBeans(RunData rundata, int filterId, UserAllLiteBean.Type filterType, boolean groupOnly) {
        ResultList<VEipMUserGroupList> list = UserAllUtils.getUserAllList(rundata, filterId, filterType, -1, -1, groupOnly);
        ArrayList<UserAllLiteBean> results = new ArrayList<UserAllLiteBean>();
        for (VEipMUserGroupList model : list) {
            UserAllLiteBean bean = new UserAllLiteBean();
            bean.initField();
            bean.setId(model.getId());
            bean.setType(UserAllLiteBean.Type.valueOf(model.getType()));
            bean.setName(model.getName());
            results.add(bean);
        }
        return results;
    }

    public static ResultList<VEipMUserGroupList> getUserAllList(RunData rundata, int filterId, UserAllLiteBean.Type filterType) {
        return UserAllUtils.getUserAllList(rundata, filterId, filterType, -1, -1, false);
    }

    public static ResultList<VEipMUserGroupList> getUserAllList(RunData rundata, int filterId, UserAllLiteBean.Type filterType, int page, int limit, boolean groupOnly) {
        StringBuilder select = new StringBuilder();
        boolean isFirst = true;
        if (!UserAllLiteBean.Type.fg.equals((Object)filterType) || filterId <= 0) {
            select.append(" SELECT 10 * t0.group_id + 1 AS uid, t0.group_id AS id, t0.group_alias_name AS name, 'ug' AS type, t0.group_id AS sort, 1 as pos FROM turbine_group t0");
            select.append("  WHERE t0.owner_id = 1 ");
            isFirst = false;
        }
        if (UserAllLiteBean.Type.ug.equals((Object)filterType) && filterId > 0) {
            select.append("  AND t0.group_id = #bind($filterId) ");
        } else if (!groupOnly) {
            if (!isFirst) {
                select.append(" UNION ALL");
            }
            select.append(" SELECT 10 * t0.group_id + 2 AS uid, t0.group_id AS id, t0.group_name AS name, 'fg' AS type, t0.group_id AS sort, 2 as pos FROM eip_m_facility_group t0");
            if (UserAllLiteBean.Type.fg.equals((Object)filterType) && filterId > 0) {
                select.append("  WHERE t0.group_id = #bind($filterId) ");
            }
        }
        if (!UserAllLiteBean.Type.fg.equals((Object)filterType) || filterId <= 0) {
            select.append(" UNION ALL");
            if (Database.isJdbcPostgreSQL()) {
                select.append(" SELECT DISTINCT 10 * t1.user_id + 3 AS uid, t1.user_id AS id, t1.last_name || ' ' || t1.first_name AS name, 'u' AS type, t3.position AS sort, 3 as pos");
                select.append(" FROM turbine_user_group_role AS t0");
            } else {
                select.append(" SELECT DISTINCT 10 * t1.user_id + 3 AS uid, t1.user_id AS id, CONCAT(t1.last_name,' ',t1.first_name) AS name, 'u' AS type, t3.position AS sort, 3 as pos");
                select.append(" FROM turbine_user_group_role AS t0");
            }
            select.append(" LEFT JOIN turbine_user AS t1 ON t0.user_id = t1.user_id");
            select.append(" LEFT JOIN turbine_group AS t2 ON t0.group_id = t2.group_id");
            select.append(" LEFT JOIN eip_m_user_position AS t3 ON t1.user_id = t3.user_id WHERE ((t1.user_id > 3) AND (t1.company_id = 1) AND (t1.disabled <> 'T'))");
        }
        if (UserAllLiteBean.Type.ug.equals((Object)filterType) && filterId > 0) {
            select.append("  AND t0.group_id = #bind($filterId) ");
        } else if (!groupOnly) {
            select.append(" UNION ALL");
            select.append(" SELECT 10 * t0.facility_id + 4 AS uid, t0.facility_id AS id, t0.facility_name AS name, 'f' AS type, t0.sort AS sort, 4 as pos");
            select.append(" FROM eip_m_facility AS t0");
            select.append(" LEFT JOIN eip_m_facility_group_map AS t1 ON t0.facility_id = t1.facility_id");
            select.append(" LEFT JOIN eip_m_facility_group AS t2 ON t1.group_id = t2.group_id");
            if (UserAllLiteBean.Type.fg.equals((Object)filterType) && filterId > 0) {
                select.append("  WHERE t1.group_id = #bind($filterId) ");
            }
        }
        StringBuilder last = new StringBuilder();
        last.append(" ORDER BY pos, sort");
        SQLTemplate countQuery = Database.sql(VEipMUserGroupList.class, (String)("SELECT COUNT(*) as c FROM (" + select.toString() + ") as uCount"));
        if (filterType != null && filterId > 0) {
            countQuery.param("filterId", (Object)filterId);
        }
        int countValue = 0;
        if (page > 0 && limit > 0) {
            List fetchCount = countQuery.fetchListAsDataRow();
            for (DataRow row : fetchCount) {
                countValue = ((Long)row.get((Object)"c")).intValue();
            }
            int offset = 0;
            if (limit > 0) {
                int num = (int)Math.ceil((double)countValue / (double)limit);
                if (num > 0 && num < page) {
                    page = num;
                }
                offset = limit * (page - 1);
            } else {
                page = 1;
            }
            last.append(" LIMIT ");
            last.append(limit);
            last.append(" OFFSET ");
            last.append(offset);
        }
        SQLTemplate query = Database.sql(VEipMUserGroupList.class, (String)(select.toString() + last.toString()));
        if (filterType != null && filterId > 0) {
            query.param("filterId", (Object)filterId);
        }
        List list = query.fetchList();
        if (page > 0 && limit > 0) {
            return new ResultList(list, page, limit, countValue);
        }
        return new ResultList(list, -1, -1, list.size());
    }
}

