/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public abstract class AbstractAddressBookFilterdSelectData<M1, M2>
extends ALAbstractSelectData<M1, M2> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AbstractAddressBookFilterdSelectData.class.getName());
    private static final String INDEX_STR_ALL = "-1";
    private String currentTab;
    private String index;
    protected ALStringField searchWord;
    private boolean hasAuthorityList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        if (!rundata.getParameters().containsKey((Object)"start") && !rundata.getParameters().containsKey((Object)"sort")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"AddressBooksword", (String)rundata.getParameters().getString("sword"));
        }
        this.searchWord = new ALStringField();
        this.searchWord.setTrim(true);
        this.searchWord.setValue(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"AddressBooksword"));
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"syagai");
            this.currentTab = "syagai";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        this.hasAuthorityList = this.checkHasAuthority(rundata, 1);
        String index_session = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR);
        String index_rundata = rundata.getParameters().getString("idx");
        if (index_rundata != null) {
            if (INDEX_STR_ALL.equals(index_rundata) || "".equals(index_rundata)) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR, (String)INDEX_STR_ALL);
                this.index = INDEX_STR_ALL;
            } else {
                this.index = index_rundata;
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR, (String)this.index);
            }
        } else if (index_session != null) {
            this.index = index_session;
        }
        super.init(action, rundata, context);
    }

    protected SelectQuery<M1> getSelectQueryForIndex(SelectQuery<M1> query, RunData rundata, Context context) {
        if (this.index != null && !INDEX_STR_ALL.equals(this.index)) {
            this.buildSelectQueryForAddressbookIndex(query, this.getColumnForIndex(), Integer.parseInt(this.index));
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public ALStringField getSearchWord() {
        return this.searchWord;
    }

    public boolean getHasAuthorityList() {
        return this.hasAuthorityList;
    }

    public String getIndex() {
        return this.index;
    }

    protected abstract String getColumnForIndex();

    public boolean checkHasAuthority(RunData rundata, int type) {
        String feature = "addressbook_address_inside";
        if ("syagai".equals(this.currentTab)) {
            feature = "addressbook_address_outside";
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        return aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), feature, type);
    }

    private void buildSelectQueryForAddressbookIndex(SelectQuery<M1> query, String lastNameKana, int idx) {
        switch (idx) {
            case 1: {
                Expression exp01 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30a2");
                Expression exp02 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ab");
                query.andQualifier(exp01.andExp(exp02));
                break;
            }
            case 6: {
                Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ab");
                Expression exp12 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30b5");
                query.andQualifier(exp11.andExp(exp12));
                break;
            }
            case 11: {
                Expression exp21 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30b5");
                Expression exp22 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30bf");
                query.andQualifier(exp21.andExp(exp22));
                break;
            }
            case 16: {
                Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30bf");
                Expression exp32 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ca");
                query.andQualifier(exp31.andExp(exp32));
                break;
            }
            case 21: {
                Expression exp41 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ca");
                Expression exp42 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30cf");
                query.andQualifier(exp41.andExp(exp42));
                break;
            }
            case 26: {
                Expression exp51 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30cf");
                Expression exp52 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30de");
                query.andQualifier(exp51.andExp(exp52));
                break;
            }
            case 31: {
                Expression exp61 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30de");
                Expression exp62 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30e4");
                query.andQualifier(exp61.andExp(exp62));
                break;
            }
            case 36: {
                Expression exp71 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30e4");
                Expression exp72 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30e9");
                query.andQualifier(exp71.andExp(exp72));
                break;
            }
            case 41: {
                Expression exp81 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30e9");
                Expression exp82 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ef");
                query.andQualifier(exp81.andExp(exp82));
                break;
            }
            case 46: {
                Expression exp91 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ef");
                Expression exp92 = ExpressionFactory.lessOrEqualExp((String)lastNameKana, (Object)"\u30f4");
                query.andQualifier(exp91.andExp(exp92));
                break;
            }
            case 52: {
                Expression exp100 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30a2");
                Expression exp101 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30f4");
                query.andQualifier(exp100.orExp(exp101));
                break;
            }
            default: {
                Expression exp111 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"");
                Expression exp112 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"");
                query.andQualifier(exp111.orExp(exp112));
            }
        }
    }

    protected SelectQuery<M1> buildSelectQueryForListViewSort(SelectQuery<M1> query, RunData rundata, Context context) {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (sort == null) {
            return query;
        }
        crt_key = map.getValue(sort);
        if (crt_key == null) {
            return query;
        }
        if (sort_type != null && "desc".equals(sort_type)) {
            query.orderDesending(crt_key);
            if (sort.equals("name_kana")) {
                query.orderDesending("firstNameKana");
            }
        } else {
            query.orderAscending(crt_key);
            if (sort.equals("name_kana")) {
                query.orderAscending("firstNameKana");
            }
            sort_type = "asc";
        }
        this.current_sort = sort;
        this.current_sort_type = sort_type;
        return query;
    }
}

