/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.AddressBookCompanyResultData;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCompanyWordSelectData
extends ALAbstractSelectData<EipMAddressbookCompany, EipMAddressbookCompany> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookCompanyWordSelectData.class.getName());
    private ALStringField searchWord;
    private List<AddressBookGroupResultData> groupList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"company_name_kana");
        }
        this.groupList = AddressBookUtils.getMyGroups(rundata);
        super.init(action, rundata, context);
    }

    protected ResultList<EipMAddressbookCompany> selectList(RunData rundata, Context context) {
        if (!rundata.getParameters().containsKey((Object)"start") && !rundata.getParameters().containsKey((Object)"sort")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"AddressBooksCompanyword", (String)rundata.getParameters().getString("sword"));
        }
        this.searchWord = new ALStringField();
        this.searchWord.setTrim(true);
        this.searchWord.setValue(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"AddressBooksCompanyword"));
        try {
            SelectQuery<EipMAddressbookCompany> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCompanyWordSelectData.selectList", (Throwable)ex);
            return null;
        }
    }

    protected EipMAddressbookCompany selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(EipMAddressbookCompany record) {
        try {
            AddressBookCompanyResultData rd = new AddressBookCompanyResultData();
            rd.initField();
            rd.setCompanyId(record.getCompanyId().intValue());
            rd.setCompanyName(ALCommonUtils.compressString((String)record.getCompanyName(), (int)this.getStrLength()));
            rd.setCompanyNameKana(record.getCompanyNameKana());
            rd.setPostName(ALCommonUtils.compressString((String)record.getPostName(), (int)this.getStrLength()));
            rd.setZipcode(record.getZipcode());
            rd.setAddress(ALCommonUtils.compressString((String)record.getAddress(), (int)this.getStrLength()));
            rd.setTelephone(record.getTelephone());
            rd.setFaxNumber(record.getFaxNumber());
            rd.setUrl(record.getUrl());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCompanyWordSelectData.selectDetail", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipMAddressbookCompany obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("company_name_kana", "companyNameKana");
        return map;
    }

    private SelectQuery<EipMAddressbookCompany> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipMAddressbookCompany.class);
        query.setQualifier(AddressBookUtils.excludeDefaultCompanyCriteria());
        String word = this.searchWord.getValue();
        String transWord = ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.searchWord.getValue()));
        Expression exp11 = ExpressionFactory.likeExp((String)"companyName", (Object)("%" + word + "%"));
        Expression exp12 = ExpressionFactory.likeExp((String)"companyNameKana", (Object)("%" + word + "%"));
        Expression exp13 = ExpressionFactory.likeExp((String)"postName", (Object)("%" + word + "%"));
        Expression exp14 = ExpressionFactory.likeExp((String)"zipcode", (Object)("%" + word + "%"));
        Expression exp15 = ExpressionFactory.likeExp((String)"address", (Object)("%" + word + "%"));
        Expression exp16 = ExpressionFactory.likeExp((String)"telephone", (Object)("%" + word + "%"));
        Expression exp17 = ExpressionFactory.likeExp((String)"faxNumber", (Object)("%" + word + "%"));
        Expression exp18 = ExpressionFactory.likeExp((String)"url", (Object)("%" + word + "%"));
        Expression exp21 = ExpressionFactory.likeExp((String)"companyName", (Object)("%" + transWord + "%"));
        Expression exp22 = ExpressionFactory.likeExp((String)"companyNameKana", (Object)("%" + transWord + "%"));
        Expression exp23 = ExpressionFactory.likeExp((String)"postName", (Object)("%" + transWord + "%"));
        Expression exp24 = ExpressionFactory.likeExp((String)"zipcode", (Object)("%" + transWord + "%"));
        Expression exp25 = ExpressionFactory.likeExp((String)"address", (Object)("%" + transWord + "%"));
        Expression exp26 = ExpressionFactory.likeExp((String)"telephone", (Object)("%" + transWord + "%"));
        Expression exp27 = ExpressionFactory.likeExp((String)"faxNumber", (Object)("%" + transWord + "%"));
        Expression exp28 = ExpressionFactory.likeExp((String)"url", (Object)("%" + transWord + "%"));
        query.andQualifier(exp11.orExp(exp12).orExp(exp13).orExp(exp14).orExp(exp15).orExp(exp16).orExp(exp17).orExp(exp18).orExp(exp21).orExp(exp22).orExp(exp23).orExp(exp24).orExp(exp25).orExp(exp26).orExp(exp27).orExp(exp28));
        return query;
    }

    public ALStringField getSearchWord() {
        return this.searchWord;
    }

    public String getAclPortletFeature() {
        return "addressbook_company";
    }

    public List<AddressBookGroupResultData> getGroupList() {
        return this.groupList;
    }

    public void setCurrentPage(int page) {
        this.current_page = page;
    }
}

