/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Switch
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Switch();

    @Override
    public String parseFunction(List<String> list, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) {
        if (list.size() > 2) {
            String defaultResult = null;
            String conditionString = isSubst ? list.get(0) : Switch.parseTrim(list.get(0), model);
            boolean checkNumerically = false;
            if (conditionString.length() > 0) {
                if (conditionString.charAt(0) == '+' || conditionString.charAt(0) == '-' || conditionString.charAt(0) == '0' || conditionString.charAt(0) == '.' || conditionString.charAt(0) == ',' || conditionString.charAt(0) == 'e' || conditionString.charAt(0) == 'E') {
                    checkNumerically = true;
                } else {
                    for (int i = 0; i < conditionString.length(); ++i) {
                        if (conditionString.charAt(i) != '+' && conditionString.charAt(i) != '-' && conditionString.charAt(i) != '.' && conditionString.charAt(i) != ',' && conditionString.charAt(i) != 'e' && conditionString.charAt(i) != 'E') continue;
                        checkNumerically = true;
                        break;
                    }
                }
            }
            boolean valueFound = false;
            for (int i = 1; i < list.size(); ++i) {
                String parsedLHS;
                String leftHandSide;
                String temp = isSubst ? list.get(i) : Switch.parseTrim(list.get(i), model);
                int index = temp.indexOf(61);
                if (index >= 0) {
                    if (valueFound) {
                        return temp.substring(index + 1).trim();
                    }
                    leftHandSide = temp.substring(0, index);
                } else {
                    leftHandSide = temp;
                }
                String string = parsedLHS = isSubst ? leftHandSide : Switch.parseTrim(leftHandSide, model);
                if (index >= 0 && "#default".equals(parsedLHS)) {
                    defaultResult = temp.substring(index + 1).trim();
                    continue;
                }
                if (index < 0 && i == list.size() - 1) {
                    return parsedLHS;
                }
                if (!this.equalsTypes(conditionString, parsedLHS, checkNumerically)) continue;
                if (index >= 0) {
                    return temp.substring(index + 1).trim();
                }
                valueFound = true;
            }
            return defaultResult;
        }
        return null;
    }

    private boolean equalsTypes(String first, String second, boolean checkNumerically) {
        boolean result = false;
        if (first.length() == 0) {
            return second.length() == 0;
        }
        if (second.length() == 0) {
            return first.length() == 0;
        }
        if (first.charAt(0) == '+') {
            first = first.substring(1);
        }
        if (second.charAt(0) == '+') {
            second = second.substring(1);
        }
        if (checkNumerically) {
            try {
                double d1 = Double.parseDouble(first);
                double d2 = Double.parseDouble(second);
                if (d1 == d2) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return first.equals(second);
    }
}

