/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capability;

import org.apache.jetspeed.capability.BaseCapabilityMap;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.registry.ClientEntry;
import org.apache.jetspeed.om.registry.ClientRegistry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class CapabilityMapFactory {
    public static final String DEFAULT_AGENT = "Mozilla/4.0";
    public static final String AGENT_XML = "agentxml/1.0";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CapabilityMapFactory.class.getName());

    public static CapabilityMap getCapabilityMap(RunData rundata) {
        if (rundata == null) {
            return CapabilityMapFactory.getCapabilityMap(DEFAULT_AGENT);
        }
        return CapabilityMapFactory.getCapabilityMap(rundata.getUserAgent());
    }

    public static CapabilityMap getCapabilityMap(String useragent) {
        ClientRegistry registry;
        ClientEntry entry;
        CapabilityMap map = null;
        if (useragent == null) {
            useragent = DEFAULT_AGENT;
        }
        if ((entry = (registry = (ClientRegistry)Registry.get(Registry.CLIENT)).findEntry(useragent)) == null) {
            if (useragent.equals(DEFAULT_AGENT)) {
                logger.error("CapabilityMap: Default agent not found in Client Registry !");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("CapabilityMap: useragent " + useragent + "unknown, falling back to default");
                }
                map = CapabilityMapFactory.getDefaultCapabilityMap();
            }
        } else {
            map = new BaseCapabilityMap(useragent, entry);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CapabilityMap: User-agent: " + useragent + " mapped to " + map);
        }
        return map;
    }

    public static CapabilityMap getDefaultCapabilityMap() {
        return CapabilityMapFactory.getCapabilityMap(DEFAULT_AGENT);
    }
}

