/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.modules.actions.TemplateSessionValidator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class NTLMSessionValidator
extends TemplateSessionValidator {
    private static final String INVALID_CHARS_KEY = "NTLMSessionValidator.chars.to.remove";
    private final String invalidChars = JetspeedResources.getString("NTLMSessionValidator.chars.to.remove", null);
    private static final byte z = 0;
    private static final byte[] msg1 = new byte[]{78, 84, 76, 77, 83, 83, 80, 0, 2, 0, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0, 1, -126, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String encodedMsg1 = "NTLM " + new String(Base64.encodeBase64((byte[])msg1));
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(NTLMSessionValidator.class.getName());

    public void doPerform(RunData data) throws Exception {
        CustomLocalizationService locService;
        Locale locale;
        JetspeedUser user;
        block11: {
            super.doPerform(data);
            user = (JetspeedUser)data.getUser();
            String userName = this.getRemoteUser(data);
            if (!(user != null && user.hasLoggedIn() || userName == null || userName.length() <= 0)) {
                byte[] temp = userName.getBytes();
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < temp.length; ++i) {
                    if (temp[i] == 0 || this.invalidChars != null && this.invalidChars.indexOf(temp[i]) >= 0) continue;
                    buffer.append((char)temp[i]);
                }
                userName = buffer.toString();
                try {
                    user = JetspeedSecurity.getUser(userName);
                    data.setUser((User)user);
                    user.setHasLoggedIn(new Boolean(true));
                    user.updateLastLogin();
                    data.save();
                    if (JetspeedSecurityCache.getAcl(userName) == null) {
                        JetspeedSecurityCache.load(userName);
                    }
                    logger.info("NTLMSessionValidator: automatic login using [" + userName + "]");
                }
                catch (LoginException noSuchUser) {
                }
                catch (UnknownUserException unknownUser) {
                    if (!logger.isWarnEnabled()) break block11;
                    logger.warn("NTLMSessionValidator: username [" + userName + "] does not exist or authentication failed, " + "redirecting to anon profile");
                }
            }
        }
        JetspeedRunData jdata = null;
        try {
            jdata = (JetspeedRunData)data;
        }
        catch (ClassCastException e) {
            logger.error("The RunData object does not implement the expected interface, please verify the RunData factory settings");
            return;
        }
        String language = data.getRequest().getParameter("js_language");
        if (null != language) {
            user.setPerm("language", language);
        }
        if ((locale = (locService = (CustomLocalizationService)ServiceUtil.getServiceByName("LocalizationService")).getLocale(data)) == null) {
            locale = new Locale(TurbineResources.getString((String)"locale.default.language", (String)"en"), TurbineResources.getString((String)"locale.default.country", (String)"US"));
        }
        data.getUser().setTemp("locale", (Object)locale);
        String paramPortlet = jdata.getParameters().getString("js_peid");
        if (paramPortlet != null && paramPortlet.length() > 0) {
            jdata.setJs_peid(paramPortlet);
        }
    }

    public boolean requiresNewSession(RunData data) {
        return false;
    }

    private String getRemoteUser(RunData data) throws Exception {
        HttpServletRequest request = data.getRequest();
        HttpServletResponse response = data.getResponse();
        if (data.getUser().hasLoggedIn() && request.getMethod().equalsIgnoreCase("get")) {
            return data.getUser().getUserName();
        }
        String auth = request.getHeader("Authorization");
        if (auth == null) {
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", "NTLM");
            response.flushBuffer();
            return null;
        }
        if (auth.startsWith("NTLM ")) {
            byte[] msg = Base64.decodeBase64((byte[])auth.substring(5).getBytes());
            int off = 0;
            if (msg[8] == 1) {
                response.setHeader("WWW-Authenticate", encodedMsg1);
                response.setStatus(401);
                return null;
            }
            if (msg[8] == 3) {
                if (data.getUser().hasLoggedIn()) {
                    return data.getUser().getUserName();
                }
                off = 30;
                int length = msg[off + 9] * 256 + msg[off + 8];
                int offset = msg[off + 11] * 256 + msg[off + 10];
                String username = new String(msg, offset, length);
                return username;
            }
        }
        return null;
    }
}

