/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.mail.SimpleEmail;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.modules.Action;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SendConfirmationEmail
extends Action {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(SendConfirmationEmail.class.getName());

    public void doPerform(RunData data) throws Exception {
        JetspeedUser user = JetspeedSecurity.getUser(data.getParameters().getString("username", ""));
        DynamicURI url = new DynamicURI(data).addPathInfo("template", "ConfirmRegistration").addPathInfo("username", user.getUserName()).addPathInfo("secretkey", user.getConfirmed()).addPathInfo("password", user.getPassword());
        try {
            StringWriter email_body = new StringWriter();
            Context emailContext = TurbineVelocity.getContext((RunData)data);
            SimpleEmail se = new SimpleEmail();
            String charset = JetspeedResources.getString("newuser.notification.charset", "iso-8859-1");
            se.setCharset(charset);
            emailContext.put("firstname", (Object)StringEscapeUtils.unescapeHtml(user.getFirstName()));
            emailContext.put("lastname", (Object)StringEscapeUtils.unescapeHtml(user.getLastName()));
            emailContext.put("username", (Object)StringEscapeUtils.unescapeHtml(user.getUserName()));
            emailContext.put("data", (Object)data);
            emailContext.put("user", (Object)user);
            emailContext.put("config", (Object)new JetspeedResources());
            emailContext.put("urltojetspeed", (Object)url);
            emailContext.put("email", (Object)se);
            String templateFile = JetspeedResources.getString("newuser.confirm.email.template");
            String templatePath = TemplateLocator.locateEmailTemplate(data, templateFile);
            TurbineVelocity.handleRequest((Context)emailContext, (String)templatePath, (Writer)email_body);
            se.setMsg(email_body.toString());
            Properties props = System.getProperties();
            String mailServerMachine = JetspeedResources.getString("mail.server");
            props.put("mail.host", mailServerMachine);
            props.put("mail.smtp.host", mailServerMachine);
            se.send();
            data.setMessage(Localization.getString((RunData)data, (String)"SENDCONFIRMATIONEMAIL_SENT"));
        }
        catch (Exception e) {
            String errorTitle = Localization.getString((String)"SENDCONFIRMATIONEMAIL_ERROR");
            String errorMessage = errorTitle + e.getMessage();
            logger.error(errorMessage, e);
            data.setMessage(errorTitle + errorMessage);
        }
    }
}

