/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.util.RunData;

public class TemplateSessionValidator
extends SessionValidator {
    public void doPerform(RunData rundata) throws Exception {
        JetspeedRunData data = (JetspeedRunData)rundata;
        data.populate();
        if (data.getUser() == null) {
            data.setUser(JetspeedSecurity.getAnonymousUser());
            data.save();
        }
        if (!data.hasScreen() && data.getTemplateInfo().getScreenTemplate() == null) {
            String template = JetspeedResources.getString("template.homepage");
            if (template != null) {
                data.getTemplateInfo().setScreenTemplate(template);
            } else {
                data.setScreen(JetspeedResources.getString("screen.homepage"));
            }
        } else if (data.getParameters().containsKey((Object)"_session_access_counter") && data.getParameters().getInt("_session_access_counter") < (Integer)data.getUser().getTemp("_session_access_counter") - 1) {
            if (data.getTemplateInfo().getScreenTemplate() != null) {
                data.getUser().setTemp("prev_template", (Object)data.getTemplateInfo().getScreenTemplate().replace('/', ','));
                data.getTemplateInfo().setScreenTemplate(JetspeedResources.getString("template.invalidstate"));
            } else {
                data.getUser().setTemp("prev_screen", (Object)data.getScreen().replace('/', ','));
                data.setScreen(JetspeedResources.getString("screen.invalidstate"));
            }
            data.getUser().setTemp("prev_parameters", (Object)data.getParameters());
            data.setAction("");
        }
        if (data.getTemplateInfo().getScreenTemplate() != null) {
            data.setScreen(null);
        }
    }

    public boolean requiresNewSession(RunData data) {
        return true;
    }
}

