/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import java.util.Hashtable;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.modules.Action;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.GenerateUniqueId;
import org.apache.turbine.util.RunData;

public class UpdateAccount
extends Action {
    public void doPerform(RunData rundata) throws Exception {
        JetspeedRunData data = (JetspeedRunData)rundata;
        if (!data.getUser().hasLoggedIn()) {
            data.setScreenTemplate(JetspeedResources.getString("services.JspService.screen.error.NotLoggedIn", "Error"));
            return;
        }
        String cancelBtn = data.getParameters().getString("CancelBtn", "");
        String username = data.getParameters().getString("username", "");
        String oldPassword = JetspeedSecurity.convertPassword(data.getParameters().getString("old_password", ""));
        String password = JetspeedSecurity.convertPassword(data.getParameters().getString("password", ""));
        String password2 = JetspeedSecurity.convertPassword(data.getParameters().getString("password_confirm", ""));
        String firstname = data.getParameters().getString("firstname", "");
        String lastname = data.getParameters().getString("lastname", "");
        String email = data.getParameters().getString("email", "");
        boolean userRequestsRememberMe = data.getParameters().getBoolean("rememberme", false);
        Hashtable<String, String> screenData = new Hashtable<String, String>();
        screenData.put("username", username);
        screenData.put("firstname", firstname);
        screenData.put("lastname", lastname);
        screenData.put("email", email);
        data.getRequest().setAttribute("ScreenDataEditAccount", screenData);
        if (!cancelBtn.equalsIgnoreCase("")) {
            return;
        }
        boolean changepass = false;
        if (password.trim().length() > 0 && password2.trim().length() > 0) {
            changepass = true;
        }
        if (changepass && !password.equals(password2)) {
            data.setMessage(Localization.getString((RunData)rundata, (String)"UPDATEACCOUNT_PWNOTMATCH"));
            this.backToEditAccount((RunData)data, screenData);
            return;
        }
        if (changepass && password.equals(oldPassword)) {
            changepass = false;
        }
        if (firstname.length() == 0) {
            data.setMessage(Localization.getString((RunData)rundata, (String)"UPDATEACCOUNT_NOFIRSTNAME"));
            this.backToEditAccount((RunData)data, screenData);
            return;
        }
        if (lastname.length() == 0) {
            data.setMessage(Localization.getString((RunData)rundata, (String)"UPDATEACCOUNT_NOLASTNAME"));
            this.backToEditAccount((RunData)data, screenData);
            return;
        }
        if (JetspeedResources.getBoolean("automatic.logon.enable", false)) {
            if (!userRequestsRememberMe) {
                if (data.getRequest().getCookies() != null && data.getCookies().getString("username") != null && data.getCookies().getString("logincookie") != null) {
                    Cookie userName = new Cookie("username", "");
                    Cookie loginCookie = new Cookie("logincookie", "");
                    String comment = JetspeedResources.getString("automatic.logon.cookie.comment", "");
                    String domain = JetspeedResources.getString("automatic.logon.cookie.domain");
                    String path = JetspeedResources.getString("automatic.logon.cookie.path", "/");
                    if (domain == null) {
                        String server = data.getServerName();
                        domain = "." + server;
                    }
                    userName.setMaxAge(0);
                    userName.setComment(comment);
                    userName.setDomain(domain);
                    userName.setPath(path);
                    loginCookie.setMaxAge(0);
                    loginCookie.setComment(comment);
                    loginCookie.setDomain(domain);
                    loginCookie.setPath(path);
                    data.getResponse().addCookie(userName);
                    data.getResponse().addCookie(loginCookie);
                    data.getCookies().remove("username");
                    data.getCookies().remove("logincookie");
                }
            } else if (data.getRequest().getCookies() == null || !data.getCookies().getString("username", "").equals(data.getUser().getUserName()) || !data.getCookies().getString("logincookie", "").equals(data.getUser().getPerm("logincookie"))) {
                String loginCookieValue = (String)data.getUser().getPerm("logincookie");
                if (loginCookieValue == null || loginCookieValue.length() == 0) {
                    loginCookieValue = "" + Math.random();
                    data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                    JetspeedSecurity.saveUser(data.getJetspeedUser());
                }
                Cookie userName = new Cookie("username", data.getUser().getUserName());
                Cookie loginCookie = new Cookie("logincookie", loginCookieValue);
                int maxage = JetspeedResources.getInt("automatic.logon.cookie.maxage", -1);
                String comment = JetspeedResources.getString("automatic.logon.cookie.comment", "");
                String domain = JetspeedResources.getString("automatic.logon.cookie.domain");
                String path = JetspeedResources.getString("automatic.logon.cookie.path", "/");
                if (domain == null) {
                    String server = data.getServerName();
                    domain = "." + server;
                }
                userName.setMaxAge(maxage);
                userName.setComment(comment);
                userName.setDomain(domain);
                userName.setPath(path);
                loginCookie.setMaxAge(maxage);
                loginCookie.setComment(comment);
                loginCookie.setDomain(domain);
                loginCookie.setPath(path);
                data.getResponse().addCookie(userName);
                data.getResponse().addCookie(loginCookie);
                data.getCookies().add("username", data.getUser().getUserName());
                data.getCookies().add("logincookie", loginCookieValue);
            }
        }
        if (email.length() == 0) {
            data.setMessage(Localization.getString((RunData)rundata, (String)"UPDATEACCOUNT_NOEMAIL"));
            this.backToEditAccount((RunData)data, screenData);
            return;
        }
        boolean enableMail = JetspeedResources.getBoolean("newuser.confirm.enable", false);
        String currentEmail = data.getUser().getEmail();
        if (enableMail && (currentEmail == null || !currentEmail.equalsIgnoreCase(email))) {
            data.getUser().setEmail(email);
            data.getUser().setConfirmed(GenerateUniqueId.getIdentifier());
            JetspeedSecurity.saveUser(data.getJetspeedUser());
            ActionLoader.getInstance().exec((RunData)data, "SendConfirmationEmail");
            data.getParameters().add("username", data.getUser().getUserName());
            data.setMessage(Localization.getString((RunData)rundata, (String)"UPDATEACCOUNT_NEWEMAILCONFIRM"));
            data.setScreenTemplate("ConfirmRegistration");
        } else {
            JetspeedSecurity.saveUser(data.getJetspeedUser());
        }
        data.getUser().setFirstName(firstname);
        data.getUser().setLastName(lastname);
        data.getUser().setEmail(email);
        if (changepass) {
            try {
                JetspeedSecurity.changePassword(data.getJetspeedUser(), oldPassword, password);
            }
            catch (JetspeedSecurityException e) {
                data.setMessage(e.getMessage());
                this.backToEditAccount((RunData)data, screenData);
                return;
            }
        }
        this.updateUser((RunData)data);
        JetspeedSecurity.saveUser(data.getJetspeedUser());
        data.setMessage(Localization.getString((RunData)rundata, (String)"UPDATEACCOUNT_DONE"));
    }

    protected void updateUser(RunData data) {
    }

    private void backToEditAccount(RunData rundata, Hashtable screenData) {
        rundata.getRequest().setAttribute("ScreenDataEditAccount", (Object)screenData);
        rundata.setScreenTemplate("EditAccount");
    }
}

