/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.controllers;

import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.modules.actions.VelocityAction;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public abstract class VelocityControllerAction
extends VelocityAction {
    protected void perform(RunData rundata) throws Exception {
        Context context = this.getContext(rundata);
        if (context != null) {
            this.doPerform(rundata);
        } else {
            context = TurbineVelocity.getContext();
            rundata.getTemplateInfo().setTemplateContext("VelocityActionContext", (Object)context);
            try {
                this.executeEvents(rundata, context);
            }
            catch (NoSuchMethodException e) {
                this.doPerform(rundata);
            }
        }
    }

    public void setTemplate(RunData data, String template) {
        this.getContext(data).put("template", (Object)template);
    }

    protected Context getContext(RunData data) {
        return (Context)data.getTemplateInfo().getTemplateContext("VelocityControllerContext");
    }

    public void doPerform(RunData rundata, Context context) {
        PortletController controller = (PortletController)context.get("controller");
        if (((JetspeedRunData)rundata).getMode() == 1) {
            this.buildCustomizeContext(controller, context, rundata);
            return;
        }
        this.buildNormalContext(controller, context, rundata);
    }

    protected void buildCustomizeContext(PortletController controller, Context context, RunData rundata) {
        String name = controller.getPortlets().getName();
        String template = (String)context.get("template");
        int dotIdx = template.lastIndexOf(46);
        template = dotIdx > -1 ? template.substring(0, dotIdx) + "-customize.vm" : template + "-customize";
        this.setTemplate(rundata, template);
        context.put("action", (Object)controller.getConfig().getInitParameter("action"));
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        SessionState customizationState = jdata.getPageSessionState();
        String saveLabel = null;
        saveLabel = ((String)customizationState.getAttribute("customize-paneName")).equalsIgnoreCase("*") ? Localization.getString((RunData)rundata, (String)"CUSTOMIZER_SAVEAPPLY") : Localization.getString((RunData)rundata, (String)"CUSTOMIZER_APPLY");
        context.put("saveLabel", (Object)saveLabel);
    }

    protected abstract void buildNormalContext(PortletController var1, Context var2, RunData var3);

    public void doCancel(RunData data, Context context) {
    }
}

