/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.RegistryUpdateAction;
import org.apache.jetspeed.om.registry.MediaTypeRegistry;
import org.apache.jetspeed.om.registry.PortletControlEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ControlUpdateAction
extends RegistryUpdateAction {
    private static final String CONTROL_UPDATE_PANE = "ControlForm";

    public ControlUpdateAction() {
        this.registryEntryName = "control_name";
        this.registry = Registry.PORTLET_CONTROL;
        this.pane = CONTROL_UPDATE_PANE;
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        super.buildNormalContext(portlet, context, rundata);
        String mode = rundata.getParameters().getString("mode");
        if (mode != null && (mode.equals("delete") || mode.equals("update"))) {
            String controllerName = rundata.getParameters().getString(this.registryEntryName);
            PortletControlEntry controlEntry = (PortletControlEntry)Registry.getEntry(this.registry, controllerName);
            context.put("entry", (Object)controlEntry);
            MediaTypeRegistry mediaTypeReg = (MediaTypeRegistry)Registry.get(Registry.MEDIA_TYPE);
            context.put("media_types", (Object)this.iteratorToCollection(mediaTypeReg.listEntryNames()));
        }
    }

    protected void updateRegistryEntry(RunData rundata, RegistryEntry registryEntry) throws Exception {
        super.updateRegistryEntry(rundata, registryEntry);
        PortletControlEntry controllerEntry = (PortletControlEntry)registryEntry;
        String className = rundata.getParameters().getString("class_name");
        if (this.hasChanged(controllerEntry.getClassname(), className)) {
            controllerEntry.setClassname(className);
        }
    }

    protected void resetForm(RunData rundata) {
        super.resetForm(rundata);
    }

    protected void clearUserData(RunData rundata) {
        super.clearUserData(rundata);
    }
}

