/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.RegistryUpdateAction;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MediaUpdateAction
extends RegistryUpdateAction {
    private static final String MEDIA_UPDATE_PANE = "MediaForm";

    public MediaUpdateAction() {
        this.registryEntryName = "media_type_name";
        this.registry = Registry.MEDIA_TYPE;
        this.pane = MEDIA_UPDATE_PANE;
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        super.buildNormalContext(portlet, context, rundata);
        String mode = rundata.getParameters().getString("mode");
        if (mode != null && (mode.equals("delete") || mode.equals("update"))) {
            String mediaTypeName = rundata.getParameters().getString(this.registryEntryName);
            MediaTypeEntry mediaEntry = (MediaTypeEntry)Registry.getEntry(this.registry, mediaTypeName);
            context.put("entry", (Object)mediaEntry);
        }
    }

    protected void updateRegistryEntry(RunData rundata, RegistryEntry registryEntry) throws Exception {
        super.updateRegistryEntry(rundata, registryEntry);
        this.updateMediaTypeEntry(rundata, (MediaTypeEntry)registryEntry);
    }

    protected void updateMediaTypeEntry(RunData rundata, MediaTypeEntry mediaTypeEntry) {
        String charSet = rundata.getParameters().getString("charset");
        String mimeType = rundata.getParameters().getString("mime_type");
        if (this.hasChanged(mediaTypeEntry.getCharacterSet(), charSet)) {
            mediaTypeEntry.setCharacterSet(charSet);
        }
        if (this.hasChanged(mediaTypeEntry.getMimeType(), mimeType)) {
            mediaTypeEntry.setMimeType(mimeType);
        }
    }

    protected void resetForm(RunData rundata) {
        super.resetForm(rundata);
        String charSet = rundata.getParameters().getString("charset");
        String mimeType = rundata.getParameters().getString("mime_type");
        rundata.getUser().setTemp("charset", (Object)charSet);
        rundata.getUser().setTemp("mime_type", (Object)mimeType);
    }

    protected void clearUserData(RunData rundata) {
        super.clearUserData(rundata);
        rundata.getUser().removeTemp("charset");
        rundata.getUser().removeTemp("mime_type");
    }
}

