/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.jetspeed.om.registry.InvalidEntryException;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseRegistryEntry;
import org.apache.jetspeed.om.registry.base.LocalRegistry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class BaseOrderedRegistry
implements LocalRegistry {
    protected List entries = new Vector();
    protected Map idx = null;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseOrderedRegistry.class.getName());

    public int getEntryCount() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryEntry getEntry(String name) throws InvalidEntryException {
        RegistryEntry entry;
        block13: {
            entry = null;
            try {
                List list;
                if (this.idx == null) {
                    list = this.entries;
                    synchronized (list) {
                        this.buildIdx();
                    }
                }
                if (name == null) break block13;
                list = this.entries;
                synchronized (list) {
                    Integer pos = (Integer)this.idx.get(name);
                    if (pos == null) {
                        throw new InvalidEntryException("The specified entry does not exist within the Registry " + name);
                    }
                    entry = (RegistryEntry)this.entries.get(pos);
                }
            }
            catch (Exception e) {
                List list = this.entries;
                synchronized (list) {
                    this.buildIdx();
                }
                logger.error("getEntry: index and vector are not in synch.", e);
                throw new InvalidEntryException("The specified entry does not exist within the Registry " + name);
            }
        }
        return entry;
    }

    public void setEntry(RegistryEntry entry) throws InvalidEntryException {
        this.setLocalEntry(entry);
    }

    public void addEntry(RegistryEntry entry) throws InvalidEntryException {
        this.addLocalEntry(entry);
    }

    public void removeEntry(String name) {
        this.removeLocalEntry(name);
    }

    public void removeEntry(RegistryEntry entry) {
        this.removeLocalEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(String name) {
        List list = this.entries;
        synchronized (list) {
            if (this.idx == null) {
                this.buildIdx();
            }
        }
        return this.idx.containsKey(name);
    }

    public Enumeration getEntries() {
        Vector v = new Vector(this.entries);
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listEntryNames() {
        List list = this.entries;
        synchronized (list) {
            if (this.idx == null) {
                this.buildIdx();
            }
        }
        return this.idx.keySet().iterator();
    }

    public RegistryEntry[] toArray() {
        RegistryEntry[] array = new RegistryEntry[this.entries.size()];
        return this.entries.toArray(array);
    }

    public RegistryEntry createEntry() {
        return new BaseRegistryEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalEntry(RegistryEntry entry) throws InvalidEntryException {
        List list = this.entries;
        synchronized (list) {
            if (this.idx == null) {
                this.buildIdx();
            }
            if (!this.idx.containsKey(entry.getName())) {
                throw new InvalidEntryException("The specified entry does not exist within the Registry " + entry.getName());
            }
            int pos = (Integer)this.idx.get(entry.getName());
            this.entries.set(pos, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEntry(RegistryEntry entry) throws InvalidEntryException {
        List list = this.entries;
        synchronized (list) {
            if (this.idx == null) {
                this.buildIdx();
            }
            if (this.idx.containsKey(entry.getName())) {
                throw new InvalidEntryException("The entry specified already exists within the Registry");
            }
            int pos = this.entries.size();
            this.entries.add(entry);
            this.idx.put(entry.getName(), new Integer(pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEntry(String name) {
        List list = this.entries;
        synchronized (list) {
            if (this.idx == null) {
                this.buildIdx();
            }
            if (this.idx.containsKey(name)) {
                int pos = (Integer)this.idx.get(name);
                this.entries.remove(pos);
                this.buildIdx();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEntry(RegistryEntry entry) {
        List list = this.entries;
        synchronized (list) {
            if (this.entries.remove(entry)) {
                this.buildIdx();
            }
        }
    }

    private void buildIdx() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (int i = 0; i < this.entries.size(); ++i) {
            RegistryEntry entry = (RegistryEntry)this.entries.get(i);
            map.put(entry.getName(), new Integer(i));
        }
        this.idx = map;
    }
}

