/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.jetspeed.om.registry.Category;
import org.apache.jetspeed.om.registry.InvalidEntryException;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.PortletRegistry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.RegistryException;
import org.apache.jetspeed.om.registry.base.BasePortletEntry;
import org.apache.jetspeed.om.registry.base.BaseRegistry;
import org.apache.jetspeed.om.registry.base.CategoryIterator;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class BasePortletRegistry
extends BaseRegistry
implements PortletRegistry {
    private Map catMap = new TreeMap();
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BasePortletRegistry.class.getName());

    public void setEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.PORTLET, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void addEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.PORTLET, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void removeEntry(String name) {
        Registry.removeEntry(Registry.PORTLET, name);
    }

    public void removeEntry(RegistryEntry entry) {
        if (entry != null) {
            Registry.removeEntry(Registry.PORTLET, entry.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPortletEntry(PortletEntry entry) throws InvalidEntryException {
        Map map = this.catMap;
        synchronized (map) {
            int count = 0;
            Iterator it = entry.listCategories();
            while (it.hasNext()) {
                Category category = (Category)it.next();
                String key = this.getCategoryKey(category);
                HashMap<String, PortletEntry> bucket = (HashMap<String, PortletEntry>)this.catMap.get(key);
                if (null == bucket) {
                    bucket = new HashMap<String, PortletEntry>();
                    bucket.put(entry.getName(), entry);
                    this.catMap.put(key, bucket);
                } else {
                    bucket.put(entry.getName(), entry);
                }
                ++count;
            }
            if (0 == count) {
                StringBuffer key = new StringBuffer(128);
                key.append("Jetspeed");
                key.append(".");
                if (entry.getType().equals("abstract")) {
                    key.append("Abstract");
                } else {
                    key.append("General");
                }
                HashMap<String, PortletEntry> bucket = (HashMap<String, PortletEntry>)this.catMap.get(key.toString());
                if (null == bucket) {
                    bucket = new HashMap<String, PortletEntry>();
                    bucket.put(entry.getName(), entry);
                    this.catMap.put(key.toString(), bucket);
                } else {
                    bucket.put(entry.getName(), entry);
                }
            }
        }
    }

    public String getCategoryKey(Category category) {
        if (category == null) {
            return "Jetspeed";
        }
        String categoryName = category.getName();
        if (categoryName == null || categoryName.equals("")) {
            return category.getGroup();
        }
        return category.getGroup() + "." + categoryName;
    }

    public Iterator findPortletsByCategory(String category) {
        String key = category == null || category.equals("") ? "Jetspeed" : "Jetspeed." + category;
        CategoryIterator iterator = new CategoryIterator((SortedMap)this.catMap, key);
        return iterator;
    }

    public Iterator findPortletsByGroupCategory(String group, String category) {
        if (group == null || group.equals("")) {
            group = "Jetspeed";
        }
        String key = group + "." + category;
        CategoryIterator iterator = new CategoryIterator((SortedMap)this.catMap, key);
        return iterator;
    }

    public Iterator listByCategory() {
        CategoryIterator iterator = new CategoryIterator((SortedMap)this.catMap, null);
        return iterator;
    }

    public RegistryEntry createEntry() {
        return new BasePortletEntry();
    }

    public void setLocalEntry(RegistryEntry entry) throws InvalidEntryException {
        super.setLocalEntry(entry);
        this.setPortletEntry((PortletEntry)entry);
    }

    public void addLocalEntry(RegistryEntry entry) throws InvalidEntryException {
        super.addLocalEntry(entry);
        this.setPortletEntry((PortletEntry)entry);
    }

    public void removeLocalEntry(String name) {
        if (name == null) {
            return;
        }
        RegistryEntry entry = (RegistryEntry)this.entries.get(name);
        if (entry == null) {
            return;
        }
        this.removeLocalEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEntry(RegistryEntry entry) {
        Map map = this.catMap;
        synchronized (map) {
            boolean count = false;
            Iterator it = ((PortletEntry)entry).listCategories();
            while (it.hasNext()) {
                Category category = (Category)it.next();
                HashMap map2 = (HashMap)this.catMap.get(this.getCategoryKey(category));
                if (map2 == null) continue;
                map2.remove(entry.getName());
                if (0 != map2.size()) continue;
                this.catMap.remove(this.getCategoryKey(category));
            }
        }
        super.removeLocalEntry(entry);
    }
}

