/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security.turbine;

import com.workingdogs.village.Column;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import com.workingdogs.village.Value;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUserFactory;
import org.apache.jetspeed.om.security.turbine.BaseTurbineUserPeer;
import org.apache.torque.TorqueException;
import org.apache.torque.om.NumberKey;
import org.apache.torque.util.Criteria;
import org.apache.turbine.util.ObjectUtils;

public class TurbineUserPeer
extends BaseTurbineUserPeer {
    private static Schema schema = TurbineUserPeer.initTableSchema((String)"TURBINE_USER");
    private static Column[] columns = TurbineUserPeer.initTableColumns((Schema)schema);
    public static String[] columnNames = TurbineUserPeer.initColumnNames((Column[])columns);
    protected static final String TURBINE_OBJECTDATA = "OBJECTDATA";

    public static List doSelectUsers(Criteria criteria) throws TorqueException {
        return TurbineUserPeer.populateUserObjects(TurbineUserPeer.doSelectVillageRecords(criteria));
    }

    public static List populateUserObjects(List records) throws TorqueException {
        ArrayList<JetspeedUser> results = new ArrayList<JetspeedUser>(records.size());
        for (int i = 0; i < records.size(); ++i) {
            Record row = (Record)records.get(i);
            results.add(TurbineUserPeer.row2UserObject(row, 1, TurbineUserPeer.getOMClass()));
        }
        return results;
    }

    public static JetspeedUser row2UserObject(Record row, int offset, Class cls) throws TorqueException {
        try {
            JetspeedUser user = JetspeedUserFactory.getInstance(false);
            TurbineUserPeer.populateUserObject(row, offset, user);
            return user;
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected static void populateUserObject(Record row, int offset, JetspeedUser user) throws Exception {
        int idPosition = 1;
        int objectDataPosition = columnNames.length;
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i].equals(USER_ID)) {
                idPosition = i + 1;
            }
            if (!columnNames[i].equals(TURBINE_OBJECTDATA)) continue;
            objectDataPosition = i + 1;
        }
        byte[] objectData = row.getValue(objectDataPosition).asBytes();
        Hashtable<String, Object> tempHash = (Hashtable<String, Object>)ObjectUtils.deserialize((byte[])objectData);
        if (tempHash == null) {
            tempHash = new Hashtable<String, Object>(10);
        }
        for (int j = 0; j < columnNames.length; ++j) {
            if (columnNames[j].equalsIgnoreCase(TURBINE_OBJECTDATA)) continue;
            Object obj2 = null;
            Value value = row.getValue(j + 1);
            if (value.isString()) {
                obj2 = value.asString();
            } else if (value.isBigDecimal()) {
                obj2 = value.asBigDecimal();
            } else if (value.isBytes()) {
                obj2 = value.asBytes();
            } else if (value.isDate()) {
                obj2 = value.asDate();
            } else if (value.isShort()) {
                obj2 = new Short(value.asShort());
            } else if (value.isInt()) {
                obj2 = new Integer(value.asInt());
            } else if (value.isLong()) {
                obj2 = new Long(value.asLong());
            } else if (value.isDouble()) {
                obj2 = new Double(value.asDouble());
            } else if (value.isFloat()) {
                obj2 = new Float(value.asFloat());
            } else if (value.isBoolean()) {
                obj2 = new Boolean(value.asBoolean());
            } else if (value.isTime()) {
                obj2 = value.asTime();
            } else if (value.isTimestamp()) {
                obj2 = value.asTimestamp();
            } else if (value.isUtilDate()) {
                obj2 = value.asUtilDate();
            } else if (value.isByte()) {
                obj2 = new Byte(value.asByte());
            }
            if (obj2 == null) continue;
            if (columnNames[j].equalsIgnoreCase("USER_ID")) {
                obj2 = value.toString();
            }
            tempHash.put(columnNames[j], obj2);
        }
        user.setPermStorage(tempHash);
    }

    public static Criteria buildCriteria(JetspeedUser user) {
        Hashtable permData = (Hashtable)user.getPermStorage().clone();
        Criteria criteria = new Criteria();
        if (!user.isNew()) {
            criteria.add(USER_ID, (Object)new NumberKey(user.getUserId()));
        }
        for (int i = 1; i < columnNames.length; ++i) {
            if (!permData.containsKey(columnNames[i])) continue;
            String key = new StringBuffer("TURBINE_USER").append('.').append(columnNames[i]).toString();
            criteria.add(key, permData.remove(columnNames[i]));
        }
        String dataKey = new StringBuffer("TURBINE_USER").append('.').append(TURBINE_OBJECTDATA).toString();
        criteria.add(dataKey, (Object)permData);
        return criteria;
    }
}

