/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.jetspeed.util.template.JetspeedTool;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class PreviewPortlet
extends AbstractPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PreviewPortlet.class.getName());

    public ConcreteElement getContent(RunData rundata) {
        Context context = TurbineVelocity.getContext((RunData)rundata);
        context.put("data", (Object)rundata);
        TurbineVelocity.getContext((RunData)rundata).put("jetspeed", (Object)new JetspeedTool(rundata));
        JetspeedClearElement result = null;
        String controlName = rundata.getParameters().getString("previewedControlName");
        String portletName = rundata.getParameters().getString("previewedPortletName");
        if (portletName == null) {
            JetspeedLink jsLink = null;
            try {
                jsLink = JetspeedLinkFactory.getInstance(rundata);
                rundata.setRedirectURI(jsLink.setUser(rundata.getUser().getUserName(), "default.psml").addPathInfo("template", "Customize").addPathInfo("media-type", "html").toString());
                JetspeedLinkFactory.putInstance(jsLink);
                jsLink = null;
                return new JetspeedClearElement("");
            }
            catch (Exception e) {
                logger.error("Exception", e);
                rundata.setScreenTemplate("Home");
                return new JetspeedClearElement("");
            }
        }
        Portlet portlet = null;
        try {
            portlet = PortletFactory.getPortlet(portletName, "PreviewPortlet");
            PortletControl control = controlName == null ? PortalToolkit.getControl((String)null) : PortalToolkit.getControl(controlName);
            control = null;
            if (control != null) {
                JetspeedRunData jdata = (JetspeedRunData)rundata;
                control.setPortlet(portlet);
                control.init();
                result = control.getContent(rundata);
            } else if (portlet != null) {
                result = portlet.getContent(rundata);
            }
            if (result == null || result.toString().equals("")) {
                result = new JetspeedClearElement("");
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            result = new JetspeedClearElement("This resource is temporarily unavailable");
        }
        rundata.setLayout("preview");
        return result;
    }
}

