/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.FileWatchPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.SimpleTransform;
import org.apache.jetspeed.xml.JetspeedXMLEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RSSPortlet
extends FileWatchPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RSSPortlet.class.getName());
    public static final String ERROR_NOT_VALID = "This does not appear to be an RSS document";
    private Item[] items = new Item[0];

    public void init() throws PortletException {
        DocumentBuilder parser = null;
        Document document = null;
        String url = null;
        try {
            DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
            docfactory.setValidating(false);
            parser = docfactory.newDocumentBuilder();
            parser.setEntityResolver(new JetspeedXMLEntityResolver());
            url = this.getPortletConfig().getURL();
            String content = JetspeedDiskCache.getInstance().getEntry(url).getData();
            InputSource is = new InputSource(this.cleanse(content));
            is.setEncoding("UTF8");
            is.setSystemId(url);
            document = parser.parse(is);
        }
        catch (Throwable t) {
            String message = "RSSPortlet:  Couldn't parse out XML document -> " + url;
            logger.error(message, t);
            throw new PortletException(t.getMessage());
        }
        try {
            this.setItems(this.parseItems(document));
            String title = null;
            String description = null;
            Node root = document.getFirstChild();
            Node channel = null;
            NodeList list = document.getElementsByTagName("channel");
            if (list.getLength() != 1) {
                throw new PortletException(ERROR_NOT_VALID);
            }
            channel = list.item(0);
            Node tn = RSSPortlet.getNode(channel, "title");
            if (tn == null) {
                throw new PortletException(ERROR_NOT_VALID);
            }
            title = tn.getFirstChild().getNodeValue();
            Node dn = RSSPortlet.getNode(channel, "description");
            if (dn != null) {
                description = dn.getFirstChild().getNodeValue();
            }
            this.setTitle(title);
            this.setDescription(description);
            String stylesheet = this.getPortletConfig().getInitParameter("stylesheet");
            if (stylesheet == null) {
                throw new PortletException("The 'stylesheet' parameter was not defined.");
            }
            try {
                String content = SimpleTransform.transform(document, stylesheet, this.getPortletConfig().getInitParameters());
                this.setContent((ConcreteElement)new JetspeedClearElement(content));
            }
            catch (SAXException e) {
                logger.error("Exception", e);
                throw new PortletException(e.getMessage());
            }
        }
        catch (Throwable t) {
            String message = "RSSPortlet:  Couldn't set items for XML document -> " + url;
            logger.error(message, t);
            throw new PortletException(t.getMessage());
        }
    }

    private static final Node getNode(Node start, String name) {
        NodeList list = start.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().equals(name)) continue;
            return node;
        }
        return null;
    }

    private Reader cleanse(String content) throws IOException, SAXException {
        String filtered = null;
        String XMLDECL = "<?xml version=";
        int start = content.indexOf(XMLDECL);
        filtered = start <= 0 ? content : content.substring(start, content.length());
        return new StringReader(filtered);
    }

    public Item[] getItems() {
        return this.items;
    }

    public void setItems(Item[] items) {
        this.items = items;
    }

    public boolean isCacheable() {
        return true;
    }

    private Item[] parseItems(Document doc) {
        String root = doc.getDocumentElement().getTagName();
        if (root.equals("rdf:RDF")) {
            NodeList list = doc.getElementsByTagName("item");
            return this.getItems(list);
        }
        if (root.equals("rss")) {
            NodeList list = doc.getElementsByTagName("channel");
            if (list.getLength() != 1) {
                return new Item[0];
            }
            Node channel = list.item(0);
            return this.getItems(channel.getChildNodes());
        }
        if (root.equals("xml")) {
            NodeList list = doc.getElementsByTagName("item");
            return this.getItems(list);
        }
        return new Item[0];
    }

    private Item[] getItems(NodeList items) {
        Vector<Item> v = new Vector<Item>();
        for (int i = 0; i < items.getLength(); ++i) {
            Node node = items.item(i);
            if (!node.getNodeName().equals("item")) continue;
            NodeList itemChildren = node.getChildNodes();
            String title = null;
            String link = null;
            String description = null;
            for (int j = 0; j < itemChildren.getLength(); ++j) {
                Node child = itemChildren.item(j);
                if (child.getNodeName().equals("title") && child.getFirstChild() != null) {
                    title = child.getFirstChild().getNodeValue();
                }
                if (child.getNodeName().equals("link") && child.getFirstChild() != null) {
                    link = child.getFirstChild().getNodeValue();
                }
                if (!child.getNodeName().equals("description") || child.getFirstChild() == null) continue;
                description = child.getFirstChild().getNodeValue();
            }
            v.addElement(new Item(title, link, description));
        }
        Object[] foundItems = new Item[v.size()];
        v.copyInto(foundItems);
        return foundItems;
    }

    public static class Item {
        private String title;
        private String link;
        private String description;

        public Item(String title, String link, String description) {
            this(title, link);
            this.description = description;
        }

        public Item(String title, String link) {
            this.title = title;
            this.link = link;
        }

        public String getTitle() {
            return this.title;
        }

        public String getLink() {
            return this.link;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

