/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractInstancePortlet;
import org.apache.jetspeed.services.Transformer;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.Base64;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.RunData;

public class WebClippingPortlet
extends AbstractInstancePortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WebClippingPortlet.class.getName());
    public static final String START = "startTag";
    public static final String STOP = "stopTag";
    public static final String TAG = "Tag";
    public static final String TAGNUM = "startTagNumber";
    public static final String URL = "url";
    private String BAD_PARAM = "<br>Error: startTag without stopTag<br>";
    private String BAD_NUMBER = "<br>Error: bad integer parameter<br>";
    protected boolean initDone = false;
    protected boolean contentStale = true;
    protected boolean cacheContent = false;
    protected String username = null;
    protected String password = null;
    private Hashtable patterns = null;

    public void init() {
        if (this.initDone) {
            return;
        }
        this.patterns = new Hashtable();
        try {
            this.loadParams();
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString());
            e.printStackTrace();
        }
        this.contentStale = true;
        this.initDone = true;
    }

    protected Reader getReader(String url) throws IOException {
        URL pageUrl = new URL(url);
        URLConnection pageConn = pageUrl.openConnection();
        try {
            if (this.username != null && this.password != null) {
                pageConn.setRequestProperty("Authorization", "Basic " + Base64.encodeAsString(this.username + ":" + this.password));
            }
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString());
            e.printStackTrace();
        }
        long pageExpiration = pageConn.getExpiration();
        String encoding = "iso-8859-1";
        String contentType = pageConn.getContentType();
        String tempString = null;
        String noCache = "no-cache";
        if (contentType != null) {
            StringTokenizer st = new StringTokenizer(contentType, "; =");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equalsIgnoreCase("charset")) continue;
                try {
                    encoding = st.nextToken();
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
        this.cacheContent = true;
        if (pageExpiration == 0L) {
            this.cacheContent = false;
        }
        if ((tempString = pageConn.getHeaderField("Cache-Control")) != null && tempString.toLowerCase().indexOf(noCache) >= 0) {
            this.cacheContent = false;
        }
        if ((tempString = pageConn.getHeaderField("Pragma")) != null && tempString.toLowerCase().indexOf(noCache) >= 0) {
            this.cacheContent = false;
        }
        InputStreamReader rdr = new InputStreamReader(pageConn.getInputStream(), encoding);
        if (pageExpiration > System.currentTimeMillis() && this.cacheContent) {
            this.contentStale = false;
            logger.debug("WebPagePortlet caching URL: " + url + " Expiration: " + pageExpiration + ", " + (pageExpiration - System.currentTimeMillis()) + " milliseconds into the future");
            this.setExpirationMillis(pageExpiration);
        } else {
            this.contentStale = true;
        }
        return rdr;
    }

    public ConcreteElement getContent(RunData data) {
        PortletConfig config = this.getPortletConfig();
        if (this.contentStale) {
            return this.getWebClippedContent(data, config);
        }
        if (null == this.getExpirationMillis()) {
            return this.getContent(data, null, true);
        }
        if (this.getExpirationMillis() <= System.currentTimeMillis()) {
            return this.getWebClippedContent(data, config);
        }
        return this.getContent(data, null, true);
    }

    private ConcreteElement getWebClippedContent(RunData data, PortletConfig config) {
        String clippedString = "";
        JetspeedClearElement element = null;
        int patternNumber = 1;
        int tagNumber = 0;
        String defaultUrl = this.selectUrl(data, config);
        try {
            this.loadParams();
            Enumeration en = this.patterns.keys();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (!name.equals(START + String.valueOf(patternNumber)) && !name.equals(TAG + String.valueOf(patternNumber))) continue;
                String start = (String)this.patterns.get(START + String.valueOf(patternNumber));
                String simpleTag = (String)this.patterns.get(TAG + String.valueOf(patternNumber));
                String stop = (String)this.patterns.get(STOP + String.valueOf(patternNumber));
                String tagNum = (String)this.patterns.get(TAGNUM + String.valueOf(patternNumber));
                String url = (String)this.patterns.get(URL + String.valueOf(patternNumber));
                url = this.controlUrl(url, defaultUrl);
                Reader htmlReader = this.getReader(url);
                if (start != null && stop == null) {
                    element = new JetspeedClearElement(this.BAD_PARAM);
                    return element;
                }
                if (tagNum != null) {
                    try {
                        tagNumber = Integer.parseInt(tagNum);
                    }
                    catch (NumberFormatException e) {
                        logger.info("Exception occurred:" + e.toString());
                        e.printStackTrace();
                        element = new JetspeedClearElement(this.BAD_NUMBER);
                        return element;
                    }
                }
                if (simpleTag != null && tagNum == null) {
                    clippedString = clippedString + Transformer.findElement(htmlReader, url, simpleTag);
                } else if (simpleTag != null && tagNum != null) {
                    clippedString = clippedString + Transformer.findElementNumber(htmlReader, url, simpleTag, tagNumber);
                } else if (tagNum == null) {
                    clippedString = clippedString + Transformer.clipElements(htmlReader, url, start, stop);
                } else if (tagNum != null) {
                    clippedString = clippedString + Transformer.clipElementsNumber(htmlReader, url, start, stop, tagNumber);
                }
                ++patternNumber;
                en = this.patterns.keys();
                htmlReader.close();
            }
            element = new JetspeedClearElement(clippedString);
            this.clearContent();
            this.setContent((ConcreteElement)element);
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString());
            e.printStackTrace();
        }
        return element;
    }

    public void refresh() {
        if (this.cacheContent) {
            this.getWebClippedContent(null, this.getPortletConfig());
        }
    }

    protected String selectUrl(RunData data, PortletConfig config) {
        String url = config.getURL();
        return url;
    }

    private String controlUrl(String url, String defaultUrl) {
        if (url == null) {
            return defaultUrl;
        }
        if (url.indexOf("://") < 0) {
            url = TurbineServlet.getResource((String)url).toString();
        }
        return url;
    }

    private void loadParams() throws PortletException {
        Iterator en = this.getPortletConfig().getInitParameterNames();
        try {
            while (en.hasNext()) {
                String name = (String)en.next();
                if (name.equals("username")) {
                    this.username = this.getPortletConfig().getInitParameter("username");
                    continue;
                }
                if (name.equals("password")) {
                    this.password = this.getPortletConfig().getInitParameter("password");
                    continue;
                }
                this.patterns.put(name, this.getPortletConfig().getInitParameter(name));
            }
        }
        catch (Exception e) {
            logger.info("Exception occurred:" + e.toString());
            e.printStackTrace();
            throw new PortletException(e.toString());
        }
    }
}

