/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.admin;

import java.io.Reader;
import java.io.Writer;
import org.apache.jetspeed.cache.disk.DiskCacheEntry;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.xml.api.jcm.Content;

class ContentMarkup {
    private long lastModified;
    private Content content = null;
    private String url = null;

    public ContentMarkup(String url) throws Exception {
        System.err.println("Content Markup url => " + url);
        this.url = url;
        this.lastModified = JetspeedDiskCache.getInstance().getEntry(this.url).getLastModified();
        this.parse();
    }

    public Content getContent() throws Exception {
        long recent = JetspeedDiskCache.getInstance().getEntry(this.url).getLastModified();
        if (recent == 0L || this.lastModified < recent) {
            this.parse();
        }
        return this.content;
    }

    public synchronized void save() throws Exception {
        DiskCacheEntry pde = JetspeedDiskCache.getInstance().getEntry(this.url);
        Writer filewriter = pde.getWriter();
        this.content.marshal(filewriter);
        filewriter.close();
    }

    public synchronized void parse() throws Exception {
        Reader stream = JetspeedDiskCache.getInstance().getEntry(this.url).getReader();
        this.content = Content.unmarshal(stream);
        stream.close();
    }
}

