/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.forward;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.jetspeed.services.forward.ForwardService;
import org.apache.jetspeed.services.forward.configuration.Forward;
import org.apache.jetspeed.services.forward.configuration.ForwardsConfiguration;
import org.apache.jetspeed.services.forward.configuration.Page;
import org.apache.jetspeed.services.forward.configuration.Pane;
import org.apache.jetspeed.services.forward.configuration.Portlet;
import org.apache.jetspeed.services.forward.configuration.PortletForward;
import org.apache.jetspeed.services.forward.configuration.QueryParam;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.xml.serialize.OutputFormat;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JetspeedForwardService
extends TurbineBaseService
implements ForwardService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedForwardService.class.getName());
    protected static final String CONFIG_MAPPING = "mapping";
    protected static final String CONFIG_DIRECTORY = "directory";
    protected String mapping = "/WEB-INF/conf/forwards-mapping.xml";
    protected String directory = "/WEB-INF/conf/forwards/";
    protected Mapping mapper = null;
    protected OutputFormat format = null;
    protected Map forwards = new HashMap();
    protected Map portletForwards = new TreeMap();
    protected static final String KEY_DELIMITER = ":";

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        try {
            ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("ForwardService");
            this.mapping = serviceConf.getString(CONFIG_MAPPING, this.mapping);
            this.directory = serviceConf.getString(CONFIG_DIRECTORY, this.directory);
            this.mapping = TurbineServlet.getRealPath((String)this.mapping);
            this.directory = TurbineServlet.getRealPath((String)this.directory);
            this.loadForwards();
        }
        catch (Exception e) {
            logger.error("ForwardService: Failed to load ", e);
        }
        this.setInit(true);
    }

    public void shutdown() {
    }

    public DynamicURI forward(RunData rundata, String forwardName) {
        return this.forwardInternal(rundata, forwardName, null, null);
    }

    public DynamicURI forwardDynamic(RunData rundata, String forwardName, Map parameters) {
        return this.forwardInternal(rundata, forwardName, null, parameters);
    }

    private DynamicURI forwardInternal(RunData rundata, String forwardName, Map staticParams, Map dynamicParams) {
        DynamicURI duri = null;
        Forward forward = null;
        try {
            JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
            int rootType = 102;
            int elementType = 102;
            String rootValue = null;
            String pageName = null;
            String elementValue = null;
            String actionName = null;
            String templateName = null;
            String mediaType = null;
            String language = null;
            String country = null;
            forward = (Forward)this.forwards.get(forwardName);
            if (null != forward) {
                Page page;
                Pane pane = forward.getPane();
                if (null != pane) {
                    elementValue = pane.getId();
                    elementType = 301;
                    if (elementValue == null) {
                        elementValue = pane.getName();
                        elementType = 302;
                    }
                } else {
                    Portlet portlet = forward.getPortlet();
                    if (null != portlet) {
                        elementValue = portlet.getId();
                        elementType = 303;
                        if (elementValue == null) {
                            elementValue = portlet.getName();
                            elementType = 304;
                        }
                        actionName = portlet.getAction();
                    }
                }
                if (null != (page = forward.getPage())) {
                    pageName = page.getName();
                    String user = page.getUser();
                    if (user != null) {
                        rootType = 203;
                        rootValue = user;
                    } else {
                        String role = page.getRole();
                        if (role != null) {
                            rootType = 202;
                            rootValue = role;
                        } else {
                            String group = page.getGroup();
                            if (group != null) {
                                rootType = 201;
                                rootValue = group;
                            } else {
                                rootType = 101;
                            }
                        }
                    }
                }
                duri = link.getLink(rootType, rootValue, pageName, elementType, elementValue, actionName, templateName, mediaType, language, country);
            } else {
                logger.error("Forward not found, going to Home Page:" + forwardName);
                duri = link.getHomePage();
            }
            if (null == duri) {
                duri = link.getPage();
            }
            Map baseQueryParams = null;
            if (null != forward) {
                baseQueryParams = forward.getQueryParams();
            }
            this.setQueryParams(duri, baseQueryParams, staticParams, dynamicParams);
            rundata.setRedirectURI(duri.toString());
            JetspeedLinkFactory.putInstance(link);
        }
        catch (Throwable t) {
            logger.error("Exception in Forward", t);
        }
        return duri;
    }

    private DynamicURI setQueryParams(DynamicURI duri, Map baseQueryParams, Map staticParams, Map dynamicParams) {
        if (baseQueryParams == null && staticParams == null && dynamicParams == null) {
            return duri;
        }
        Iterator<Object> it = null;
        if (baseQueryParams != null) {
            for (QueryParam queryParam : baseQueryParams.values()) {
                if (null != staticParams && staticParams.containsKey(queryParam.getName()) || null != dynamicParams && dynamicParams.containsKey(queryParam.getName())) continue;
                duri.addQueryData(queryParam.getName(), queryParam.getValue());
            }
        }
        if (staticParams != null) {
            for (QueryParam queryParam : staticParams.values()) {
                if (null != dynamicParams && dynamicParams.containsKey(queryParam.getName())) continue;
                duri.addQueryData(queryParam.getName(), queryParam.getValue());
            }
        }
        if (dynamicParams != null) {
            for (Map.Entry entry : dynamicParams.entrySet()) {
                duri.addQueryData((String)entry.getKey(), entry.getValue());
            }
        }
        return duri;
    }

    private void dumpMap(String mapName, Map map) {
        System.out.println("----------- MAP: " + mapName);
        for (QueryParam qparam : map.values()) {
            System.out.println("name = " + qparam.getName() + ", value = " + qparam.getValue());
        }
    }

    public DynamicURI forward(RunData rundata, String portlet, String target) {
        return this.forwardDynamic(rundata, portlet, target, null);
    }

    public DynamicURI forwardDynamic(RunData rundata, String portlet, String target, Map parameters) {
        try {
            Map staticParams = null;
            String forwardName = "";
            String key = this.makePortletForwardKey(portlet, target);
            PortletForward pf = (PortletForward)this.portletForwards.get(key);
            if (null != pf) {
                staticParams = pf.getQueryParams();
                Forward forward = (Forward)this.forwards.get(pf.getForward());
                if (null != forward) {
                    forwardName = forward.getName();
                }
            }
            return this.forwardInternal(rundata, forwardName, staticParams, parameters);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new DynamicURI();
        }
    }

    public Collection getForwards() {
        return this.forwards.values();
    }

    public Collection getPortletForwards() {
        return this.portletForwards.values();
    }

    public Forward getForward(String forwardName) {
        return (Forward)this.forwards.get(forwardName);
    }

    public PortletForward getPortletForward(String portlet, String target) {
        return (PortletForward)this.portletForwards.get(this.makePortletForwardKey(portlet, target));
    }

    protected void loadForwards() throws InitializationException {
        this.format = new OutputFormat();
        this.format.setIndenting(true);
        this.format.setIndent(4);
        File map = new File(this.mapping);
        if (map.exists() && map.isFile() && map.canRead()) {
            try {
                this.mapper = new Mapping();
                InputSource is = new InputSource(new FileReader(map));
                is.setSystemId(this.mapping);
                this.mapper.loadMapping(is);
            }
            catch (Exception e) {
                String msg = "ForwardService: Error in castor mapping creation";
                logger.error(msg, e);
                throw new InitializationException(msg, (Throwable)e);
            }
        } else {
            String msg = "ForwardService: Mapping not found or not a file or unreadable: " + this.mapping;
            logger.error(msg);
            throw new InitializationException(msg);
        }
        try {
            File directory = new File(this.directory);
            File[] files = directory.listFiles();
            for (int ix = 0; ix < files.length; ++ix) {
                if (files[ix].isDirectory()) continue;
                this.loadForwardConfiguration(files[ix]);
            }
        }
        catch (Exception e) {
            String msg = "ForwardService: Fatal error loading Forward configurations";
            logger.error(msg, e);
            throw new InitializationException(msg, (Throwable)e);
        }
    }

    protected String makePortletForwardKey(String portlet, String target) {
        StringBuffer key = new StringBuffer(portlet);
        key.append(KEY_DELIMITER);
        key.append(target);
        return key.toString();
    }

    protected void loadForwardConfiguration(File file) {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(file);
            Unmarshaller unmarshaller = new Unmarshaller(this.mapper);
            ForwardsConfiguration configuration = (ForwardsConfiguration)unmarshaller.unmarshal((Node)doc);
            for (Forward forward : configuration.getForwards()) {
                if (this.forwards.containsKey(forward.getName())) {
                    logger.error("ForwardService: already contains Forward key: " + forward.getName());
                } else {
                    this.forwards.put(forward.getName(), forward);
                }
                this.resyncParamMap(forward.getQueryParams());
            }
            for (PortletForward pf : configuration.getPortletForwards()) {
                String key = this.makePortletForwardKey(pf.getPortlet(), pf.getTarget());
                if (this.portletForwards.containsKey(key)) {
                    logger.error("ForwardService: already contains portletForward key: " + key);
                    continue;
                }
                this.portletForwards.put(key, pf);
                this.resyncParamMap(pf.getQueryParams());
            }
        }
        catch (Throwable t) {
            logger.error("ForwardService: Could not unmarshal: " + file, t);
        }
    }

    private void resyncParamMap(Map map) {
        ArrayList<QueryParam> list = new ArrayList<QueryParam>(map.size());
        for (QueryParam qp : map.values()) {
            list.add(qp);
        }
        map.clear();
        for (QueryParam qp : list) {
            map.put(qp.getName(), qp);
        }
    }
}

