/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.portletfactory;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.BasePortletConfig;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.portletcache.Cacheable;
import org.apache.jetspeed.services.portletcache.PortletCache;
import org.apache.jetspeed.services.portletfactory.PortletFactoryService;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.util.MetaData;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedPortletFactoryService
extends TurbineBaseService
implements PortletFactoryService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPortletFactoryService.class.getName());
    private boolean enableCache = false;
    private JetspeedRunDataService runDataService = null;

    public void init(ServletConfig conf) throws InitializationException {
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PortletFactory");
        this.enableCache = serviceConf.getBoolean("enable.cache", true);
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.setInit(true);
    }

    public Portlet getPortlet(Entry entry) throws PortletException {
        PortletEntry regEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, entry.getParent());
        if (regEntry == null) {
            throw new PortletException("PortletFactory: unknown portlet entry in Registry: " + entry.getParent());
        }
        if ("abstract".equals(regEntry.getType())) {
            throw new PortletException("PortletFactory: can't instanciate abstract registry entry: " + regEntry.getName());
        }
        PortletConfig pc = this.getPortletConfig(regEntry, entry.getId());
        pc.getInitParameters().putAll(JetspeedPortletFactoryService.getParameters(entry));
        pc.setPortletSkin(PortalToolkit.getSkin(entry.getSkin()));
        pc.setSecurityRef(this.getSecurityReference(entry, regEntry));
        return this.getPortlet(this.getClassname(regEntry), pc, entry.getId());
    }

    public Portlet getPortlet(String name, String id) throws PortletException {
        PortletEntry regEntry = (PortletEntry)Registry.getEntry(Registry.PORTLET, name);
        if (regEntry == null) {
            throw new PortletException("PortletFactory: unknown portlet entry in Registry: " + name);
        }
        if ("abstract".equals(regEntry.getType())) {
            throw new PortletException("PortletFactory: can't instanciate abstract registry entry: " + name);
        }
        PortletConfig pc = this.getPortletConfig(regEntry, id);
        return this.getPortlet(this.getClassname(regEntry), pc, null);
    }

    protected Portlet getPortlet(String classname, PortletConfig pc, String id) throws PortletException {
        long begin = System.currentTimeMillis();
        Portlet portlet = null;
        Class<?> portletClass = null;
        String handle = null;
        try {
            portletClass = Class.forName(classname);
        }
        catch (Exception e) {
            throw new PortletException("PortletFactory: Unable to load class " + classname);
        }
        if (this.enableCache) {
            try {
                Class[] signatureParams = new Class[]{Object.class};
                Object[] methodParams = new Object[]{pc};
                handle = (String)portletClass.getMethod("getHandle", signatureParams).invoke(null, methodParams);
                handle = String.valueOf(classname.hashCode()) + handle;
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                logger.error("PortletFactory: failed to get cache handle", e);
            }
        }
        try {
            if (this.enableCache && handle != null && (portlet = (Portlet)((Object)PortletCache.getCacheable(handle))) != null && ((Cacheable)((Object)portlet)).getExpire().isExpired()) {
                logger.info("The portlet (" + handle + ") is expired");
                PortletCache.removeCacheable(handle);
                if (logger.isDebugEnabled()) {
                    logger.debug("After removal of object(" + handle + ").");
                }
                portlet = null;
            }
            if (portlet != null && portlet instanceof Cacheable && !((Cacheable)((Object)portlet)).getExpire().isExpired()) {
                portlet.setPortletConfig(pc);
                portlet.setID(id);
                portlet.setName(pc.getName());
                MetaData meta = pc.getMetainfo();
                if (meta != null) {
                    if (!MetaData.DEFAULT_TITLE.equals(meta.getTitle())) {
                        portlet.setTitle(meta.getTitle());
                    }
                    if (!MetaData.DEFAULT_DESCRIPTION.equals(meta.getDescription())) {
                        portlet.setDescription(meta.getDescription());
                    }
                }
                long milliseconds = System.currentTimeMillis() - begin;
                if (logger.isDebugEnabled()) {
                    logger.debug("PortletFactory.getPortlet(): found in cache in " + milliseconds + " ms - handle: " + handle);
                }
                return PortletWrapper.wrap(portlet);
            }
            portlet = (Portlet)portletClass.newInstance();
        }
        catch (Throwable t) {
            logger.error("Throwable", t);
            throw new PortletException(t.getMessage());
        }
        String title = null;
        String description = null;
        MetaData metainfo = pc.getMetainfo();
        if (metainfo != null) {
            title = metainfo.getTitle();
            description = metainfo.getDescription();
        }
        portlet.setID(id);
        portlet.setName(pc.getName());
        portlet.setPortletConfig(pc);
        portlet.setCreationTime(System.currentTimeMillis());
        portlet.init();
        if (metainfo != null) {
            if (!MetaData.DEFAULT_TITLE.equals(title)) {
                portlet.setTitle(title);
            }
            if (!MetaData.DEFAULT_DESCRIPTION.equals(description)) {
                portlet.setDescription(description);
            }
        }
        if (this.enableCache && portlet instanceof Cacheable) {
            ((Cacheable)((Object)portlet)).setHandle(handle);
            PortletCache.addCacheable((Cacheable)((Object)portlet));
            ((Cacheable)((Object)portlet)).getExpire();
        }
        long milliseconds = System.currentTimeMillis() - begin;
        if (logger.isDebugEnabled()) {
            logger.debug("PortletFactory.getPortlet(): constructed in " + milliseconds + " ms - handle: " + handle);
        }
        return PortletWrapper.wrap(portlet);
    }

    protected PortletConfig getPortletConfig(PortletEntry portletEntry, String id) {
        Profile profile;
        JetspeedRunData rundata;
        HashMap map = new HashMap();
        map.putAll(portletEntry.getParameterMap());
        BasePortletConfig pc = new BasePortletConfig();
        pc.setName(portletEntry.getName());
        this.addParentInitParameters(portletEntry, map);
        pc.setInitParameters(map);
        pc.setMetainfo(JetspeedPortletFactoryService.getMetaData(portletEntry));
        pc.setURL(portletEntry.getURL());
        pc.setCachedOnURL(portletEntry.isCachedOnURL());
        pc.setSecurityRef(this.getSecurityReference(null, portletEntry));
        if (this.runDataService != null && (rundata = this.runDataService.getCurrentRunData()) != null && (profile = rundata.getProfile()) != null) {
            pc.setPageId(profile.getId());
        }
        pc.setPortletId(id);
        return pc;
    }

    protected static Map getParameters(Entry entry) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        Parameter[] props = entry.getParameter();
        for (int i = 0; i < props.length; ++i) {
            hash.put(props[i].getName(), props[i].getValue());
        }
        return hash;
    }

    protected static MetaData getMetaData(Entry entry) {
        PortletEntry parent;
        MetaData data = new MetaData();
        MetaInfo meta = entry.getMetaInfo();
        if (meta != null) {
            if (meta.getTitle() != null) {
                data.setTitle(meta.getTitle());
            }
            if (meta.getDescription() != null) {
                data.setDescription(meta.getDescription());
            }
            if (meta.getImage() != null) {
                data.setImage(meta.getImage());
            }
        }
        if (entry.getParent() != null && (parent = (PortletEntry)Registry.getEntry(Registry.PORTLET, entry.getParent())) != null) {
            MetaData parentData = JetspeedPortletFactoryService.getMetaData(parent);
            parentData.merge(data);
            return parentData;
        }
        return data;
    }

    protected static MetaData getMetaData(PortletEntry entry) {
        MetaData data = new MetaData();
        if (entry.getTitle() != null) {
            data.setTitle(entry.getTitle());
        }
        if (entry.getDescription() != null) {
            data.setDescription(entry.getDescription());
        }
        if (entry.getMetaInfo() != null && entry.getMetaInfo().getImage() != null) {
            data.setImage(entry.getMetaInfo().getImage());
        }
        return data;
    }

    protected static PortletEntry getParentEntry(PortletEntry entry) {
        PortletEntry result = null;
        String parent = entry.getParent();
        if (parent != null) {
            result = (PortletEntry)Registry.getEntry(Registry.PORTLET, parent);
        }
        return result;
    }

    protected String getClassname(PortletEntry entry) {
        PortletEntry parent;
        String className = entry.getClassname();
        if (className == null && (parent = JetspeedPortletFactoryService.getParentEntry(entry)) != null) {
            className = this.getClassname(parent);
        }
        return className;
    }

    protected void addParentInitParameters(PortletEntry entry, Map hash) {
        PortletEntry parent = JetspeedPortletFactoryService.getParentEntry(entry);
        if (parent != null) {
            Map parentMap = parent.getParameterMap();
            Iterator names = parent.getParameterNames();
            while (names.hasNext()) {
                String key = (String)names.next();
                if (hash.containsKey(key)) continue;
                hash.put(key, parentMap.get(key));
            }
            this.addParentInitParameters(parent, hash);
        }
    }

    protected SecurityReference getSecurityReference(Entry entry, PortletEntry pEntry) {
        if (this.runDataService == null) {
            this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        }
        JetspeedRunData rundata = this.runDataService.getCurrentRunData();
        return JetspeedSecurity.getSecurityReference(entry, rundata);
    }
}

