/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.psmlmanager.db;

import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.dbpsml.JetspeedGroupProfile;
import org.apache.jetspeed.om.dbpsml.JetspeedGroupProfilePeer;
import org.apache.jetspeed.om.dbpsml.JetspeedRoleProfile;
import org.apache.jetspeed.om.dbpsml.JetspeedRoleProfilePeer;
import org.apache.jetspeed.om.dbpsml.JetspeedUserProfile;
import org.apache.jetspeed.om.dbpsml.JetspeedUserProfilePeer;
import org.apache.jetspeed.om.profile.BasePSMLDocument;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedGroupFactory;
import org.apache.jetspeed.om.security.JetspeedRoleFactory;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUserFactory;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.psmlmanager.PsmlManagerService;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.apache.jetspeed.services.psmlmanager.db.DatabasePsmlManager;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.torque.Torque;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.exolab.castor.mapping.Mapping;
import org.xml.sax.InputSource;

public class DatabasePsmlManagerService
extends TurbineBaseService
implements DatabasePsmlManager {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DatabasePsmlManagerService.class.getName());
    private Map psmlCache = new HashMap();
    private CacheRefresher refresher = null;
    private long refreshRate;
    private static final String REFRESH_RATE = "refresh-rate";
    private static final long DEFAULT_REFRESH_RATE = 28800000L;
    private boolean cachingOn;
    private static final String CACHING_ON = "caching-on";
    private static final boolean DEFAULT_CACHING_ON = false;
    private static final String POOL_NAME = "database";
    private PsmlManagerService consumer = null;
    public static final String DEFAULT_MAPPING = "${webappRoot}/WEB-INF/conf/psml-mapping.xml";
    String mapFile = null;
    private Mapping mapping = null;
    private String poolName = null;

    public void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        logger.info("Initializing DatabasePsmlManagerService...");
        this.initConfiguration(conf);
        logger.info("Done initializing DatabasePsmlManagerService.");
    }

    private void initConfiguration(ServletConfig conf) throws InitializationException {
        TurbineServices.getInstance().initService("ServletService", (Object)conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PsmlManager");
        try {
            String value = serviceConf.getString(REFRESH_RATE);
            this.refreshRate = 28800000L;
            try {
                this.refreshRate = Long.parseLong(value);
            }
            catch (Exception e) {
                logger.warn("DatabasePsmlManagerService: error in refresh-rate configuration: using default");
            }
            this.poolName = serviceConf.getString(POOL_NAME);
            value = serviceConf.getString(CACHING_ON);
            this.cachingOn = false;
            try {
                this.cachingOn = value.equals("true");
            }
            catch (Exception e) {
                logger.warn("DatabasePsmlManagerService: error in caching-on configuration: using default");
            }
            this.mapFile = serviceConf.getString("mapping", DEFAULT_MAPPING);
            this.mapFile = TurbineServlet.getRealPath((String)this.mapFile);
            this.loadMapping();
        }
        catch (Throwable t) {
            logger.error(this + ".init:", t);
            throw new InitializationException("Exception initializing DatabasePsmlManagerService" + t);
        }
        if (this.cachingOn) {
            this.refresher = new CacheRefresher();
            this.refresher.start();
        }
    }

    public void init() throws InitializationException {
        this.setInit(true);
    }

    protected void loadMapping() throws InitializationException {
        if (this.mapFile != null) {
            File map = new File(this.mapFile);
            if (logger.isDebugEnabled()) {
                logger.debug("Loading psml mapping file " + this.mapFile);
            }
            if (map.exists() && map.isFile() && map.canRead()) {
                try {
                    this.mapping = new Mapping();
                    InputSource is = new InputSource(new FileReader(map));
                    is.setSystemId(this.mapFile);
                    this.mapping.loadMapping(is);
                }
                catch (Exception e) {
                    logger.error("Error in psml mapping creation", e);
                    throw new InitializationException("Error in mapping", (Throwable)e);
                }
            } else {
                throw new InitializationException("PSML Mapping not found or not a file or unreadable: " + this.mapFile);
            }
        }
    }

    public void shutdown() {
        if (this.refresher != null) {
            this.refresher.setDone(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String locatorToString(ProfileLocator locator) {
        StringBuffer keybuf = new StringBuffer();
        JetspeedUser user = locator.getUser();
        Role role = locator.getRole();
        Group group = locator.getGroup();
        String name = locator.getName();
        String mediaType = locator.getMediaType();
        String country = locator.getCountry();
        String language = locator.getLanguage();
        DatabasePsmlManagerService databasePsmlManagerService = this;
        synchronized (databasePsmlManagerService) {
            if (user != null) {
                keybuf.append("User:").append(user.getUserName());
            } else if (group != null) {
                keybuf.append("Group:").append(group.getName());
            } else if (role != null) {
                keybuf.append("Role:").append(role.getName());
            }
            if (name != null) {
                keybuf.append('$').append("Page:").append(name);
            }
            if (mediaType != null) {
                keybuf.append('$').append("MediaType:").append(mediaType);
            }
            if (country != null && !country.equals("-1")) {
                keybuf.append('$').append("Country:").append(country);
            }
            if (language != null && !language.equals("-1")) {
                keybuf.append('$').append("Language:").append(language);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DatabasePsmlManagerService: Returning locator string: " + keybuf.toString());
        }
        return keybuf.toString();
    }

    private ProfileLocator stringToLocator(String locstr) throws Exception {
        ProfileLocator locator = Profiler.createLocator();
        String entity = null;
        if (logger.isDebugEnabled()) {
            logger.debug("DatabasePsmlManagerService: Creating locator for string: " + locstr);
        }
        StringTokenizer dollarTokens = new StringTokenizer(locstr, "$");
        while (dollarTokens.hasMoreTokens()) {
            String dollarToken = dollarTokens.nextToken().trim();
            StringTokenizer colonTokens = new StringTokenizer(dollarToken, ":");
            String colonToken = colonTokens.nextToken();
            if (colonToken.equals("User")) {
                entity = colonTokens.nextToken().trim();
                locator.setUser(JetspeedSecurity.getUser(entity));
                continue;
            }
            if (colonToken.equals("Group")) {
                entity = colonTokens.nextToken().trim();
                locator.setGroup(JetspeedSecurity.getGroup(entity));
                continue;
            }
            if (colonToken.equals("Role")) {
                entity = colonTokens.nextToken().trim();
                locator.setRole(JetspeedSecurity.getRole(entity));
                continue;
            }
            if (colonToken.equals("Page")) {
                entity = colonTokens.nextToken().trim();
                locator.setName(entity);
                continue;
            }
            if (colonToken.equals("MediaType")) {
                entity = colonTokens.nextToken().trim();
                locator.setMediaType(entity);
                continue;
            }
            if (colonToken.equals("Country")) {
                entity = colonTokens.nextToken().trim();
                locator.setCountry(entity);
                continue;
            }
            if (!colonToken.equals("Language")) continue;
            entity = colonTokens.nextToken().trim();
            locator.setLanguage(entity);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DatabasePsmlManagerService: Returning locator for string: " + this.locatorToString(locator));
        }
        return locator;
    }

    public PSMLDocument getDocument(String name) {
        logger.warn("*** NOT SUPPORTED: GETDOC FROM DATABASE PSML MANAGER!!!");
        return null;
    }

    public boolean saveDocument(String fileOrUrl, PSMLDocument doc) {
        logger.warn("*** NOT SUPPORTED: SAVING DOC FROM DATABASE PSML MANAGER!!!");
        return false;
    }

    public boolean saveDocument(PSMLDocument doc) {
        logger.warn("*** NOT SUPPORTED: SAVING DOC FROM DATABASE PSML MANAGER!!!");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PSMLDocument getDocument(ProfileLocator locator) {
        if (locator == null) {
            String message = "PSMLManager: Must specify a locator";
            logger.warn("DatabasePsmlManagerService.getDocument: " + message);
            throw new IllegalArgumentException(message);
        }
        PSMLDocument psmldoc = null;
        String locStr = this.locatorToString(locator);
        boolean inCache = false;
        if (this.cachingOn) {
            Map map = this.psmlCache;
            synchronized (map) {
                inCache = this.psmlCache.containsKey(locStr);
                if (inCache) {
                    psmldoc = (PSMLDocument)this.psmlCache.get(locStr);
                }
            }
            if (inCache) {
                return psmldoc;
            }
        }
        try {
            return this.refresh(locator);
        }
        catch (Exception e) {
            logger.warn("DatabasePSMLManagerService.getDocument: exception:", e);
            throw new RuntimeException("Could not get profile from DB");
        }
    }

    public PSMLDocument createDocument(Profile profile) {
        return this.createOrSaveDocument(profile, 1);
    }

    public boolean store(Profile profile) {
        return this.createOrSaveDocument(profile, 2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSMLDocument createOrSaveDocument(Profile profile, int operation) {
        if (profile == null) {
            String message = "PSMLManager: Must specify a profile";
            logger.warn("DatabasePsmlManagerService.createOrSaveDocument: " + message);
            throw new IllegalArgumentException(message);
        }
        JetspeedUser user = profile.getUser();
        Role role = profile.getRole();
        Group group = profile.getGroup();
        String tableName = null;
        Connection dbCon = this.getDbConnection();
        try {
            Object object;
            if (user != null) {
                tableName = "JETSPEED_USER_PROFILE";
                if (operation == 1) {
                    new JetspeedUserProfilePeer().insert(profile, dbCon);
                } else if (operation == 2) {
                    new JetspeedUserProfilePeer().update(profile, dbCon);
                }
            } else if (role != null) {
                tableName = "JETSPEED_ROLE_PROFILE";
                if (operation == 1) {
                    new JetspeedRoleProfilePeer().insert(profile, dbCon);
                } else if (operation == 2) {
                    new JetspeedRoleProfilePeer().update(profile, dbCon);
                }
            } else if (group != null) {
                tableName = "JETSPEED_GROUP_PROFILE";
                if (operation == 1) {
                    new JetspeedGroupProfilePeer().insert(profile, dbCon);
                } else if (operation == 2) {
                    new JetspeedGroupProfilePeer().update(profile, dbCon);
                }
            }
            if (this.cachingOn) {
                object = this.psmlCache;
                synchronized (object) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("DatabasePsmlManagerService.createOrSaveDocument: caching document: profile: " + this.locatorToString(profile));
                    }
                    this.psmlCache.put(this.locatorToString(profile), profile.getDocument());
                }
            }
            object = profile.getDocument();
            return object;
        }
        catch (Exception e) {
            logger.warn("DatabasePsmlManagerService.createOrSaveDocument: profile: " + profile + " tableName: " + tableName, e);
            throw new RuntimeException("Could not create new profile in DB");
        }
        finally {
            this.releaseDbConnection(dbCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(ProfileLocator locator) {
        block14: {
            if (locator == null) {
                String message = "PSMLManager: Must specify a locator";
                logger.warn("DatabasePsmlManagerService.removeDocument: " + message);
                throw new IllegalArgumentException(message);
            }
            JetspeedUser user = locator.getUser();
            Role role = locator.getRole();
            Group group = locator.getGroup();
            String tableName = null;
            Connection dbCon = this.getDbConnection();
            try {
                if (user != null) {
                    new JetspeedUserProfilePeer().delete(locator, dbCon);
                    tableName = "JETSPEED_USER_PROFILE";
                } else if (role != null) {
                    new JetspeedRoleProfilePeer().delete(locator, dbCon);
                    tableName = "JETSPEED_ROLE_PROFILE";
                } else if (group != null) {
                    new JetspeedGroupProfilePeer().delete(locator, dbCon);
                    tableName = "JETSPEED_GROUP_PROFILE";
                }
                if (!this.cachingOn) break block14;
                Map map = this.psmlCache;
                synchronized (map) {
                    this.psmlCache.remove(this.locatorToString(locator));
                }
            }
            catch (Exception e) {
                logger.warn("DatabasePsmlManagerService.removeDocument: profile: " + this.locatorToString(locator) + " tableName: " + tableName, e);
                throw new RuntimeException("Could not delete profile for given locator from DB");
            }
            finally {
                this.releaseDbConnection(dbCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator query(QueryLocator locator) {
        if (locator == null) {
            String message = "PSMLManager: Must specify a locator";
            logger.warn("DatabasePsmlManagerService.query: " + message);
            throw new IllegalArgumentException(message);
        }
        Connection dbCon = this.getDbConnection();
        try {
            List userData = null;
            List groupData = null;
            List roleData = null;
            int queryMode = locator.getQueryMode();
            List list = new ArrayList();
            switch (queryMode) {
                case 1: {
                    userData = new JetspeedUserProfilePeer().selectOrdered(locator, dbCon);
                    if (userData == null) break;
                    list = this.getProfiles(userData);
                    break;
                }
                case 4: {
                    groupData = new JetspeedGroupProfilePeer().selectOrdered(locator, dbCon);
                    if (groupData == null) break;
                    list = this.getProfiles(groupData);
                    break;
                }
                case 2: {
                    roleData = new JetspeedRoleProfilePeer().selectOrdered(locator, dbCon);
                    if (roleData == null) break;
                    list = this.getProfiles(roleData);
                    break;
                }
                default: {
                    userData = new JetspeedUserProfilePeer().selectOrdered(locator, dbCon);
                    if (userData != null) {
                        list.addAll(this.getProfiles(userData));
                    }
                    if ((groupData = new JetspeedGroupProfilePeer().selectOrdered(locator, dbCon)) != null) {
                        list.addAll(this.getProfiles(groupData));
                    }
                    if ((roleData = new JetspeedRoleProfilePeer().selectOrdered(locator, dbCon)) == null) break;
                    list.addAll(this.getProfiles(roleData));
                }
            }
            Iterator iterator = list.iterator();
            return iterator;
        }
        catch (Exception e) {
            logger.warn("DatabasePsmlManagerService.query: exception", e);
        }
        finally {
            this.releaseDbConnection(dbCon);
        }
        return new ArrayList().iterator();
    }

    private List getProfiles(List data) {
        ArrayList<Profile> list = new ArrayList<Profile>();
        for (int i = 0; i < data.size(); ++i) {
            Object obj = data.get(i);
            Portlets portlets = null;
            if (obj instanceof JetspeedUserProfile) {
                portlets = DBUtils.bytesToPortlets(((JetspeedUserProfile)((Object)obj)).getProfile(), this.mapping);
                list.add(this.createUserProfile((JetspeedUserProfile)((Object)obj), portlets));
                continue;
            }
            if (obj instanceof JetspeedGroupProfile) {
                portlets = DBUtils.bytesToPortlets(((JetspeedGroupProfile)((Object)obj)).getProfile(), this.mapping);
                list.add(this.createGroupProfile((JetspeedGroupProfile)((Object)obj), portlets));
                continue;
            }
            if (!(obj instanceof JetspeedRoleProfile)) continue;
            portlets = DBUtils.bytesToPortlets(((JetspeedRoleProfile)((Object)obj)).getProfile(), this.mapping);
            list.add(this.createRoleProfile((JetspeedRoleProfile)((Object)obj), portlets));
        }
        return list;
    }

    private PSMLDocument getPSMLDocument(String page, Portlets portlets) {
        BasePSMLDocument psmldoc = new BasePSMLDocument();
        psmldoc.setName(page);
        psmldoc.setPortlets(portlets);
        return psmldoc;
    }

    public PSMLDocument getDocument(List locators) {
        if (locators == null) {
            String message = "PSMLManager: Must specify a list of locators";
            logger.warn("DatabasePsmlManagerService.getDocument: " + message);
            throw new IllegalArgumentException(message);
        }
        for (int i = 0; i < locators.size(); ++i) {
            PSMLDocument psmldoc = this.getDocument((ProfileLocator)locators.get(i));
            if (psmldoc == null) continue;
            return psmldoc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PSMLDocument refresh(ProfileLocator locator) {
        if (locator == null) {
            String message = "PSMLManager: Must specify a locator";
            logger.warn("DatabasePsmlManagerService.refresh: " + message);
            throw new IllegalArgumentException(message);
        }
        JetspeedUser user = locator.getUser();
        Role role = locator.getRole();
        Group group = locator.getGroup();
        String tableName = null;
        List records = null;
        Portlets portlets = null;
        PSMLDocument psmldoc = null;
        String page = null;
        Connection dbCon = this.getDbConnection();
        try {
            if (user != null) {
                tableName = "JETSPEED_USER_PROFILE";
                records = new JetspeedUserProfilePeer().select(locator, dbCon);
                for (JetspeedUserProfile uprofile : records) {
                    page = uprofile.getPage();
                    portlets = DBUtils.bytesToPortlets(uprofile.getProfile(), this.mapping);
                }
            } else if (role != null) {
                tableName = "JETSPEED_ROLE_PROFILE";
                records = new JetspeedRoleProfilePeer().select(locator, dbCon);
                for (JetspeedRoleProfile rprofile : records) {
                    page = rprofile.getPage();
                    portlets = DBUtils.bytesToPortlets(rprofile.getProfile(), this.mapping);
                }
            } else if (group != null) {
                tableName = "JETSPEED_GROUP_PROFILE";
                records = new JetspeedGroupProfilePeer().select(locator, dbCon);
                for (JetspeedGroupProfile gprofile : records) {
                    page = gprofile.getPage();
                    portlets = DBUtils.bytesToPortlets(gprofile.getProfile(), this.mapping);
                }
            }
            if (page != null && portlets != null) {
                Object iterator;
                psmldoc = this.getPSMLDocument(page, portlets);
                if (this.cachingOn) {
                    iterator = this.psmlCache;
                    synchronized (iterator) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("DatabasePsmlManagerService.refresh: caching document: profile: " + this.locatorToString(locator));
                        }
                        this.psmlCache.put(this.locatorToString(locator), psmldoc);
                    }
                }
                iterator = psmldoc;
                return iterator;
            }
            if (this.cachingOn) {
                this.psmlCache.put(this.locatorToString(locator), null);
                if (logger.isDebugEnabled()) {
                    logger.debug("DatabasePsmlManagerService.refresh: caching 'document not found': profile: " + this.locatorToString(locator));
                }
            }
        }
        catch (Exception e) {
            logger.warn("DatabasePsmlManagerService.refresh: profile: " + this.locatorToString(locator) + " tableName: " + tableName, e);
            throw new RuntimeException("Could not refresh profile from DB");
        }
        finally {
            this.releaseDbConnection(dbCon);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DatabasePsmlManagerService.refresh: no document found: profile: " + this.locatorToString(locator));
        }
        return null;
    }

    public void removeUserDocuments(JetspeedUser user) {
        Connection dbCon = this.getDbConnection();
        try {
            if (user != null) {
                new JetspeedUserProfilePeer().delete(user, dbCon);
            }
        }
        catch (Exception e) {
            logger.warn("DatabasePsmlManagerService.removeUserDocuments: exception:", e);
            throw new RuntimeException("Could not delete documents for given user from DB");
        }
        finally {
            this.releaseDbConnection(dbCon);
        }
    }

    public void removeRoleDocuments(Role role) {
        Connection dbCon = this.getDbConnection();
        try {
            if (role != null) {
                new JetspeedRoleProfilePeer().delete(role, dbCon);
            }
        }
        catch (Exception e) {
            logger.warn("DatabasePsmlManagerService.removeRoleDocuments: exception:", e);
            throw new RuntimeException("Could not delete documents for given role from DB");
        }
        finally {
            this.releaseDbConnection(dbCon);
        }
    }

    public void removeGroupDocuments(Group group) {
        Connection dbCon = this.getDbConnection();
        try {
            if (group != null) {
                new JetspeedGroupProfilePeer().delete(group, dbCon);
            }
        }
        catch (Exception e) {
            logger.warn("DatabasePsmlManagerService.removeGroupDocuments: exception:", e);
            throw new RuntimeException("Could not delete documents for given group from DB");
        }
        finally {
            this.releaseDbConnection(dbCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int export(PsmlManagerService consumer, QueryLocator locator) {
        Iterator profiles = null;
        int count = 0;
        try {
            this.consumer = consumer;
            profiles = this.query(locator);
            while (profiles.hasNext()) {
                Profile profile = (Profile)profiles.next();
                try {
                    consumer.createDocument(profile);
                    ++count;
                }
                catch (Exception ex) {
                    try {
                        consumer.store(profile);
                        ++count;
                    }
                    catch (Exception e) {
                        logger.warn("DatabasePsmlManagerService.export: profile: " + profile, ex);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("DatabasePsmlManagerService.export: exception:", e);
        }
        return count;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Profile createUserProfile(JetspeedUserProfile entity, Portlets portlets) {
        Profile profile = Profiler.createProfile();
        try {
            JetspeedUser user = JetspeedSecurity.getUser(entity.getUserName());
            if (null == user) {
                user = JetspeedUserFactory.getInstance();
                user.setUserName(entity.getUserName());
            }
            profile.setUser(user);
            profile.setMediaType(entity.getMediaType());
            profile.setLanguage(entity.getLanguage());
            profile.setCountry(entity.getCountry());
            profile.setName(entity.getPage());
            profile.setDocument(this.getPSMLDocument(entity.getPage(), portlets));
        }
        catch (JetspeedSecurityException e) {
            // empty catch block
        }
        return profile;
    }

    public Profile createGroupProfile(JetspeedGroupProfile entity, Portlets portlets) {
        Profile profile = Profiler.createProfile();
        try {
            Group group = JetspeedSecurity.getGroup(entity.getGroupName());
            if (null == group) {
                group = JetspeedGroupFactory.getInstance();
                group.setName(entity.getGroupName());
            }
            profile.setGroup(group);
            profile.setMediaType(entity.getMediaType());
            profile.setLanguage(entity.getLanguage());
            profile.setCountry(entity.getCountry());
            profile.setName(entity.getPage());
            profile.setDocument(this.getPSMLDocument(entity.getPage(), portlets));
        }
        catch (JetspeedSecurityException e) {
            // empty catch block
        }
        return profile;
    }

    public Profile createRoleProfile(JetspeedRoleProfile entity, Portlets portlets) {
        Profile profile = Profiler.createProfile();
        try {
            Role role = JetspeedSecurity.getRole(entity.getRoleName());
            if (null == role) {
                role = JetspeedRoleFactory.getInstance();
                role.setName(entity.getRoleName());
            }
            profile.setRole(role);
            profile.setMediaType(entity.getMediaType());
            profile.setLanguage(entity.getLanguage());
            profile.setCountry(entity.getCountry());
            profile.setName(entity.getPage());
            profile.setDocument(this.getPSMLDocument(entity.getPage(), portlets));
        }
        catch (JetspeedSecurityException e) {
            // empty catch block
        }
        return profile;
    }

    private Connection getDbConnection() {
        try {
            if (this.poolName == null) {
                return Torque.getConnection();
            }
            return Torque.getConnection((String)this.poolName);
        }
        catch (Exception e) {
            logger.warn("DatabasePsmlManagerService.getDbConnection: exception: " + e);
            return null;
        }
    }

    private void releaseDbConnection(Connection connection) {
        Torque.closeConnection((Connection)connection);
    }

    class CacheRefresher
    extends Thread {
        private boolean done = false;

        CacheRefresher() {
            this.setDaemon(true);
            this.setPriority(2);
        }

        void setDone(boolean done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                try {
                    while (!this.done) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Cache Refresher thread sleeping now!");
                        }
                        CacheRefresher.sleep(DatabasePsmlManagerService.this.refreshRate);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Cache Refresher thread working now!");
                        }
                        try {
                            CacheRefresher cacheRefresher = this;
                            synchronized (cacheRefresher) {
                                for (String locator : DatabasePsmlManagerService.this.psmlCache.keySet()) {
                                    PSMLDocument doc = DatabasePsmlManagerService.this.refresh(DatabasePsmlManagerService.this.stringToLocator(locator));
                                    DatabasePsmlManagerService.this.psmlCache.put(locator, doc);
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.warn("DatabasePsmlManagerService.CacheRefresher: Error in cache refresher...", e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug("DatabasePsmlManagerService.CacheRefresher: recieved interruption, aborting.");
                }
            }
        }
    }
}

