/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.turbine;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.om.security.turbine.TurbineGroup;
import org.apache.jetspeed.om.security.turbine.TurbineGroupPeer;
import org.apache.jetspeed.om.security.turbine.TurbineUserGroupRole;
import org.apache.jetspeed.om.security.turbine.TurbineUserGroupRolePeer;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.GroupException;
import org.apache.jetspeed.services.security.GroupManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.torque.Torque;
import org.apache.torque.om.NumberKey;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class TurbineGroupManagement
extends TurbineBaseService
implements GroupManagement {
    private JetspeedRunDataService runDataService = null;
    private static final String CONFIG_DEFAULT_ROLE = "role.default";
    String defaultRole = "user";
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private boolean cascadeDelete;

    public Iterator getGroups(String username) throws JetspeedSecurityException {
        HashMap<String, TurbineGroup> groups;
        JetspeedUser user = null;
        try {
            user = JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new GroupException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)user.getUserId());
        try {
            List rels = TurbineUserGroupRolePeer.doSelect(criteria);
            groups = rels.size() > 0 ? new HashMap(rels.size()) : new HashMap<String, TurbineGroup>();
            for (int ix = 0; ix < rels.size(); ++ix) {
                TurbineUserGroupRole rel = (TurbineUserGroupRole)((Object)rels.get(ix));
                TurbineGroup group = rel.getTurbineGroup();
                groups.put(group.getName(), group);
            }
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", e);
        }
        return groups.values().iterator();
    }

    public Iterator getGroups() throws JetspeedSecurityException {
        List groups;
        Criteria criteria = new Criteria();
        try {
            groups = TurbineGroupPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve groups ", e);
        }
        return groups.iterator();
    }

    public void addGroup(Group group) throws JetspeedSecurityException {
        if (this.groupExists(group.getName())) {
            throw new GroupException("The group '" + group.getName() + "' already exists");
        }
        try {
            TurbineGroup tgroup = new TurbineGroup();
            tgroup.setGroupName(group.getName());
            Criteria criteria = TurbineGroupPeer.buildCriteria(tgroup);
            NumberKey key = (NumberKey)TurbineGroupPeer.doInsert(criteria);
            group.setId(key.toString());
        }
        catch (Exception e) {
            throw new GroupException("Failed to create group '" + group.getName() + "'", e);
        }
        try {
            this.addDefaultGroupPSML(group);
        }
        catch (Exception e) {
            try {
                this.removeGroup(group.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GroupException("failed to add default PSML for Group resource", e);
        }
    }

    protected void addDefaultGroupPSML(Group group) throws GroupException {
        try {
            JetspeedRunDataService runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
            JetspeedRunData rundata = runDataService.getCurrentRunData();
            Profile profile = Profiler.createProfile();
            profile.setGroup(group);
            profile.setMediaType("html");
            Profiler.createProfile((RunData)rundata, profile);
        }
        catch (ProfileException e) {
            try {
                this.removeGroup(group.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GroupException("Failed to create Group PSML", e);
        }
    }

    public void saveGroup(Group group) throws JetspeedSecurityException {
        if (!this.groupExists(group.getName())) {
            throw new GroupException("The group '" + group.getName() + "' doesn't exists");
        }
        try {
            if (!(group instanceof TurbineGroup)) {
                throw new GroupException("TurbineGroupManagment: Group is not a Turbine group, cannot update");
            }
            TurbineGroupPeer.doUpdate((TurbineGroup)group);
        }
        catch (Exception e) {
            throw new GroupException("Failed to create group '" + group.getName() + "'", e);
        }
    }

    public void removeGroup(String groupname) throws JetspeedSecurityException {
        Connection conn = null;
        try {
            conn = Torque.getConnection();
            Group group = this.getGroup(groupname);
            Criteria criteria = new Criteria();
            criteria.add(TurbineGroupPeer.GROUP_NAME, (Object)groupname);
            if (this.cascadeDelete) {
                Criteria criteria1 = new Criteria();
                criteria1.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)group.getId());
                TurbineUserGroupRolePeer.doDelete(criteria1, conn);
            }
            TurbineGroupPeer.doDelete(criteria, conn);
            PsmlManager.removeGroupDocuments(group);
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException sqle) {
                Log.error((Throwable)sqle);
            }
            throw new GroupException("Failed to remove group '" + groupname + "'", e);
        }
        finally {
            try {
                Torque.closeConnection((Connection)conn);
            }
            catch (Exception e) {}
        }
    }

    public void joinGroup(String username, String groupname) throws JetspeedSecurityException {
        this.joinGroup(username, groupname, this.defaultRole);
    }

    public void joinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Group group = this.getGroup(groupname);
            Role role = JetspeedSecurity.getRole(rolename);
            Criteria criteria = new Criteria();
            criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)user.getUserId());
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)group.getId());
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)role.getId());
            TurbineUserGroupRolePeer.doInsert(criteria);
        }
        catch (Exception e) {
            throw new GroupException("Join group '" + groupname + "' to user '" + username + "' failed: ", e);
        }
    }

    public void unjoinGroup(String username, String groupname) throws JetspeedSecurityException {
        this.unjoinGroup(username, groupname, this.defaultRole);
    }

    public void unjoinGroup(String username, String groupname, String rolename) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Group group = this.getGroup(groupname);
            Role role = JetspeedSecurity.getRole(rolename);
            Criteria criteria = new Criteria();
            criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)user.getUserId());
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)group.getId());
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)role.getId());
            TurbineUserGroupRolePeer.doDelete(criteria);
        }
        catch (Exception e) {
            throw new GroupException("Unjoin group '" + groupname + "' to user '" + username + "' failed: ", e);
        }
    }

    public boolean inGroup(String username, String groupname) throws JetspeedSecurityException {
        List groups;
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Group group = this.getGroup(groupname);
            Criteria criteria = new Criteria();
            criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)user.getUserId());
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)group.getId());
            groups = TurbineUserGroupRolePeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new GroupException("Failed to check group '" + groupname + "'", e);
        }
        return groups.size() > 0;
    }

    public Group getGroup(String groupname) throws JetspeedSecurityException {
        List groups;
        try {
            Criteria criteria = new Criteria();
            criteria.add(TurbineGroupPeer.GROUP_NAME, (Object)groupname);
            groups = TurbineGroupPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new GroupException("Failed to retrieve group '" + groupname + "'", e);
        }
        if (groups.size() > 1) {
            throw new GroupException("Multiple Groups with same groupname '" + groupname + "'");
        }
        if (groups.size() == 1) {
            TurbineGroup group = (TurbineGroup)groups.get(0);
            return group;
        }
        throw new GroupException("Unknown group '" + groupname + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean groupExists(String groupName) throws GroupException {
        List groups;
        Criteria criteria = new Criteria();
        criteria.add(TurbineGroupPeer.GROUP_NAME, (Object)groupName);
        try {
            groups = TurbineGroupPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new GroupException("Failed to check account's presence", e);
        }
        return groups.size() >= 1;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.defaultRole = serviceConf.getString(CONFIG_DEFAULT_ROLE, this.defaultRole);
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.setInit(true);
    }
}

