/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.urlmanager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.urlmanager.URLInfo;
import org.apache.jetspeed.services.urlmanager.URLManagerService;
import org.apache.turbine.services.TurbineBaseService;

public class JetspeedURLManagerService
extends TurbineBaseService
implements URLManagerService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedURLManagerService.class.getName());
    private Map urls = new HashMap();
    private String path = null;
    private final Hashtable proxies = new Hashtable();

    public void init() {
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                logger.info("URLManager service: Waiting for init()...");
            }
        }
    }

    public synchronized void init(ServletConfig config) {
        if (this.getInit()) {
            return;
        }
        try {
            logger.info("JetspeedURLManagerService early init()....starting!");
            String prefix = "services.URLManager.proxy.";
            Iterator resourceKeys = JetspeedResources.getKeys((String)prefix);
            Object hashValue = null;
            while (resourceKeys.hasNext()) {
                String key = (String)resourceKeys.next();
                String hashKey = key.substring(prefix.length()).toLowerCase();
                if (hashKey.endsWith(".host")) {
                    hashValue = JetspeedResources.getString(key);
                    this.proxies.put(hashKey, hashValue);
                    continue;
                }
                if (!hashKey.endsWith(".port")) continue;
                hashValue = new Integer(JetspeedResources.getInt(key));
                this.proxies.put(hashKey, hashValue);
            }
            this.path = JetspeedResources.getString("services.URLManager.url");
            if (this.path == null) {
                String tempdir = new String("WEB-INF/conf/datasources.properties");
                String ps = System.getProperty("file.separator");
                try {
                    ServletContext sc = config.getServletContext();
                    tempdir = sc.getAttribute("javax.servlet.context.tempdir").toString() + ps + "jetspeed" + ps + "conf" + ps + "datasources.properties";
                    logger.debug("URLMangler: will create file in servlet temp directory " + tempdir);
                }
                catch (Exception e) {
                    logger.debug("URLMangler: problems creating file in servlet temp directory  falling back to WEB-INF/conf : " + e);
                }
                this.path = tempdir;
            } else {
                logger.debug("URLMangler: will create file in user configured " + this.path);
                this.path = config.getServletContext().getRealPath(this.path);
            }
            this.load();
            logger.info("JetspeedURLManagerService early init()....finished!");
        }
        catch (Throwable t) {
            logger.error("Cannot initialize JetspeedURLManagerService!", t);
        }
        this.setInit(true);
    }

    public void shutdown() {
        this.save();
    }

    public void register(String url) {
        URLInfo info;
        if (url != null && (info = this.getInfo(url)) == null) {
            this.register(new URLInfo(url, 1));
        }
    }

    public void register(String url, int status) {
        if (url != null) {
            URLInfo info = this.getInfo(url);
            if (info == null) {
                this.register(new URLInfo(url, status));
            } else {
                info.setStatus(status);
            }
        }
    }

    public void register(String url, int status, String message) {
        if (url != null) {
            URLInfo info = this.getInfo(url);
            if (info == null) {
                this.register(new URLInfo(url, status, message));
            } else {
                info.setStatus(status);
                info.setMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(URLInfo info) {
        if (info != null) {
            Map map = this.urls;
            synchronized (map) {
                if (this.getInfo(info.getURL()) == null) {
                    this.urls.put(info.getURL().intern(), info);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String url) {
        if (url != null) {
            Map map = this.urls;
            synchronized (map) {
                this.urls.remove(url.intern());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLInfo getInfo(String url) {
        URLInfo info = null;
        if (url != null) {
            Map map = this.urls;
            synchronized (map) {
                info = (URLInfo)this.urls.get(url.intern());
            }
        }
        return info;
    }

    public boolean isOK(String url) {
        URLInfo info = this.getInfo(url);
        if (info == null) {
            return true;
        }
        return info.getStatus() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() {
        Map map = this.urls;
        synchronized (map) {
            return new Vector(this.urls.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(int status) {
        Vector result = new Vector();
        Map map = this.urls;
        synchronized (map) {
            for (Map.Entry entry : this.urls.entrySet()) {
                URLInfo info = (URLInfo)entry.getValue();
                if ((info.getStatus() & status) == 0) continue;
                result.addElement(entry.getKey());
            }
        }
        return result;
    }

    private synchronized void load() {
        HashMap store = new HashMap();
        logger.info("Restoring the URLs from disk: " + this.path);
        this.urls = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void save() {
        PrintWriter pw = null;
        try {
            File propfile = new File(this.path);
            propfile.getParentFile().mkdirs();
            propfile.createNewFile();
            pw = new PrintWriter(new BufferedWriter(new FileWriter(propfile)));
            Map map = this.urls;
            synchronized (map) {
                Iterator i = this.urls.values().iterator();
                int entryNum = 1;
                while (i.hasNext()) {
                    URLInfo info = (URLInfo)i.next();
                    pw.print("entry.");
                    pw.print(entryNum);
                    pw.print(".url=");
                    this.writeEscaped(pw, info.getURL());
                    pw.println("");
                    pw.print("entry.");
                    pw.print(entryNum);
                    pw.print(".status=");
                    pw.print(info.getStatus());
                    pw.println("");
                    ++entryNum;
                }
            }
        }
        catch (Throwable t) {
            logger.error("Impossible to save URLManager state to " + this.path, t);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public int getProxyPort(String protocol) {
        Integer proxyPort = (Integer)this.proxies.get((protocol + ".port").toLowerCase());
        if (proxyPort != null) {
            return proxyPort;
        }
        return -1;
    }

    public String getProxyHost(String protocol) {
        String proxyHost = (String)this.proxies.get((protocol + ".host").toLowerCase());
        return proxyHost;
    }

    protected void writeEscaped(PrintWriter sink, String element) {
        int upTo = element.indexOf(",");
        if (upTo == -1) {
            sink.print(element);
            return;
        }
        sink.print(element.substring(0, upTo));
        sink.print("\\,");
        this.writeEscaped(sink, element.substring(upTo + 1, element.length()));
    }
}

